/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile.constants;

import com.sun.javacard.classfile.constants.JConstant;
import com.sun.javacard.classfile.constants.JConstantClass;
import com.sun.javacard.classfile.constants.JConstantDouble;
import com.sun.javacard.classfile.constants.JConstantFieldRef;
import com.sun.javacard.classfile.constants.JConstantFloat;
import com.sun.javacard.classfile.constants.JConstantInteger;
import com.sun.javacard.classfile.constants.JConstantInterfaceMethodRef;
import com.sun.javacard.classfile.constants.JConstantLong;
import com.sun.javacard.classfile.constants.JConstantMethodRef;
import com.sun.javacard.classfile.constants.JConstantNameAndType;
import com.sun.javacard.classfile.constants.JConstantString;
import com.sun.javacard.classfile.constants.JConstantUtf8;
import java.io.DataInputStream;
import java.io.IOException;

public class JConstantPool {
    private JConstant[] constants;

    public JConstantPool(int size) {
        this.constants = new JConstant[size];
    }

    public JConstant getAt(int index) {
        return this.constants[index];
    }

    public JConstantClass getConstantClass(int index) {
        JConstant constant = this.getAt(index);
        if (constant instanceof JConstantClass) {
            return (JConstantClass)constant;
        }
        return null;
    }

    public JConstantDouble getConstantDouble(int index) {
        JConstant constant = this.getAt(index);
        if (constant instanceof JConstantDouble) {
            return (JConstantDouble)constant;
        }
        return null;
    }

    public JConstantFieldRef getConstantFieldRef(int index) {
        JConstant constant = this.getAt(index);
        if (constant instanceof JConstantFieldRef) {
            return (JConstantFieldRef)constant;
        }
        return null;
    }

    public JConstantFloat getConstantFloat(int index) {
        JConstant constant = this.getAt(index);
        if (constant instanceof JConstantFloat) {
            return (JConstantFloat)constant;
        }
        return null;
    }

    public JConstantInteger getConstantInteger(int index) {
        JConstant constant = this.getAt(index);
        if (constant instanceof JConstantInteger) {
            return (JConstantInteger)constant;
        }
        return null;
    }

    public JConstantInterfaceMethodRef getConstantInterfaceMethodRef(int index) {
        JConstant constant = this.getAt(index);
        if (constant instanceof JConstantInterfaceMethodRef) {
            return (JConstantInterfaceMethodRef)constant;
        }
        return null;
    }

    public JConstantLong getConstantLong(int index) {
        JConstant constant = this.getAt(index);
        if (constant instanceof JConstantLong) {
            return (JConstantLong)constant;
        }
        return null;
    }

    public JConstantMethodRef getConstantMethodRef(int index) {
        JConstant constant = this.getAt(index);
        if (constant instanceof JConstantMethodRef) {
            return (JConstantMethodRef)constant;
        }
        return null;
    }

    public JConstantNameAndType getConstantNameAndType(int index) {
        JConstant constant = this.getAt(index);
        if (constant instanceof JConstantNameAndType) {
            return (JConstantNameAndType)constant;
        }
        return null;
    }

    public JConstantString getConstantString(int index) {
        JConstant constant = this.getAt(index);
        if (constant instanceof JConstantString) {
            return (JConstantString)constant;
        }
        return null;
    }

    public JConstantUtf8 getConstantUtf8(int index) {
        JConstant constant = this.getAt(index);
        if (constant instanceof JConstantUtf8) {
            return (JConstantUtf8)constant;
        }
        return null;
    }

    public JConstant[] getConstants() {
        return this.constants;
    }

    public void parse(DataInputStream dis) throws IOException {
        int i = 1;
        while (i < this.constants.length) {
            int tag = dis.readUnsignedByte();
            this.constants[i] = JConstant.create(tag, this);
            this.constants[i].parse(dis);
            if (tag == 6 || tag == 5) {
                ++i;
            }
            ++i;
        }
    }

    public void resolve() {
        int i = 1;
        while (i < this.constants.length) {
            if (this.constants[i] != null) {
                this.constants[i].resolve();
            }
            ++i;
        }
    }
}

