/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.instructions.JInstrByteIndex;
import com.sun.javacard.classfile.instructions.JInstrClassRef;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.constants.JcConstantClassRef;
import com.sun.javacard.jcfile.constants.JcConstantPool;
import com.sun.javacard.jcfile.instructions.JcInstrByteIndex;
import com.sun.javacard.jcfile.instructions.JcInstrClassRef;
import com.sun.javacard.jcfile.instructions.JcInstrNoOperands;
import com.sun.javacard.jcfile.instructions.JcInstruction;

class InstrArrayConverter
extends InstructionConverter {
    public InstrArrayConverter(InstrContainer instr_container, MethodConverter method_converter) {
        super(instr_container, method_converter);
    }

    private void checkArrayCountOrIndexType(OperandStackEntry entry) throws Exception {
        String class_name = this.method_converter.getClassName();
        if (entry.getType() == 3) {
            Notifier.error(this.java_instr.getSourceLineNumber(), "int.20", class_name.replace('/', '.'));
            throw new ConversionException();
        }
        if (entry.hasOverflowPotential()) {
            Notifier.error(this.java_instr.getSourceLineNumber(), "int.20", class_name.replace('/', '.'));
            throw new ConversionException();
        }
    }

    public JcInstruction convert() throws Exception {
        int java_opcode = this.java_instr.getOpcode();
        switch (java_opcode) {
            case 188: {
                OperandStackEntry count_entry = this.operand_stack.pop();
                this.checkArrayCountOrIndexType(count_entry);
                int j_atype = ((JInstrByteIndex)this.java_instr).getIndex();
                if (j_atype == 10) {
                    String class_name = this.method_converter.getClassName();
                    if (this.method_converter.getPackageConverter().isIntSupported()) {
                        Notifier.warning(this.java_instr.getSourceLineNumber(), "warning.4", class_name.replace('/', '.'));
                        this.method_converter.getPackageConverter().setIntFlag(true);
                    } else {
                        Notifier.error(this.java_instr.getSourceLineNumber(), "int.4", class_name.replace('/', '.'));
                        throw new ConversionException();
                    }
                }
                int jc_atype = this.getAtype(j_atype);
                this.jc_instr = new JcInstrByteIndex(144, jc_atype);
                this.operand_stack.push(10, this.instr_container);
                return this.jc_instr;
            }
            case 189: {
                OperandStackEntry index_entry = this.operand_stack.pop();
                this.checkArrayCountOrIndexType(index_entry);
                String class_name = ((JInstrClassRef)this.java_instr).getClassName();
                JcConstantPool jc_cp = this.method_converter.getJcConstantPool();
                JcConstantClassRef jc_const_classref = jc_cp.addConstantClassRef(class_name);
                this.jc_instr = new JcInstrClassRef(145, jc_const_classref);
                this.operand_stack.push(10, this.instr_container);
                return this.jc_instr;
            }
            case 51: {
                OperandStackEntry index_entry = this.operand_stack.pop();
                this.operand_stack.pop();
                this.checkArrayCountOrIndexType(index_entry);
                this.jc_instr = new JcInstrNoOperands(37);
                this.operand_stack.push(1, this.instr_container);
                return this.jc_instr;
            }
            case 53: {
                OperandStackEntry index_entry = this.operand_stack.pop();
                this.operand_stack.pop();
                this.checkArrayCountOrIndexType(index_entry);
                this.jc_instr = new JcInstrNoOperands(38);
                this.operand_stack.push(2, this.instr_container);
                return this.jc_instr;
            }
            case 50: {
                OperandStackEntry index_entry = this.operand_stack.pop();
                this.operand_stack.pop();
                this.checkArrayCountOrIndexType(index_entry);
                this.jc_instr = new JcInstrNoOperands(36);
                this.operand_stack.push(10, this.instr_container);
                return this.jc_instr;
            }
            case 46: {
                OperandStackEntry index_entry = this.operand_stack.pop();
                this.operand_stack.pop();
                this.checkArrayCountOrIndexType(index_entry);
                String class_name = this.method_converter.getClassName();
                if (!this.method_converter.isIntSupported()) {
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.5", class_name.replace('/', '.'));
                    throw new ConversionException();
                }
                Notifier.warning(this.java_instr.getSourceLineNumber(), "warning.5", class_name.replace('/', '.'));
                this.method_converter.getPackageConverter().setIntFlag(true);
                this.jc_instr = new JcInstrNoOperands(39);
                this.operand_stack.push(3, this.instr_container);
                return this.jc_instr;
            }
            case 84: {
                OperandStackEntry value_entry = this.operand_stack.pop();
                OperandStackEntry index_entry = this.operand_stack.pop();
                this.operand_stack.pop();
                this.checkArrayCountOrIndexType(index_entry);
                this.jc_instr = new JcInstrNoOperands(56);
                return this.jc_instr;
            }
            case 86: {
                OperandStackEntry value_entry = this.operand_stack.pop();
                OperandStackEntry index_entry = this.operand_stack.pop();
                this.operand_stack.pop();
                this.checkArrayCountOrIndexType(index_entry);
                this.jc_instr = new JcInstrNoOperands(57);
                return this.jc_instr;
            }
            case 83: {
                OperandStackEntry value_entry = this.operand_stack.pop();
                OperandStackEntry index_entry = this.operand_stack.pop();
                this.operand_stack.pop();
                this.checkArrayCountOrIndexType(index_entry);
                this.jc_instr = new JcInstrNoOperands(55);
                return this.jc_instr;
            }
            case 79: {
                OperandStackEntry value_entry = this.operand_stack.pop();
                OperandStackEntry index_entry = this.operand_stack.pop();
                this.operand_stack.pop();
                this.checkArrayCountOrIndexType(index_entry);
                String class_name = this.method_converter.getClassName();
                if (!this.method_converter.isIntSupported()) {
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.5", class_name.replace('/', '.'));
                    throw new ConversionException();
                }
                Notifier.warning(this.java_instr.getSourceLineNumber(), "warning.5", class_name.replace('/', '.'));
                this.method_converter.getPackageConverter().setIntFlag(true);
                if (value_entry.getType() != 3) {
                    value_entry.rollBack();
                }
                this.jc_instr = new JcInstrNoOperands(58);
                return this.jc_instr;
            }
            case 190: {
                this.operand_stack.pop();
                this.jc_instr = new JcInstrNoOperands(146);
                this.operand_stack.push(2, this.instr_container);
                return this.jc_instr;
            }
        }
        throw new ConverterInternalError();
    }

    private int getAtype(int j_aType) throws Exception {
        switch (j_aType) {
            case 4: {
                return 10;
            }
            case 8: {
                return 11;
            }
            case 9: {
                return 12;
            }
            case 10: {
                return 13;
            }
        }
        throw new ConversionException("not supported type");
    }
}

