/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.attributes.JCodeAttr;
import com.sun.javacard.classfile.attributes.JLocalVarTableAttr;
import com.sun.javacard.classfile.attributes.JLocalVariable;
import com.sun.javacard.classfile.instructions.JInstruction;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.JcLocalVariable;

public class LocalVariableConverter {
    private static final int INTEGRAL_TYPE = 1;
    private static final int REFERENCE_TYPE = 2;
    private MethodConverter method_converter;
    private JcLocalVariable[] jc_locals;
    private int defined_local_size = 0;
    private int undefined_local_size = 0;

    public LocalVariableConverter(MethodConverter method_converter) {
        this.method_converter = method_converter;
    }

    private JcLocalVariable addUndefinedLocalVariable(int j_index, JInstruction java_instr) {
        int opcode = java_instr.getOpcode();
        int type = this.getOpcodeType(opcode);
        if (!this.method_converter.isIntSupported()) {
            if (type == 2) {
                return new JcLocalVariable("undefined", "L", j_index, j_index);
            }
            return new JcLocalVariable("undefined", "S", j_index, j_index);
        }
        if (j_index * 2 >= this.undefined_local_size) {
            this.undefined_local_size = (j_index + 1) * 2;
        }
        int jc_index = this.defined_local_size + j_index * 2;
        if (type == 1) {
            return new JcLocalVariable("undefined", "I", j_index, jc_index);
        }
        return new JcLocalVariable("undefined", "L", j_index, jc_index);
    }

    private void checkParameters() throws Exception {
        String method_desc = this.method_converter.getJavaMethod().getMethodDescriptor();
        String[] param_descs = MethodDescriptor.getParamDescriptors(method_desc);
        if (param_descs.length != 0) {
            Notifier.error("conversion.20", this.method_converter.getClassName().replace('/', '.'));
            throw new ConversionException();
        }
    }

    private int computeJcIndex(JcLocalVariable jc_local) {
        int j_index = jc_local.getJIndex();
        if (j_index == 0) {
            return 0;
        }
        JcLocalVariable prev_local = this.jc_locals[j_index - 1];
        int cur_index = 2;
        while (prev_local == null) {
            if (j_index - cur_index < 0) {
                return 0;
            }
            prev_local = this.jc_locals[j_index - cur_index];
            ++cur_index;
        }
        int jc_index = 0;
        while (prev_local != null) {
            int prev_jc_index = prev_local.getJcIndex();
            if (prev_local.getDescriptor().equals("I")) {
                if (jc_index < prev_jc_index + 2) {
                    jc_index = prev_jc_index + 2;
                }
            } else if (jc_index < prev_jc_index + 1) {
                jc_index = prev_jc_index + 1;
            }
            prev_local = prev_local.getNext();
        }
        return jc_index;
    }

    private void constructLocalVariables() throws Exception {
        JCodeAttr code_attr = this.method_converter.getJavaMethod().getCodeAttr();
        if (code_attr == null) {
            this.jc_locals = new JcLocalVariable[0];
            return;
        }
        JLocalVarTableAttr java_local_var_table = code_attr.getLocalVarTableAttr();
        if (java_local_var_table == null) {
            if (this.method_converter.isIntSupported()) {
                this.checkParameters();
            }
            this.jc_locals = new JcLocalVariable[0];
            return;
        }
        JLocalVariable[] java_locals = java_local_var_table.getLocalVars();
        int max_j_local_index = -1;
        int i = 0;
        while (i < java_locals.length) {
            if (max_j_local_index < java_locals[i].getIndex()) {
                max_j_local_index = java_locals[i].getIndex();
            }
            ++i;
        }
        this.jc_locals = new JcLocalVariable[max_j_local_index + 1];
        int i2 = 0;
        while (i2 < this.jc_locals.length) {
            this.jc_locals[i2] = null;
            ++i2;
        }
        int i3 = 0;
        while (i3 < java_locals.length) {
            JcLocalVariable jc_local = new JcLocalVariable(java_locals[i3]);
            int index = java_locals[i3].getIndex();
            jc_local.setNext(this.jc_locals[index]);
            this.jc_locals[index] = jc_local;
            ++i3;
        }
    }

    public JcLocalVariable[] convert() throws Exception {
        this.constructLocalVariables();
        int index = 0;
        while (index < this.jc_locals.length) {
            JcLocalVariable jc_local = this.jc_locals[index];
            while (jc_local != null) {
                int jc_index = this.computeJcIndex(jc_local);
                jc_local.setJcIndex(jc_index);
                jc_local = jc_local.getNext();
            }
            ++index;
        }
        if (this.jc_locals.length == 0) {
            this.defined_local_size = 0;
        } else {
            JcLocalVariable last_local = this.jc_locals[this.jc_locals.length - 1];
            while (last_local != null) {
                int size = DataType.getSize(last_local.getDescriptor());
                if (this.defined_local_size < last_local.getJcIndex() + size) {
                    this.defined_local_size = last_local.getJcIndex() + size;
                }
                last_local = last_local.getNext();
            }
        }
        return this.jc_locals;
    }

    public int getDefinedLocalVariablesSize() {
        return this.defined_local_size;
    }

    public JcLocalVariable getJcLocalVariable(int j_index, JInstruction java_instr) {
        if (j_index >= this.jc_locals.length) {
            return this.addUndefinedLocalVariable(j_index, java_instr);
        }
        JcLocalVariable local = this.jc_locals[j_index];
        int pc = java_instr.getPC();
        while (local != null) {
            int j_start_pc = local.getJStartPC() - 2;
            int j_length = local.getJLength() + 2;
            if (j_start_pc <= pc && pc <= j_start_pc + j_length) {
                return local;
            }
            local = local.getNext();
        }
        return this.addUndefinedLocalVariable(j_index, java_instr);
    }

    private int getOpcodeType(int opcode) {
        switch (opcode) {
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 132: 
            case 196: {
                return 1;
            }
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 169: {
                return 2;
            }
        }
        throw new ClassFormatError();
    }

    public int getUndefinedLocalVariablesSize() {
        return this.undefined_local_size;
    }
}

