/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugcomponent;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.debugcomponent.DebugComponent;
import com.sun.javacard.debugcomponent.FieldDebugInfo;
import com.sun.javacard.debugcomponent.MethodDebugInfo;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcMethod;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;

public class ClassDebugInfo
extends ClassDefinition {
    private static final int ACC_SHAREABLE = 2048;
    private int name_index;
    private int location;
    private int superclass_name_index;
    private int[] interface_names_index;
    private int source_file_name_index;
    FieldDebugInfo[] fields;
    MethodDebugInfo[] methods;

    public ClassDebugInfo(JcClass jc_class, DebugComponent debug_comp) {
        super(jc_class);
        this.build(jc_class, debug_comp);
    }

    private void build(JcClass jc_class, DebugComponent debug_comp) {
        this.name_index = debug_comp.addString(this.class_name);
        this.superclass_name_index = this.super_class_name == null ? debug_comp.addString("null") : debug_comp.addString(this.super_class_name);
        if (this.source_file_name == null) {
            throw new RuntimeException();
        }
        if (jc_class.isShareableType()) {
            this.access_flags |= 0x800;
        }
        this.source_file_name_index = debug_comp.addString(this.source_file_name);
        String[] interface_names = jc_class.getSuperInterfaces();
        this.interface_names_index = new int[interface_names.length];
        int i = 0;
        while (i < interface_names.length) {
            this.interface_names_index[i] = debug_comp.addString(interface_names[i]);
            ++i;
        }
        JcField[] jc_fields = jc_class.getFields();
        this.fields = new FieldDebugInfo[jc_fields.length];
        int i2 = 0;
        while (i2 < jc_fields.length) {
            this.fields[i2] = new FieldDebugInfo(jc_fields[i2], debug_comp);
            ++i2;
        }
        JcMethod[] jc_methods = jc_class.getMethods();
        this.methods = new MethodDebugInfo[jc_methods.length];
        int i3 = 0;
        while (i3 < jc_methods.length) {
            this.methods[i3] = new MethodDebugInfo(jc_methods[i3], debug_comp);
            ++i3;
        }
    }

    public int getSize() {
        int size = 0;
        int i = 0;
        while (i < this.fields.length) {
            size += this.fields[i].getSize();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.methods.length) {
            size += this.methods[i2].getSize();
            ++i2;
        }
        return size + 15 + this.interface_names_index.length * 2;
    }

    public void toBinary(DataOutputStream dos) throws IOException {
        dos.writeShort(this.name_index);
        dos.writeShort(this.access_flags);
        dos.writeShort(this.location);
        dos.writeShort(this.superclass_name_index);
        dos.writeShort(this.source_file_name_index);
        dos.writeByte(this.interface_names_index.length);
        dos.writeShort(this.fields.length);
        dos.writeShort(this.methods.length);
        int i = 0;
        while (i < this.interface_names_index.length) {
            dos.writeShort(this.interface_names_index[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.fields.length) {
            this.fields[i2].toBinary(dos);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.methods.length) {
            this.methods[i3].toBinary(dos);
            ++i3;
        }
        dos.flush();
    }

    public void toText(PrintWriter pw, int tab_level) throws IOException {
        int i;
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < tab_level) {
            sb.append("\t");
            ++i2;
        }
        String indent = sb.toString();
        pw.println(String.valueOf(indent) + "class_debug_info { ");
        pw.println(String.valueOf(indent) + "\tname_index " + this.name_index + "\t\t//" + this.class_name);
        if ((this.access_flags & 0x800) != 0) {
            pw.print(String.valueOf(indent) + "\taccess_flags " + Modifier.toString(this.access_flags & 0xFFFFF7FF));
            pw.println(" shareable");
        } else {
            pw.println(String.valueOf(indent) + "\taccess_flags " + Modifier.toString(this.access_flags));
        }
        pw.println(String.valueOf(indent) + "\tlocation " + this.location);
        pw.println(String.valueOf(indent) + "\tsuperclass_name_index " + this.superclass_name_index + "\t\t//" + this.super_class_name);
        pw.println(String.valueOf(indent) + "\tsource_file_name_index " + this.source_file_name_index + "\t\t//" + this.source_file_name);
        pw.println(String.valueOf(indent) + "\tinterface_count " + this.interface_names_index.length);
        pw.println(String.valueOf(indent) + "\tfield_count " + this.fields.length);
        pw.println(String.valueOf(indent) + "\tmethod_count " + this.methods.length);
        if (this.interface_names_index.length != 0) {
            pw.print(String.valueOf(indent) + "\tinterface_names_index ");
            i = 0;
            while (i < this.interface_names_index.length) {
                pw.print(String.valueOf(this.interface_names_index[i]) + " ");
                ++i;
            }
            pw.println();
        }
        i = 0;
        while (i < this.fields.length) {
            this.fields[i].toText(pw, tab_level + 1);
            ++i;
        }
        int i3 = 0;
        while (i3 < this.methods.length) {
            this.methods[i3].toText(pw, tab_level + 1);
            ++i3;
        }
        pw.println(String.valueOf(indent) + "}");
        pw.flush();
    }
}

