/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugcomponent;

import com.sun.javacard.basicstructure.PackageDefinition;
import com.sun.javacard.debugcomponent.ClassDebugInfo;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcPackage;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class DebugComponent
extends PackageDefinition {
    private int component_tag = -37;
    private byte[] component_aid;
    private int major_version;
    private byte minor_version;
    private int package_index;
    ClassDebugInfo[] classes;
    Vector utf8_strings;

    public DebugComponent(JcPackage jc_package) {
        super(jc_package);
        byte[] byArray = new byte[9];
        byArray[0] = -96;
        byArray[4] = 98;
        byArray[5] = 3;
        byArray[6] = 5;
        byArray[7] = 1;
        byArray[8] = 1;
        this.component_aid = byArray;
        this.major_version = 0;
        this.minor_version = (byte)10;
        this.build(jc_package);
    }

    public int addString(String a_string) {
        int i = 0;
        while (i < this.utf8_strings.size()) {
            String this_string = (String)this.utf8_strings.elementAt(i);
            if (this_string.equals(a_string)) {
                return i;
            }
            ++i;
        }
        this.utf8_strings.addElement(a_string);
        return this.utf8_strings.size() - 1;
    }

    private void build(JcPackage jc_package) {
        this.utf8_strings = new Vector(20, 10);
        this.package_index = this.addString(this.package_name);
        JcClass[] jc_classes = jc_package.getClasses();
        this.classes = new ClassDebugInfo[jc_classes.length];
        int i = 0;
        while (i < jc_classes.length) {
            this.classes[i] = new ClassDebugInfo(jc_classes[i], this);
            ++i;
        }
    }

    public byte[] getDebugCompInfo() {
        int size = 4 + this.component_aid.length;
        byte[] info = new byte[size];
        info[0] = (byte)this.component_tag;
        int compSize = this.getSize();
        info[1] = (byte)(compSize >> 8);
        info[2] = (byte)compSize;
        info[3] = (byte)this.component_aid.length;
        int i = 0;
        while (i < this.component_aid.length) {
            info[4 + i] = this.component_aid[i];
            ++i;
        }
        return info;
    }

    public int getSize() {
        int size = 0;
        int i = 0;
        while (i < this.classes.length) {
            size += this.classes[i].getSize();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.utf8_strings.size()) {
            String utf8_string = (String)this.utf8_strings.elementAt(i2);
            byte[] utf8_bytes = utf8_string.getBytes();
            size = size + 2 + utf8_bytes.length;
            ++i2;
        }
        return size + 9 + this.component_aid.length;
    }

    public void toBinary(DataOutputStream dos) throws IOException {
        dos.writeByte(this.component_tag);
        dos.writeShort(this.getSize());
        dos.writeByte(this.component_aid.length);
        dos.write(this.component_aid, 0, this.component_aid.length);
        dos.writeByte(this.minor_version);
        dos.writeByte(this.major_version);
        dos.writeShort(this.utf8_strings.size());
        int i = 0;
        while (i < this.utf8_strings.size()) {
            String utf8_string = (String)this.utf8_strings.elementAt(i);
            dos.writeUTF(utf8_string);
            ++i;
        }
        dos.writeShort(this.package_index);
        dos.writeShort(this.classes.length);
        int i2 = 0;
        while (i2 < this.classes.length) {
            this.classes[i2].toBinary(dos);
            ++i2;
        }
        dos.flush();
    }

    public void toText(PrintWriter pw) throws IOException {
        int tab_level = 0;
        pw.println("debug_component { ");
        pw.println("\ttag " + Integer.toHexString(this.component_tag & 0xFF));
        pw.println("\tsize " + this.getSize());
        pw.println("\tcomponent_AID_length " + this.component_aid.length);
        pw.print("\tcomponent_AID ");
        int i = 0;
        while (i < this.component_aid.length) {
            pw.print(Integer.toHexString(this.component_aid[i] & 0xFF));
            if (i != this.component_aid.length - 1) {
                pw.print(":");
            }
            ++i;
        }
        pw.println();
        pw.println("\tminor_version " + this.minor_version);
        pw.println("\tmajor_version " + this.major_version);
        pw.println("\tstring_count " + this.utf8_strings.size());
        int i2 = 0;
        while (i2 < this.utf8_strings.size()) {
            pw.println("\tutf8_info { ");
            String utf8_string = (String)this.utf8_strings.elementAt(i2);
            byte[] utf8_bytes = utf8_string.getBytes("UTF8");
            pw.println("\t\t utf8_string " + utf8_string);
            pw.println("\t\t utf8_bytes_length " + utf8_bytes.length);
            pw.print("\t\tutf8_bytes ");
            int j = 0;
            while (j < utf8_bytes.length) {
                pw.print(utf8_bytes[j]);
                if (j != utf8_bytes.length - 1) {
                    pw.print(":");
                }
                ++j;
            }
            pw.println("\t}");
            ++i2;
        }
        pw.println("\tpackage_name_index " + this.package_index + "\t\t//" + this.package_name);
        pw.println("\tclass_count " + this.classes.length);
        int i3 = 0;
        while (i3 < this.classes.length) {
            this.classes[i3].toText(pw, tab_level + 1);
            ++i3;
        }
        pw.println("}");
        pw.flush();
    }
}

