/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.PackageIdentifier;

public class InstanceFieldRefInfo
extends Info {
    protected int instanceFieldToken;

    InstanceFieldRefInfo(PackageIdentifier packageId, int classToken, int instanceFieldToken, String descriptor) {
        super(2, packageId, classToken, descriptor);
        this.instanceFieldToken = instanceFieldToken;
    }

    InstanceFieldRefInfo(PackageIdentifier packageId, String name, String descriptor) {
        super(2, packageId, name, descriptor);
    }

    public int getInstanceFieldToken() {
        return this.instanceFieldToken;
    }

    public byte[] toByteArray(JCPackage p) {
        byte[] array = super.toByteArray(p);
        if (this.isPackageInternal()) {
            Field field = (Field)this.resolvedTo;
            int addr = field.getParentClass().getRelocAddr();
            array[1] = (byte)(addr >> 8 & 0xFF);
            array[2] = (byte)(addr & 0xFF);
            array[3] = (byte)field.getFieldIdentifier().getFieldToken();
        } else {
            array[1] = (byte)p.getPackageToken(this.packageIdentifier);
            array[1] = (byte)(array[1] | 0x80);
            array[2] = (byte)this.classToken;
            array[3] = (byte)this.instanceFieldToken;
        }
        return array;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("." + Integer.toHexString(this.instanceFieldToken));
        return sb.toString();
    }
}

