/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Sortable;
import com.sun.javacard.jcasm.SortableVector;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;

public class ExportComponent
extends Component {
    protected SortableVector exportVector = new SortableVector();
    boolean isLibrary;

    public ExportComponent(JCPackage p) {
        super(p);
        this.isLibrary = p.appletCount() <= 0;
    }

    public void add(JCClass c) {
        int attributes = c.getAttributes();
        if (!Modifier.isPublic(attributes) && !Modifier.isProtected(attributes)) {
            return;
        }
        if (this.isLibrary || c.isShareable() && Modifier.isInterface(c.getAttributes())) {
            this.exportVector.addElement(new ClassExportEntry(c, this.isLibrary));
        }
    }

    public int dataSize() {
        int size = 1;
        Enumeration e = this.exportVector.elements();
        while (e.hasMoreElements()) {
            ClassExportEntry ex = (ClassExportEntry)e.nextElement();
            size += ex.size();
        }
        return size;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.exportVector.sort();
        try {
            byte[] header = super.toByteArray();
            dos.write(header, 0, header.length);
            dos.writeByte(this.exportVector.size());
            int expectedToken = 0;
            Enumeration e = this.exportVector.elements();
            while (e.hasMoreElements()) {
                ClassExportEntry ex = (ClassExportEntry)e.nextElement();
                if (expectedToken++ != ex.getToken()) {
                    Object[] args = new Object[]{this.parentPackage.getName()};
                    Msg.error("export.1", args);
                    expectedToken = ex.getToken() + 1;
                }
                byte[] array = ex.toByteArray();
                dos.write(array, 0, array.length);
            }
            dos.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        Assert.PostCondition(this.size() == bos.size(), "size() != bos.size()");
        return bos.toByteArray();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("class_count: " + this.exportVector.size() + Msg.eol);
        int count = 0;
        this.exportVector.sort();
        Enumeration e = this.exportVector.elements();
        while (e.hasMoreElements()) {
            ClassExportEntry ex = (ClassExportEntry)e.nextElement();
            sb.append("class_exports[" + count + "]: " + ex);
            sb.append(Msg.eol);
            ++count;
        }
        return sb.toString();
    }

    static class ClassExportEntry
    implements Sortable {
        private SortableVector fieldVector;
        private SortableVector methodVector;
        private JCClass myClass;
        private int offset;
        private boolean isLibrary;

        ClassExportEntry(JCClass c, boolean isLibrary) {
            this.myClass = c;
            this.isLibrary = isLibrary;
            this.offset = c.getRelocAddr();
            this.fieldVector = new SortableVector();
            this.methodVector = new SortableVector();
            if (isLibrary) {
                Enumeration f = this.myClass.fieldElements();
                while (f.hasMoreElements()) {
                    Field field = (Field)f.nextElement();
                    int attributes = field.getAttributes();
                    if (Modifier.isFinal(attributes) && Modifier.isStatic(attributes) && field.getDescriptor().isPrimitive() || !Modifier.isStatic(attributes) || !Modifier.isPublic(attributes) && !Modifier.isProtected(attributes)) continue;
                    this.fieldVector.addElement(new ExportEntry(field));
                }
                Enumeration m = c.methodElements();
                while (m.hasMoreElements()) {
                    JCMethod method = (JCMethod)m.nextElement();
                    int attributes = method.getAttributes();
                    if (!Modifier.isStatic(attributes) && method.getName().indexOf("/<init>(") == -1 || !Modifier.isPublic(attributes) && !Modifier.isProtected(attributes)) continue;
                    this.methodVector.addElement(new ExportEntry(method));
                }
            }
        }

        public int compare(Object obj) {
            ClassExportEntry other = (ClassExportEntry)obj;
            if (this.getToken() < other.getToken()) {
                return -1;
            }
            if (this.getToken() > other.getToken()) {
                return 1;
            }
            return 0;
        }

        int getToken() {
            return this.myClass.getClassIdentifier().getClassToken();
        }

        int size() {
            return 4 + this.fieldVector.size() * 2 + this.methodVector.size() * 2;
        }

        byte[] toByteArray() {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                dos.writeShort(this.offset);
                dos.writeByte(this.fieldVector.size());
                dos.writeByte(this.methodVector.size());
                this.fieldVector.sort();
                int expectedToken = 0;
                Enumeration e = this.fieldVector.elements();
                while (e.hasMoreElements()) {
                    ExportEntry ex = (ExportEntry)e.nextElement();
                    if (expectedToken++ != ex.getToken()) {
                        Object[] args = new Object[]{this.myClass.getName()};
                        Msg.error("export.2", args);
                        expectedToken = ex.getToken() + 1;
                    }
                    byte[] array = ex.toByteArray();
                    dos.write(array, 0, array.length);
                }
                this.methodVector.sort();
                expectedToken = 0;
                Enumeration e2 = this.methodVector.elements();
                while (e2.hasMoreElements()) {
                    ExportEntry ex = (ExportEntry)e2.nextElement();
                    if (expectedToken++ != ex.getToken()) {
                        Object[] args = new Object[]{this.myClass.getName()};
                        Msg.error("export.3", args);
                        expectedToken = ex.getToken() + 1;
                    }
                    byte[] array = ex.toByteArray();
                    dos.write(array, 0, array.length);
                }
                dos.flush();
            }
            catch (IOException iOException) {
                return null;
            }
            Assert.PostCondition(this.size() == bos.size(), "size() != bos.size()");
            return bos.toByteArray();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Offset: " + this.offset);
            sb.append(", static_field_count: " + this.fieldVector.size());
            sb.append(", static_method_count: " + this.methodVector.size());
            this.fieldVector.sort();
            Enumeration e = this.fieldVector.elements();
            while (e.hasMoreElements()) {
                ExportEntry ex = (ExportEntry)e.nextElement();
                sb.append(String.valueOf(Msg.eol) + ex.toString());
            }
            this.methodVector.sort();
            Enumeration e2 = this.methodVector.elements();
            while (e2.hasMoreElements()) {
                ExportEntry ex = (ExportEntry)e2.nextElement();
                sb.append(String.valueOf(Msg.eol) + ex.toString());
            }
            sb.append(Msg.eol);
            return sb.toString();
        }
    }

    static class ExportEntry
    implements Sortable {
        int token;
        int offset;

        ExportEntry(Field field) {
            this.token = field.getFieldIdentifier().getFieldToken();
            this.offset = field.getRelocAddr();
        }

        ExportEntry(JCMethod method) {
            this.token = method.getMethodIdentifier().getMethodToken();
            this.offset = method.getRelocAddr();
        }

        public int compare(Object obj) {
            ExportEntry other = (ExportEntry)obj;
            if (this.token < other.getToken()) {
                return -1;
            }
            if (this.token > other.getToken()) {
                return 1;
            }
            return 0;
        }

        int getToken() {
            return this.token;
        }

        int size() {
            return 2;
        }

        byte[] toByteArray() {
            byte[] array = new byte[]{(byte)(this.offset >> 8), (byte)this.offset};
            return array;
        }

        public String toString() {
            return Msg.toHexString((short)this.offset);
        }
    }
}

