/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apdutool;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.apduio.CadDevice;
import com.sun.javacard.apdutool.Msg;
import com.sun.javacard.apdutool.MultiInputStream;
import com.sun.javacard.apdutool.ReaderWriter;
import com.sun.javacard.apdutool.ReaderWriterError;
import com.sun.javacard.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Main {
    public static boolean noBanner = false;
    public static boolean printATR = true;
    public static boolean verbose = false;
    private static boolean formatOutput = false;
    public static byte protocolType = 1;
    private static Vector<String> inputList = new Vector();
    private static String logSpec = "-";
    private static PrintWriter logWriter;
    static String hostName;
    static boolean multipleInterfaces;
    static int port;
    private static int timeout;
    static String serialPortName;
    static boolean keepPreprocessedFiles;
    private static int readerNumber;

    public static void main(String[] argv) {
        int i;
        for (i = 0; i < argv.length && argv[i].startsWith("-"); ++i) {
            if (argv[i].equals("-help")) {
                Main.usage(false);
                System.exit(0);
                continue;
            }
            if (argv[i].equals("-h")) {
                if (++i < argv.length) {
                    hostName = argv[i];
                    continue;
                }
                Main.usage(true);
                continue;
            }
            if (argv[i].startsWith("-h")) {
                hostName = argv[i].substring(2);
                continue;
            }
            if (argv[i].equals("-nobanner")) {
                noBanner = true;
                continue;
            }
            if (argv[i].equals("-verbose")) {
                verbose = true;
                continue;
            }
            if (argv[i].equals("-noatr")) {
                printATR = false;
                continue;
            }
            if (argv[i].equals("-d") || argv[i].equals("--descriptiveoutput")) {
                formatOutput = true;
                continue;
            }
            if (argv[i].equals("-t0")) {
                if (protocolType == -85) {
                    Msg.warn("pcsc.2", null);
                    continue;
                }
                protocolType = 0;
                continue;
            }
            if (argv[i].equals("-mi")) {
                multipleInterfaces = true;
                continue;
            }
            if (argv[i].equals("-p")) {
                if (++i < argv.length) {
                    try {
                        port = Integer.parseInt(argv[i]);
                    }
                    catch (NumberFormatException e) {
                        Main.usage(true);
                    }
                    continue;
                }
                Main.usage(true);
                continue;
            }
            if (argv[i].startsWith("-p")) {
                try {
                    port = Integer.parseInt(argv[i].substring(2));
                }
                catch (NumberFormatException e) {
                    Main.usage(true);
                }
                continue;
            }
            if (argv[i].equals("-o")) {
                if (++i < argv.length) {
                    logSpec = argv[i];
                    continue;
                }
                Main.usage(true);
                continue;
            }
            if (argv[i].startsWith("-o")) {
                logSpec = argv[i].substring(2);
                continue;
            }
            if (argv[i].equals("-s")) {
                if (++i < argv.length) {
                    serialPortName = argv[i];
                    continue;
                }
                Main.usage(true);
                continue;
            }
            if (argv[i].startsWith("-s")) {
                serialPortName = argv[i].substring(2);
                continue;
            }
            if (argv[i].startsWith("-k")) {
                keepPreprocessedFiles = true;
                continue;
            }
            if (argv[i].equals("-version")) {
                Main.banner();
                System.exit(0);
                continue;
            }
            if (argv[i].equals("--")) {
                ++i;
                break;
            }
            Object[] args = new Object[]{argv[i]};
            Msg.error("main.6", args);
            Main.usage(true);
        }
        if (!noBanner) {
            Main.banner();
        }
        try {
            while (i < argv.length) {
                String fName;
                if ((fName = argv[i++]).equals("-")) {
                    inputList.addElement(argv[i]);
                    continue;
                }
                if (fName.startsWith("@")) {
                    Main.readListFromFile(inputList, fName.substring(1));
                    continue;
                }
                inputList.addElement(new File(fName).getCanonicalPath());
            }
            if (inputList.isEmpty()) {
                inputList.addElement("-");
            }
            logWriter = logSpec.equals("-") ? new PrintWriter(System.out, true) : new PrintWriter(new FileWriter(new File(logSpec).getCanonicalPath()));
        }
        catch (IOException e) {
            System.err.println(e);
            System.exit(1);
        }
        InputStream is = null;
        if (inputList.size() == 1 && "-".equals(inputList.elementAt(0))) {
            is = System.in;
        } else {
            MultiInputStream mis = new MultiInputStream();
            for (String inSpec : inputList) {
                try {
                    BufferedInputStream inputStream = inSpec.equals("-") ? new BufferedInputStream(System.in) : new BufferedInputStream(new ByteArrayInputStream(Main.preprocess(inSpec)));
                    mis.addStream(inputStream);
                }
                catch (FileNotFoundException f) {
                    System.err.println("Input file \"" + inSpec + "\" not found");
                    Main.usage(true);
                    System.exit(1);
                }
                catch (Exception e) {
                    System.err.println(e);
                    System.exit(1);
                }
            }
            is = mis;
        }
        try {
            Object[] args;
            ReaderWriter rw;
            if (protocolType == -85) {
                rw = new ReaderWriter(is, CadDevice.getPCSCClientInstance(readerNumber), logWriter);
            } else if (serialPortName == null) {
                if (!noBanner) {
                    args = new Object[]{hostName, "" + port};
                    Msg.info("main.0", args);
                }
                if (!noBanner) {
                    Msg.info("main.2", null);
                }
                if (multipleInterfaces) {
                    rw = new ReaderWriter(is, null, logWriter);
                } else {
                    Socket sock = Main.openSocket(hostName, port);
                    sock.setTcpNoDelay(true);
                    BufferedInputStream bin = new BufferedInputStream(sock.getInputStream());
                    BufferedOutputStream bos = new BufferedOutputStream(sock.getOutputStream());
                    rw = new ReaderWriter(is, CadDevice.getCadClientInstance(protocolType, bin, bos), logWriter);
                }
            } else {
                if (!noBanner) {
                    args = new Object[]{serialPortName};
                    Msg.info("main.1", args);
                }
                rw = Main.connectToSerialPort(is, serialPortName, logWriter);
            }
            rw.setPrintATR(printATR);
            rw.setFormatOutput(formatOutput);
            rw.run();
        }
        catch (ReaderWriterError e) {
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            System.err.println(e);
        }
        logWriter.flush();
        if (!logSpec.equals("-")) {
            logWriter.close();
        }
        System.exit(0);
    }

    private static byte[] preprocess(String fileName) throws Exception {
        Hashtable<String, String> definesList = new Hashtable<String, String>();
        String symbol = null;
        String value = null;
        int lineNumber = 0;
        String line = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
        while ((line = br.readLine()) != null) {
            ++lineNumber;
            if ((line = line.trim()).length() <= 0) {
                bos.write("\n".getBytes());
                continue;
            }
            if (line.startsWith("#define ")) {
                String rest = line.substring(8);
                if ((rest = rest.trim()).length() <= 0) {
                    throw new Exception("Empty #define statement at " + fileName + "#" + lineNumber);
                }
                int idx = rest.indexOf(" ");
                if (idx == -1) {
                    idx = rest.indexOf("\t");
                }
                if (idx == -1) {
                    symbol = rest;
                    value = "";
                } else {
                    symbol = rest.substring(0, idx).trim();
                    value = rest.substring(idx + 1).trim();
                }
                if (!StringUtils.isValidAPDUScriptDefine(symbol)) {
                    throw new Exception("Invalid/Illegal define symbol '" + symbol + "' at " + fileName + "#" + lineNumber);
                }
                value = Main.replaceDefines(value, definesList);
                definesList.put(symbol, value);
                bos.write("\n".getBytes());
                continue;
            }
            line = Main.replaceDefines(line, definesList);
            bos.write(line.getBytes());
            bos.write("\n".getBytes());
        }
        byte[] pbs = bos.toByteArray();
        if (keepPreprocessedFiles) {
            FileOutputStream fos = new FileOutputStream(fileName + ".preprocessed");
            fos.write(pbs);
        }
        return pbs;
    }

    private static void banner() {
        Msg.info(ToolsVersion.getToolName(6) + ToolsVersion.getVersion(6));
        Msg.info(ToolsVersion.getCopyrightBanner());
        if (protocolType == -85) {
            Msg.warn("pcsc.1", null);
        }
        System.out.flush();
    }

    private static void usage(boolean isError) {
        if (isError) {
            Msg.error("main.5", null);
            System.exit(1);
        } else {
            Msg.info("main.5", null);
        }
    }

    private static Socket openSocket(String hostname, int port) {
        Socket sock = null;
        try {
            sock = new Socket(hostName, port);
        }
        catch (UnknownHostException e) {
            Object[] args = new Object[]{hostName};
            Msg.error("main.4", args);
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println(e);
            System.exit(1);
        }
        catch (IllegalArgumentException e) {
            Object[] args = new Object[]{e.getLocalizedMessage()};
            Msg.error("main.8", args);
            System.exit(1);
        }
        return sock;
    }

    static void readListFromFile(Vector<String> list, String fName) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(fName));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                list.addElement(line);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReaderWriter connectToSerialPort(InputStream mis, String serialPortName, PrintWriter logWriter) {
        try {
            Class<?> commPortClass = Class.forName("javax.comm.CommPort");
            Class<?> commPortIdentifierClass = Class.forName("javax.comm.CommPortIdentifier");
            Class[] params = new Class[]{String.class};
            Method getPortIdentifier = commPortIdentifierClass.getMethod("getPortIdentifier", params);
            Object portID = getPortIdentifier.invoke(null, serialPortName);
            params = new Class[]{String.class, Integer.TYPE};
            Method portID_open = commPortIdentifierClass.getMethod("open", params);
            Object commPort = portID_open.invoke(portID, "apdutool", new Integer(30000));
            Method commPortClass_getInputStream = commPortClass.getMethod("getInputStream", new Class[0]);
            Method commPortClass_getOutputStream = commPortClass.getMethod("getOutputStream", new Class[0]);
            InputStream is = (InputStream)commPortClass_getInputStream.invoke(commPort, new Object[0]);
            OutputStream os = (OutputStream)commPortClass_getOutputStream.invoke(commPort, new Object[0]);
            BufferedInputStream bin = new BufferedInputStream(is);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            if (!noBanner) {
                Msg.info("main.2", null);
            }
            return new ReaderWriter(mis, CadDevice.getCadClientInstance(protocolType, bin, bos), logWriter);
        }
        catch (ClassNotFoundException e) {
            Msg.info("main.9", null);
            System.exit(1);
        }
        catch (Exception e) {
            Msg.info("main.10", null);
            try {
                Class<?> commPortIdentifierClass = Class.forName("javax.comm.CommPortIdentifier");
                Method getPortIdentifiers = commPortIdentifierClass.getMethod("getPortIdentifiers", new Class[0]);
                Method getName = commPortIdentifierClass.getMethod("getName", new Class[0]);
                Enumeration list = (Enumeration)getPortIdentifiers.invoke(null, new Object[0]);
                Msg.info("main.11", null);
                if (list != null && list.hasMoreElements()) {
                    while (list.hasMoreElements()) {
                        Object port = list.nextElement();
                        System.out.println(getName.invoke(port, new Object[0]));
                    }
                } else {
                    Msg.info("main.12", null);
                }
            }
            catch (Exception ex) {
            }
            finally {
                System.exit(1);
            }
        }
        return null;
    }

    private static String replaceDefines(String line, Hashtable<String, String> definesList) {
        String regexp = null;
        for (String define : definesList.keySet()) {
            regexp = "[ \\t]*" + define + "[ \\t]*";
            line = line.replaceAll(regexp, " " + definesList.get(define) + " ");
        }
        return line;
    }

    static {
        hostName = "localhost";
        port = 9025;
        timeout = 0;
        serialPortName = null;
        keepPreprocessedFiles = false;
        readerNumber = 0;
    }
}

