/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.instructions.JInstrByteIndex;
import com.sun.javacard.classfile.instructions.JInstruction;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.OperandStack;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.jcfile.instructions.JcInstruction;

public class InstrContainer {
    private int forced_type;
    private OperandStack parent_operand_stack;
    private OperandStack working_operand_stack;
    private JInstruction j_instr;
    private JcInstruction jc_instr;
    private InstrContainer prev_instr_container;
    private InstrContainer next_instr_container;
    private InstrContainer[] out_instr_containers;
    private boolean label_flag;
    private int label = -1;
    private boolean controlFlowLabelFlag = false;
    private boolean catch_finally_block_leader;
    private boolean changed_flag = false;
    private boolean visited_flag = false;
    private boolean isInserted = false;

    public InstrContainer(JInstruction j_instr) {
        this.j_instr = j_instr;
        this.out_instr_containers = new InstrContainer[0];
    }

    public JInstruction getJInstr() {
        return this.j_instr;
    }

    public void setJInstr(JInstruction j_instr) {
        this.j_instr = j_instr;
    }

    public boolean isInserted() {
        return this.isInserted;
    }

    public void setInserted(boolean b) {
        this.isInserted = b;
    }

    public JcInstruction getJcInstr() {
        return this.jc_instr;
    }

    public void setJcInstr(JcInstruction jc_instr) {
        this.jc_instr = jc_instr;
    }

    public InstrContainer getPrevInstrContainer() {
        return this.prev_instr_container;
    }

    public void setPrevInstrContainer(InstrContainer instr_container) {
        this.prev_instr_container = instr_container;
    }

    public InstrContainer getNextInstrContainer() {
        return this.next_instr_container;
    }

    public void setNextInstrContainer(InstrContainer instr_container) {
        this.next_instr_container = instr_container;
    }

    public InstrContainer[] getOutInstrContainers() {
        return this.out_instr_containers;
    }

    public void link(InstrContainer target_instr_container) {
        int length = this.out_instr_containers.length;
        for (int i = 0; i < length; ++i) {
            if (this.out_instr_containers[i].getJInstr().getPC() != target_instr_container.getJInstr().getPC()) continue;
            return;
        }
        InstrContainer[] new_containers = new InstrContainer[length + 1];
        System.arraycopy(this.out_instr_containers, 0, new_containers, 0, length);
        new_containers[length] = target_instr_container;
        this.out_instr_containers = new_containers;
    }

    public void relink(InstrContainer instr_container1, InstrContainer instr_container2) {
        int length = this.out_instr_containers.length;
        for (int i = 0; i < length; ++i) {
            if (this.out_instr_containers[i].getJInstr().getPC() != instr_container1.getJInstr().getPC()) continue;
            this.out_instr_containers[i] = instr_container2;
        }
    }

    public OperandStack getOperandStack() {
        return this.working_operand_stack;
    }

    public void forceNewStack(OperandStack new_operand_stack) {
        this.parent_operand_stack = new_operand_stack;
        this.working_operand_stack = new_operand_stack;
    }

    public void resetStack() {
        this.parent_operand_stack = null;
        this.working_operand_stack = null;
    }

    public void resetWorkingStack() {
        this.working_operand_stack = null;
    }

    public void setOperandStack(OperandStack new_operand_stack) {
        if (this.parent_operand_stack == null) {
            this.parent_operand_stack = new_operand_stack;
            this.changed_flag = true;
        } else {
            this.merge(new_operand_stack);
        }
        this.working_operand_stack = (OperandStack)this.parent_operand_stack.clone();
    }

    public int getForcedType() {
        return this.forced_type;
    }

    public void setForcedType(int type) {
        this.forced_type = type;
    }

    public int getLabel() {
        return this.label;
    }

    public void setLabel(int num) {
        this.label = num;
    }

    public boolean hasLabel() {
        return this.label_flag;
    }

    public void setLabelFlag(boolean flag) {
        this.label_flag = flag;
    }

    public boolean getControlFlowLabelFlag() {
        return this.controlFlowLabelFlag;
    }

    public void setControlFlowLabelFlag(boolean b) {
        this.controlFlowLabelFlag = b;
    }

    public boolean isCatchFinallyBlockLeader() {
        return this.catch_finally_block_leader;
    }

    public void setCatchFinallyBlockLeader(boolean flag) {
        this.catch_finally_block_leader = flag;
    }

    public void setChangedFlag(boolean flag) {
        this.changed_flag = flag;
    }

    public boolean hasChanged() {
        return this.changed_flag;
    }

    public boolean isVisited() {
        return this.visited_flag;
    }

    public void setVisited(boolean b) {
        this.visited_flag = b;
    }

    private void merge(OperandStack new_operand_stack) {
        OperandStackEntry[] new_stack_entries;
        OperandStackEntry[] stack_entries = this.parent_operand_stack.getStackEntries();
        if (stack_entries.length != (new_stack_entries = new_operand_stack.getStackEntries()).length) {
            throw new ConverterInternalError();
        }
        for (int i = stack_entries.length - 1; i >= 0; --i) {
            if (stack_entries[i].getType() == new_stack_entries[i].getType()) continue;
            if (stack_entries[i].getType() == 3) {
                new_stack_entries[i].rollBack();
            }
            if (new_stack_entries[i].getType() == 3) {
                this.parent_operand_stack = new_operand_stack;
                this.changed_flag = true;
                stack_entries[i].rollBack();
            }
            if (stack_entries[i].getType() == 10) {
                throw new ConverterInternalError();
            }
            if (new_stack_entries[i].getType() != 10) continue;
            throw new ConverterInternalError();
        }
    }

    public void reset() {
        if (this.parent_operand_stack == null) {
            throw new ConverterInternalError();
        }
        this.working_operand_stack = (OperandStack)this.parent_operand_stack.clone();
        this.jc_instr = null;
    }

    public InstrContainer findRetInstrContainer() {
        InstrContainer jsr_target = this.getOutInstrContainers()[0];
        switch (jsr_target.getJInstr().getOpcode()) {
            case 75: {
                return jsr_target.findRetInstrContainer(0);
            }
            case 76: {
                return jsr_target.findRetInstrContainer(1);
            }
            case 77: {
                return jsr_target.findRetInstrContainer(2);
            }
            case 78: {
                return jsr_target.findRetInstrContainer(3);
            }
            case 58: {
                return jsr_target.findRetInstrContainer(((JInstrByteIndex)jsr_target.getJInstr()).getIndex());
            }
        }
        throw new ConverterInternalError();
    }

    private InstrContainer findRetInstrContainer(int index) {
        for (InstrContainer curr = this; curr != null; curr = curr.getNextInstrContainer()) {
            if (curr.getJInstr().getOpcode() != 169 || ((JInstrByteIndex)curr.getJInstr()).getIndex() != index) continue;
            return curr;
        }
        return null;
    }
}

