/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework;

import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.impl.PrivAccess;
import javacard.framework.APDUComm;
import javacard.framework.APDUException;
import javacard.framework.Dispatcher;
import javacard.framework.T0APDUImpl;

public final class APDU {
    public static final byte STATE_INITIAL = 0;
    public static final byte STATE_PARTIAL_INCOMING = 1;
    public static final byte STATE_FULL_INCOMING = 2;
    public static final byte STATE_OUTGOING = 3;
    public static final byte STATE_OUTGOING_LENGTH_KNOWN = 4;
    public static final byte STATE_PARTIAL_OUTGOING = 5;
    public static final byte STATE_FULL_OUTGOING = 6;
    public static final byte STATE_ERROR_NO_T0_GETRESPONSE = -1;
    public static final byte STATE_ERROR_T1_IFD_ABORT = -2;
    public static final byte STATE_ERROR_IO = -3;
    public static final byte STATE_ERROR_NO_T0_REISSUE = -4;
    public static final byte PROTOCOL_MEDIA_MASK = -16;
    public static final byte PROTOCOL_TYPE_MASK = 15;
    public static final byte PROTOCOL_T0 = 0;
    public static final byte PROTOCOL_T1 = 1;
    public static final byte PROTOCOL_MEDIA_DEFAULT = 0;
    public static final byte PROTOCOL_MEDIA_CONTACTLESS_TYPE_A = -128;
    public static final byte PROTOCOL_MEDIA_CONTACTLESS_TYPE_B = -112;
    public static final byte PROTOCOL_MEDIA_USB = -96;
    static final byte LOGICAL_CHN_MASK_TYPE4 = 3;
    static final byte LOGICAL_CHN_MASK_TYPE16 = 15;
    static final byte APDU_ISOCLASS_MASK = -128;
    static final byte APDU_TYPE_MASK = 64;
    static final byte APDU_SM_MASK_TYPE4 = 12;
    static final byte APDU_SM_MASK_TYPE16 = 32;
    static final byte APDU_CHAINING_MASK = 16;
    static final byte APDU_INVALID_TYPE4_MASK = 32;
    static final byte PROTOCOL_TCL = -111;
    private static APDUComm apduProtocol;
    private static APDU theAPDU;

    byte getLogicalChannel() {
        return apduProtocol.getLogicalChannel();
    }

    boolean getNoChainingFlag() {
        return apduProtocol.getNoChainingFlag();
    }

    APDU() {
        apduProtocol = new T0APDUImpl();
        NativeMethods.setJCREentry((Object)apduProtocol, (boolean)false);
        theAPDU = this;
    }

    public byte[] getBuffer() {
        return apduProtocol.getBuffer();
    }

    public static short getInBlockSize() {
        return apduProtocol.getInBlockSize();
    }

    public static short getOutBlockSize() {
        return apduProtocol.getOutBlockSize();
    }

    public static byte getProtocol() {
        return apduProtocol.getProtocol();
    }

    public byte getNAD() {
        return apduProtocol.getNAD();
    }

    public short setOutgoing() throws APDUException {
        return apduProtocol.setOutgoing();
    }

    public short setOutgoingNoChaining() throws APDUException {
        return apduProtocol.setOutgoingNoChaining();
    }

    public void setOutgoingLength(short len) throws APDUException {
        apduProtocol.setOutgoingLength(len);
    }

    public short receiveBytes(short bOff) throws APDUException {
        return apduProtocol.receiveBytes(bOff);
    }

    public short setIncomingAndReceive() throws APDUException {
        return apduProtocol.setIncomingAndReceive();
    }

    public void sendBytes(short bOff, short len) throws APDUException {
        apduProtocol.sendBytes(bOff, len);
    }

    public void sendBytesLong(byte[] outData, short bOff, short len) throws APDUException, SecurityException {
        apduProtocol.sendBytesLong(outData, bOff, len);
    }

    public void setOutgoingAndSend(short bOff, short len) throws APDUException {
        apduProtocol.setOutgoingAndSend(bOff, len);
    }

    public byte getCurrentState() {
        return apduProtocol.getCurrentState();
    }

    private static void checkAPDUObjectAccess() throws SecurityException {
        byte commandInterface;
        byte commandChannel = NativeMethods.getCurrentlySelectedChannel();
        if (PrivAccess.getSelectedAppID((byte)commandChannel, (byte)(commandInterface = NativeMethods.getActiveInterface())) != PrivAccess.getCurrentAppID() || !PrivAccess.getPrivAccess().inProcessMethod()) {
            throw Dispatcher.securityException;
        }
    }

    public static APDU getCurrentAPDU() throws SecurityException {
        APDU.checkAPDUObjectAccess();
        return theAPDU;
    }

    public static byte[] getCurrentAPDUBuffer() throws SecurityException {
        APDU.checkAPDUObjectAccess();
        return apduProtocol.getCurrentAPDUBuffer();
    }

    public static byte getCLAChannel() {
        return apduProtocol.getCLAChannel();
    }

    void resetAPDU() {
        apduProtocol.resetAPDU();
    }

    void complete(short status) throws APDUException {
        apduProtocol.complete(status);
    }

    void undoIncomingAndReceive() {
        apduProtocol.undoIncomingAndReceive();
    }

    public static void waitExtension() throws APDUException {
        apduProtocol.waitExtension();
    }

    void markExtendedSupport(boolean extAPDUOK) {
        apduProtocol.markExtendedSupport(extAPDUOK);
    }

    public boolean isCommandChainingCLA() {
        return apduProtocol.isCommandChainingCLA();
    }

    public boolean isSecureMessagingCLA() {
        return apduProtocol.isSecureMessagingCLA();
    }

    public boolean isISOInterindustryCLA() {
        return apduProtocol.isISOInterindustryCLA();
    }

    public short getIncomingLength() {
        return apduProtocol.getIncomingLength();
    }

    public short getOffsetCdata() {
        return apduProtocol.getOffsetCdata();
    }

    void verifyLe() {
        apduProtocol.verifyLe();
    }
}

