/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework;

import com.sun.javacard.impl.AppletMgr;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.impl.PrivAccess;
import javacard.framework.AID;
import javacard.framework.Shareable;
import javacard.framework.SystemException;
import javacard.framework.TransactionException;

public final class JCSystem {
    private static final short API_VERSION = 514;
    public static final byte MEMORY_TYPE_PERSISTENT = 0;
    public static final byte MEMORY_TYPE_TRANSIENT_RESET = 1;
    public static final byte MEMORY_TYPE_TRANSIENT_DESELECT = 2;
    static PrivAccess thePrivAccess;
    private static final boolean GC_SUPPORTED = true;
    public static final byte NOT_A_TRANSIENT_OBJECT = 0;
    public static final byte CLEAR_ON_RESET = 1;
    public static final byte CLEAR_ON_DESELECT = 2;

    JCSystem() {
    }

    public static native byte isTransient(Object var0);

    public static native boolean[] makeTransientBooleanArray(short var0, byte var1) throws NegativeArraySizeException, SystemException;

    public static native byte[] makeTransientByteArray(short var0, byte var1) throws NegativeArraySizeException, SystemException;

    public static native short[] makeTransientShortArray(short var0, byte var1) throws NegativeArraySizeException, SystemException;

    public static native Object[] makeTransientObjectArray(short var0, byte var1) throws NegativeArraySizeException, SystemException;

    public static short getVersion() {
        return 514;
    }

    public static AID getAID() {
        return thePrivAccess.getAID(PrivAccess.getCurrentAppID());
    }

    public static AID lookupAID(byte[] buffer, short offset, byte length) {
        byte test = buffer[0];
        return thePrivAccess.getAID(buffer, offset, length);
    }

    public static void beginTransaction() throws TransactionException {
        if (!AppletMgr.installTransactionFlag) {
            NativeMethods.beginTransactionNative();
        }
    }

    public static void abortTransaction() throws TransactionException {
        if (!AppletMgr.installTransactionFlag) {
            NativeMethods.abortTransactionNative();
        }
    }

    public static void commitTransaction() throws TransactionException {
        if (!AppletMgr.installTransactionFlag) {
            NativeMethods.commitTransactionNative();
        }
    }

    public static native byte getTransactionDepth();

    public static native short getUnusedCommitCapacity();

    public static native short getMaxCommitCapacity();

    public static AID getPreviousContextAID() {
        byte prevCtx = NativeMethods.getPreviousContext();
        if (prevCtx == 0) {
            return null;
        }
        return thePrivAccess.getAID((byte)(prevCtx & 0xF));
    }

    public static short getAvailableMemory(byte memoryType) throws SystemException {
        switch (memoryType) {
            case 0: {
                return NativeMethods.E2P_Available();
            }
            case 1: {
                return NativeMethods.rtr_Available();
            }
            case 2: {
                return NativeMethods.dtr_Available();
            }
        }
        SystemException.throwIt((short)1);
        return 0;
    }

    public static Shareable getAppletShareableInterfaceObject(AID serverAID, byte parameter) {
        return thePrivAccess.getSharedObject(serverAID, parameter);
    }

    public static boolean isObjectDeletionSupported() {
        return true;
    }

    public static void requestObjectDeletion() throws SystemException {
        thePrivAccess.setGCRequestedFlag(true);
    }

    public static byte getAssignedChannel() {
        return NativeMethods.getCurrentlySelectedChannel();
    }

    public static boolean isAppletActive(AID theApplet) {
        byte maxChannels = NativeMethods.getMaxChannels();
        byte maxInterfaces = NativeMethods.getCardInterfaceCount();
        theApplet.equals(null);
        for (byte i = 0; i < maxChannels; i = (byte)(i + 1)) {
            for (byte j = 0; j < maxInterfaces; j = (byte)(j + 1)) {
                byte appID;
                byte appContextID = NativeMethods.getChannelContext((byte)i, (byte)j);
                if (appContextID == 15 || !thePrivAccess.getAID(appID = (byte)(appContextID & 0xF)).equals(theApplet)) continue;
                return true;
            }
        }
        return false;
    }
}

