/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Sortable;
import com.sun.javacard.jcasm.SortableVector;
import com.sun.javacard.jcasm.cap.Component;
import com.sun.javacard.jcasm.mask.CrefOutputFormatter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;

public class ExportComponent
extends Component {
    public static final int MODE_CAP = 0;
    public static final int MODE_MASK = 1;
    protected SortableVector<ClassExportEntry> exportVector = new SortableVector();
    boolean isLibrary;
    private static int outputMode = 0;

    public ExportComponent(JCPackage jCPackage) {
        super(jCPackage);
        this.isLibrary = jCPackage.appletCount() <= 0;
    }

    public static void setOutputMode(int n) {
        outputMode = n;
    }

    public void add(JCClass jCClass) {
        int n = jCClass.getAttributes();
        if (!Modifier.isPublic(n) && !Modifier.isProtected(n)) {
            return;
        }
        if (this.isLibrary || jCClass.isShareable() && Modifier.isInterface(jCClass.getAttributes())) {
            this.exportVector.addElement(new ClassExportEntry(jCClass, this.isLibrary));
        }
    }

    @Override
    public int dataSize() {
        int n = 1;
        for (ClassExportEntry classExportEntry : this.exportVector) {
            n += classExportEntry.size();
        }
        return n;
    }

    @Override
    public byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.exportVector.sort();
        try {
            byte[] byArray = super.toByteArray();
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.writeByte(this.exportVector.size());
            int n = 0;
            for (ClassExportEntry classExportEntry : this.exportVector) {
                Object[] objectArray;
                if (n++ != classExportEntry.getToken()) {
                    objectArray = new Object[]{this.parentPackage.getName()};
                    Msg.error("export.1", objectArray);
                    n = classExportEntry.getToken() + 1;
                }
                objectArray = classExportEntry.toByteArray();
                dataOutputStream.write((byte[])objectArray, 0, objectArray.length);
            }
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        assert (this.size() == byteArrayOutputStream.size()) : "size() != bos.size()";
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("class_count: " + this.exportVector.size() + Msg.eol);
        int n = 0;
        this.exportVector.sort();
        for (ClassExportEntry classExportEntry : this.exportVector) {
            stringBuffer.append("class_exports[" + n + "]: " + classExportEntry);
            stringBuffer.append(Msg.eol);
            ++n;
        }
        return stringBuffer.toString();
    }

    static class ExportEntry
    implements Sortable {
        int token;
        int offset;

        ExportEntry(JCMethod jCMethod) {
            this.token = jCMethod.getMethodIdentifier().getMethodToken();
            this.offset = outputMode == 0 ? jCMethod.getRelocAddr() : CrefOutputFormatter.getExportedRefManager().getExportedReference(jCMethod);
        }

        ExportEntry(Field field) {
            this.token = field.getFieldIdentifier().getFieldToken();
            this.offset = outputMode == 0 ? field.getRelocAddr() : CrefOutputFormatter.getExportedRefManager().getExportedReference(field);
        }

        int getToken() {
            return this.token;
        }

        int size() {
            return 2;
        }

        @Override
        public int compare(Object object) {
            ExportEntry exportEntry = (ExportEntry)object;
            if (this.token < exportEntry.getToken()) {
                return -1;
            }
            if (this.token > exportEntry.getToken()) {
                return 1;
            }
            return 0;
        }

        byte[] toByteArray() {
            byte[] byArray = new byte[]{(byte)(this.offset >> 8), (byte)this.offset};
            return byArray;
        }

        public String toString() {
            return Msg.toHexString((short)this.offset);
        }
    }

    static class ClassExportEntry
    implements Sortable {
        private SortableVector<ExportEntry> fieldVector;
        private SortableVector<ExportEntry> methodVector;
        private JCClass myClass;
        private int offset;
        private boolean isLibrary;

        ClassExportEntry(JCClass jCClass, boolean bl) {
            this.myClass = jCClass;
            this.isLibrary = bl;
            this.offset = outputMode == 0 ? jCClass.getRelocAddr() : CrefOutputFormatter.getExportedRefManager().getExportedReference(jCClass);
            this.fieldVector = new SortableVector();
            this.methodVector = new SortableVector();
            if (bl) {
                int n;
                Member member;
                Enumeration<Member> enumeration = this.myClass.fieldElements();
                while (enumeration.hasMoreElements()) {
                    member = enumeration.nextElement();
                    n = member.getAttributes();
                    if (Modifier.isFinal(n) && Modifier.isStatic(n) && ((Field)member).getDescriptor().isPrimitive() || !Modifier.isStatic(n) || !Modifier.isPublic(n) && !Modifier.isProtected(n)) continue;
                    this.fieldVector.addElement(new ExportEntry((Field)member));
                }
                enumeration = jCClass.methodElements();
                while (enumeration.hasMoreElements()) {
                    member = (JCMethod)enumeration.nextElement();
                    n = member.getAttributes();
                    if (!Modifier.isStatic(n) && member.getName().indexOf("/<init>(") == -1 || !Modifier.isPublic(n) && !Modifier.isProtected(n)) continue;
                    this.methodVector.addElement(new ExportEntry((JCMethod)member));
                }
            }
        }

        int getToken() {
            return this.myClass.getClassIdentifier().getClassToken();
        }

        int size() {
            return 4 + this.fieldVector.size() * 2 + this.methodVector.size() * 2;
        }

        @Override
        public int compare(Object object) {
            ClassExportEntry classExportEntry = (ClassExportEntry)object;
            if (this.getToken() < classExportEntry.getToken()) {
                return -1;
            }
            if (this.getToken() > classExportEntry.getToken()) {
                return 1;
            }
            return 0;
        }

        byte[] toByteArray() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                Object[] objectArray;
                dataOutputStream.writeShort(this.offset);
                dataOutputStream.writeByte(this.fieldVector.size());
                dataOutputStream.writeByte(this.methodVector.size());
                this.fieldVector.sort();
                int n = 0;
                for (ExportEntry exportEntry : this.fieldVector) {
                    if (n++ != exportEntry.getToken()) {
                        objectArray = new Object[]{this.myClass.getName()};
                        Msg.error("export.2", objectArray);
                        n = exportEntry.getToken() + 1;
                    }
                    objectArray = exportEntry.toByteArray();
                    dataOutputStream.write((byte[])objectArray, 0, objectArray.length);
                }
                this.methodVector.sort();
                n = 0;
                for (ExportEntry exportEntry : this.methodVector) {
                    if (n++ != exportEntry.getToken()) {
                        objectArray = new Object[]{this.myClass.getName()};
                        Msg.error("export.3", objectArray);
                        n = exportEntry.getToken() + 1;
                    }
                    objectArray = exportEntry.toByteArray();
                    dataOutputStream.write((byte[])objectArray, 0, objectArray.length);
                }
                dataOutputStream.flush();
            }
            catch (IOException iOException) {
                return null;
            }
            assert (this.size() == byteArrayOutputStream.size()) : "size() != bos.size()";
            return byteArrayOutputStream.toByteArray();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Offset: " + this.offset);
            stringBuffer.append(", static_field_count: " + this.fieldVector.size());
            stringBuffer.append(", static_method_count: " + this.methodVector.size());
            this.fieldVector.sort();
            for (ExportEntry exportEntry : this.fieldVector) {
                stringBuffer.append(Msg.eol + exportEntry.toString());
            }
            this.methodVector.sort();
            for (ExportEntry exportEntry : this.methodVector) {
                stringBuffer.append(Msg.eol + exportEntry.toString());
            }
            stringBuffer.append(Msg.eol);
            return stringBuffer.toString();
        }
    }
}

