/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ClassInfo;
import com.sun.javacard.offcardverifier.ExportedClass;
import com.sun.javacard.offcardverifier.ImportComponent;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;

public class Classref {
    static int multiSelectable = -1;
    public static int Object;
    public static int Throwable;
    public static int Shareable;
    public static int Remote;

    public static boolean isExternal(int n) {
        return (n & 0x8000) != 0;
    }

    public static int packageToken(int n) {
        return n >> 8 & 0x7F;
    }

    public static int classToken(int n) {
        return n & 0xFF;
    }

    public static ClassDescriptor checkInternal(int n) {
        ClassDescriptor classDescriptor = Cap.Descriptor.firstClassDescriptor();
        for (int i = Cap.Descriptor.classCount(); i > 0; --i) {
            if (n == classDescriptor.thisClass()) {
                return classDescriptor;
            }
            classDescriptor.next();
        }
        throw new VerifierError("Classref.1", n);
    }

    public static EfClass checkExternal(int n) {
        int n2 = Classref.packageToken(n);
        int n3 = Classref.classToken(n);
        ExportFile exportFile = Cap.Import.importPackage(n2);
        if (exportFile == null) {
            throw new VerifierError("Classref.2", n, n2);
        }
        for (EfClass efClass : exportFile.classes) {
            if (efClass.token != n3) continue;
            return efClass;
        }
        throw new VerifierError("Classref.3", n, n3);
    }

    public static EfClass exportclassForExternal(int n) {
        int n2 = Classref.packageToken(n);
        int n3 = Classref.classToken(n);
        ExportFile exportFile = Cap.Import.exportfileForPackageToken(n2);
        if (exportFile == null) {
            throw new VerifierError("Classref.4", n, n2);
        }
        for (EfClass efClass : exportFile.classes) {
            if (efClass.token != n3) continue;
            return efClass;
        }
        throw new VerifierError("Classref.5", n, n3);
    }

    static void check(int n) {
        if (Classref.isExternal(n)) {
            Classref.checkExternal(n);
        } else {
            Classref.checkInternal(n);
        }
    }

    public static int checkAndGetAccessFlags(int n) {
        if (!Classref.isExternal(n)) {
            ClassDescriptor classDescriptor = Classref.checkInternal(n);
            return classDescriptor.flags();
        }
        EfClass efClass = Classref.checkExternal(n);
        int n2 = 0;
        if ((efClass.accessFlag & 1) != 0) {
            n2 |= 1;
        }
        if ((efClass.accessFlag & 0x10) != 0) {
            n2 |= 0x10;
        }
        if ((efClass.accessFlag & 0x200) != 0) {
            n2 |= 0x40;
        }
        if ((efClass.accessFlag & 0x400) != 0) {
            n2 |= 0x80;
        }
        return n2;
    }

    public static boolean isSubclass(int n, int n2) {
        while (!Classref.isExternal(n)) {
            if (n == n2) {
                return true;
            }
            n = Cap.Class.infoOfs(n).superclass();
        }
        if (n == n2) {
            return true;
        }
        if (!Classref.isExternal(n2)) {
            return false;
        }
        EfClass efClass = Classref.exportclassForExternal(n);
        EfClass efClass2 = Classref.exportclassForExternal(n2);
        for (int i = 0; i < efClass.supers.length; ++i) {
            if (!efClass.superName(i).equals(efClass2.thisName())) continue;
            return true;
        }
        return false;
    }

    static int lub(int n, int n2) {
        int n3;
        int n4;
        int n5;
        EfClass efClass;
        String string;
        while (!Classref.isExternal(n) && !Classref.isExternal(n2)) {
            if (n == n2) {
                return n;
            }
            if (Classref.isSubclass(n, n2)) {
                return n2;
            }
            if (Classref.isSubclass(n2, n)) {
                return n;
            }
            n = Cap.Class.infoOfs(n).superclass();
            n2 = Cap.Class.infoOfs(n2).superclass();
        }
        while (!Classref.isExternal(n)) {
            n = Cap.Class.infoOfs(n).superclass();
        }
        while (!Classref.isExternal(n2)) {
            n2 = Cap.Class.infoOfs(n2).superclass();
        }
        if (n == n2) {
            return n;
        }
        EfClass efClass2 = Classref.exportclassForExternal(n);
        String string2 = efClass2.thisName();
        if (string2.equals(string = (efClass = Classref.exportclassForExternal(n2)).thisName())) {
            return n;
        }
        for (n5 = 0; n5 < efClass2.supers.length; ++n5) {
            if (!efClass2.superName(n5).equals(string)) continue;
            return n2;
        }
        for (n5 = 0; n5 < efClass.supers.length; ++n5) {
            if (!efClass.superName(n5).equals(string2)) continue;
            return n;
        }
        int[] nArray = new int[efClass2.supers.length + efClass.supers.length];
        int n6 = 0;
        block5: for (n4 = 0; n4 < efClass2.supers.length; ++n4) {
            String string3 = efClass2.superName(n4);
            for (n3 = 0; n3 < efClass.supers.length; ++n3) {
                if (!string3.equals(efClass.superName(n3))) continue;
                nArray[n6] = Classref.refForName(string3);
                ++n6;
                continue block5;
            }
        }
        for (n4 = 0; n4 < n6; ++n4) {
            int n7 = nArray[n4];
            for (n3 = 0; n3 < n6 && Classref.isSubclass(n7, nArray[n3]); ++n3) {
            }
            if (n3 != n6) continue;
            return n7;
        }
        throw new VerifierError("Classref.9", (Object)efClass2.thisName(), (Object)efClass.thisName());
    }

    public static boolean isSameOrSuper(int n, int n2) {
        if (n == n2) {
            return true;
        }
        if (!Classref.isExternal(n)) {
            return n2 == Cap.Class.infoOfs(n).superclass();
        }
        if (!Classref.isExternal(n2)) {
            return false;
        }
        EfClass efClass = Classref.exportclassForExternal(n);
        EfClass efClass2 = Classref.exportclassForExternal(n2);
        for (int i = 0; i < efClass.supers.length; ++i) {
            if (!efClass.superName(i).equals(efClass2.thisName())) continue;
            return true;
        }
        return false;
    }

    public static EfClass exportclassForName(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            throw new VerifierError("Classref.6", string);
        }
        String string2 = string.substring(0, n);
        int n2 = Cap.Import.tokenForPackage(string2);
        ExportFile exportFile = Cap.Import.exportfileForPackageToken(n2);
        for (EfClass efClass : exportFile.classes) {
            if (!string.equals(efClass.thisName())) continue;
            return efClass;
        }
        return null;
    }

    public static int refForName(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            throw new VerifierError("Classref.6", string);
        }
        String string2 = string.substring(0, n);
        if (Cap.Export != null && string2.equals(Cap.Export.exportfile.thisName())) {
            for (EfClass efClass : Cap.Export.exportfile.classes) {
                if (!string.equals(efClass.thisName())) continue;
                return Classref.forExportToken(efClass.token);
            }
        }
        int n2 = Cap.Import.tokenForPackage(string2);
        ExportFile exportFile = Cap.Import.exportfileForPackageToken(n2);
        for (EfClass efClass : exportFile.classes) {
            if (!string.equals(efClass.thisName())) continue;
            return 0x8000 | n2 << 8 | efClass.token;
        }
        throw new VerifierError("Classref.7", (Object)string, (Object)string2);
    }

    static int forExportToken(int n) {
        ExportedClass exportedClass = Cap.Export.firstExportedClass();
        for (int i = 0; i < Cap.Export.classCount(); ++i) {
            if (i == n) {
                return exportedClass.classOffset();
            }
            exportedClass.next();
        }
        throw new VerifierError("Classref.8", n);
    }

    public static EfClass toExportClass(int n) {
        if (Classref.isExternal(n)) {
            return Classref.checkExternal(n);
        }
        ClassDescriptor classDescriptor = Classref.checkInternal(n);
        int n2 = classDescriptor.token();
        if (n2 == 255) {
            return null;
        }
        if (Cap.Export == null) {
            return null;
        }
        return Cap.Export.exportclassForToken(n2);
    }

    public static EfClass checkExportedAndReturnExportClass(int n) {
        if (Classref.isExternal(n)) {
            return Classref.checkExternal(n);
        }
        ClassDescriptor classDescriptor = Classref.checkInternal(n);
        int n2 = classDescriptor.token();
        if (n2 == 255) {
            return null;
        }
        if (Cap.Export == null) {
            return null;
        }
        if (!Cap.Export.isExported(n)) {
            return null;
        }
        return Cap.Export.exportclassForToken(n2);
    }

    static boolean implementsInterface(int n, int n2) {
        int n3;
        if (Classref.isExternal(n)) {
            int n4;
            if (!Classref.isExternal(n2)) {
                return false;
            }
            EfClass efClass = Classref.exportclassForExternal(n);
            EfClass efClass2 = Classref.exportclassForExternal(n2);
            for (n4 = 0; n4 < efClass.interfaces.length; ++n4) {
                if (!efClass.interfaceName(n4).equals(efClass2.thisName())) continue;
                return true;
            }
            for (n4 = 0; n4 < efClass.supers.length; ++n4) {
                EfClass efClass3 = Classref.exportclassForName(efClass.superName(n4));
                if (efClass3 == null) continue;
                int n5 = 0;
                while (n4 < efClass3.interfaces.length) {
                    if (efClass3.interfaceName(n5).equals(efClass2.thisName())) {
                        return true;
                    }
                    ++n5;
                }
            }
            return false;
        }
        ClassDescriptor classDescriptor = Classref.checkInternal(n);
        for (n3 = 0; n3 < classDescriptor.interfaceCount(); ++n3) {
            if (!Classref.extendsInterface(classDescriptor.interfaceRef(n3), n2)) continue;
            return true;
        }
        if ((classDescriptor.flags() & 0x40) != 0) {
            return false;
        }
        n3 = Cap.Class.infoOfs(n).superclass();
        if (n3 == 65535) {
            return false;
        }
        return Classref.implementsInterface(n3, n2);
    }

    static boolean extendsInterface(int n, int n2) {
        if (n == n2) {
            return true;
        }
        if (Classref.isExternal(n)) {
            if (!Classref.isExternal(n2)) {
                return false;
            }
            EfClass efClass = Classref.exportclassForExternal(n);
            EfClass efClass2 = Classref.exportclassForExternal(n2);
            for (int i = 0; i < efClass.interfaces.length; ++i) {
                if (!efClass.interfaceName(i).equals(efClass2.thisName())) continue;
                return true;
            }
            return false;
        }
        ClassInfo classInfo = Cap.Class.infoOfs(n);
        for (int i = 0; i < classInfo.interfaceCount(); ++i) {
            if (classInfo.superinterface(i) != n2) continue;
            return true;
        }
        return false;
    }

    static int numberOfMethods(int n) {
        if (Classref.isExternal(n)) {
            return Classref.checkExternal((int)n).methods.length;
        }
        return Classref.checkInternal(n).methodCount();
    }

    static int totalInstanceSize(int n) {
        if (Classref.isExternal(n)) {
            EfClass efClass = Classref.checkExternal(n);
            int n2 = efClass.declaredInstanceSize();
            for (int i = 0; i < efClass.supers.length; ++i) {
                n2 += Classref.exportclassForName(efClass.superName(i)).declaredInstanceSize();
            }
            return n2;
        }
        ClassInfo classInfo = Cap.Class.infoOfs(n);
        if ((classInfo.flags() & 8) != 0) {
            return 0;
        }
        if (classInfo.superclass() == 65535) {
            return classInfo.declaredInstanceSize();
        }
        return Classref.totalInstanceSize(classInfo.superclass()) + classInfo.declaredInstanceSize();
    }

    static String pretty(int n) {
        if (Classref.isExternal(n)) {
            EfClass efClass = Classref.checkExternal(n);
            return efClass.thisName().replace('/', '.');
        }
        return Messages.format("Classref.10", n);
    }

    static boolean isMultiSelectable(int n) {
        return Classref.implementsInterface(n, multiSelectable);
    }

    static boolean isRemote(int n, boolean bl) {
        if (Remote == -1) {
            try {
                Remote = Classref.refForName("java/rmi/Remote");
            }
            catch (VerifierError verifierError) {
                return false;
            }
        }
        if (bl) {
            return Classref.implementsInterface(n, Remote);
        }
        return Classref.extendsInterface(n, Remote);
    }

    static void initialize() {
        Object = Classref.refForName("java/lang/Object");
        Throwable = Classref.refForName("java/lang/Throwable");
        try {
            Shareable = Classref.refForName("javacard/framework/Shareable");
            multiSelectable = Classref.refForName("javacard/framework/MultiSelectable");
        }
        catch (VerifierError verifierError) {
            if (ImportComponent.findExportByName("javacard/framework") != null) {
                VerifierError.warning("Classref.100");
            }
            Shareable = -1;
            multiSelectable = -1;
        }
    }

    static {
        Remote = -1;
    }
}

