/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.VerifierError;

public class Safeptr {
    byte[] componentData;
    String componentName;
    public int ofs;

    Safeptr(byte[] byArray, String string) {
        this.componentData = byArray;
        this.componentName = string;
        this.ofs = 0;
    }

    Safeptr(Safeptr safeptr) {
        this.componentData = safeptr.componentData;
        this.componentName = safeptr.componentName;
        this.ofs = safeptr.ofs;
    }

    Safeptr(Safeptr safeptr, int n) {
        this.componentData = safeptr.componentData;
        this.componentName = safeptr.componentName;
        this.ofs = n;
        if (this.ofs < 0 || this.ofs > this.componentData.length) {
            this.overflow(0);
        }
    }

    public int u1(int n) {
        if (this.ofs + n >= this.componentData.length) {
            this.overflow(n);
        }
        return this.componentData[this.ofs + n] & 0xFF;
    }

    public int s1(int n) {
        if (this.ofs + n >= this.componentData.length) {
            this.overflow(n);
        }
        return this.componentData[this.ofs + n];
    }

    public int u2(int n) {
        if (this.ofs + n + 1 >= this.componentData.length) {
            this.overflow(n);
        }
        return (this.componentData[this.ofs + n] & 0xFF) << 8 | this.componentData[this.ofs + n + 1] & 0xFF;
    }

    public int s2(int n) {
        if (this.ofs + n + 1 >= this.componentData.length) {
            this.overflow(n);
        }
        return this.componentData[this.ofs + n] << 8 | this.componentData[this.ofs + n + 1] & 0xFF;
    }

    public int s4(int n) {
        if (this.ofs + n + 3 >= this.componentData.length) {
            this.overflow(n);
        }
        return this.componentData[this.ofs + n] << 24 | (this.componentData[this.ofs + n + 1] & 0xFF) << 16 | (this.componentData[this.ofs + n + 2] & 0xFF) << 8 | this.componentData[this.ofs + n + 3] & 0xFF;
    }

    public int nibble(int n) {
        if ((n & 1) == 0) {
            return this.u1(n >> 1) >> 4;
        }
        return this.u1(n >> 1) & 0xF;
    }

    public void advance(int n) {
        this.ofs += n;
        if (this.ofs < 0 || this.ofs > this.componentData.length) {
            this.overflow(0);
        }
    }

    public Safeptr offset(int n) {
        return new Safeptr(this, this.ofs + n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Safeptr)) {
            return false;
        }
        Safeptr safeptr = (Safeptr)object;
        if (safeptr.componentData.length != this.componentData.length) {
            return false;
        }
        for (int i = 0; i < this.componentData.length; ++i) {
            if (safeptr.componentData[i] == this.componentData[i]) continue;
            return false;
        }
        return safeptr.ofs == this.ofs;
    }

    public String toString() {
        return Messages.format("Safeptr.2", (Object)this.componentName, this.ofs);
    }

    private void overflow(int n) {
        throw new VerifierError("Safeptr.1", (Object)this.toString(), n);
    }

    public int size() {
        return this.componentData.length;
    }

    public boolean atComponentEnd() {
        return this.ofs == this.componentData.length;
    }

    public void write1(int n, int n2) {
        if (this.ofs + n >= this.componentData.length) {
            this.overflow(n);
        }
        this.componentData[this.ofs + n] = (byte)n2;
    }

    public void write2(int n, int n2) {
        if (this.ofs + n + 1 >= this.componentData.length) {
            this.overflow(n);
        }
        this.componentData[this.ofs + n] = (byte)(n2 >> 8);
        this.componentData[this.ofs + n + 1] = (byte)n2;
    }
}

