/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcwde;

import com.sun.javacard.jcwde.Globals;
import com.sun.javacard.jcwde.SimulationException;
import java.util.Vector;
import javacard.framework.SystemException;
import javacard.framework.TransactionException;

public class SimSystem {
    private static byte transDepth;
    private static Vector clearOnResetTransientObjs;
    private static Vector clearOnDeselectTransientObjs;

    static {
        clearOnResetTransientObjs = new Vector(0, 5);
        clearOnDeselectTransientObjs = new Vector(0, 5);
    }

    public static void abortTransaction() throws TransactionException {
        if (transDepth == 0) {
            TransactionException.throwIt((short)2);
        }
        transDepth = 0;
    }

    private static void addTransientArray(Object array, byte event) throws SystemException {
        if (SimSystem.isTransient(array) != 0) {
            SystemException.throwIt((short)3);
        }
        Vector vect = null;
        switch (event) {
            case 1: {
                vect = clearOnResetTransientObjs;
                break;
            }
            case 2: {
                vect = clearOnDeselectTransientObjs;
                break;
            }
            default: {
                SystemException.throwIt((short)1);
            }
        }
        vect.addElement(array);
    }

    public static void beginTransaction() throws TransactionException {
        if (transDepth != 0) {
            TransactionException.throwIt((short)1);
        }
        transDepth = 1;
    }

    public static void clearTransientObjs(byte event) {
        Vector vect = null;
        switch (event) {
            case 1: {
                SimSystem.clearTransientObjs((byte)2);
                vect = clearOnResetTransientObjs;
                break;
            }
            case 2: {
                vect = clearOnDeselectTransientObjs;
                break;
            }
            default: {
                SystemException.throwIt((short)1);
            }
        }
        int i = vect.size() - 1;
        while (i >= 0) {
            int j;
            Object[] array;
            Object object = vect.elementAt(i);
            if (object instanceof boolean[]) {
                array = (boolean[])object;
                j = array.length - 1;
                while (j >= 0) {
                    array[j] = false;
                    --j;
                }
            } else if (object instanceof byte[]) {
                array = (byte[])object;
                j = array.length - 1;
                while (j >= 0) {
                    array[j] = false;
                    --j;
                }
            } else if (object instanceof short[]) {
                array = (short[])object;
                j = array.length - 1;
                while (j >= 0) {
                    array[j] = false;
                    --j;
                }
            } else if (object instanceof Object[]) {
                array = (Object[])object;
                j = array.length - 1;
                while (j >= 0) {
                    array[j] = null;
                    --j;
                }
            } else {
                System.err.println(Globals._messages.getString("ClearTrans"));
                throw new SimulationException();
            }
            --i;
        }
    }

    public static void commitTransaction() throws TransactionException {
        if (transDepth == 0) {
            TransactionException.throwIt((short)2);
        }
        transDepth = 0;
    }

    public static short getMaxCommitCapacity() {
        return Short.MAX_VALUE;
    }

    public static byte getTransactionDepth() {
        return transDepth;
    }

    public static short getUnusedCommitCapacity() {
        return Short.MAX_VALUE;
    }

    public static byte isTransient(Object object) throws SystemException {
        if (object != null) {
            if (clearOnResetTransientObjs.contains(object)) {
                return 1;
            }
            if (clearOnDeselectTransientObjs.contains(object)) {
                return 2;
            }
        }
        return 0;
    }

    public static boolean[] makeTransientBooleanArray(short length, byte event) throws SystemException {
        boolean[] array = new boolean[length];
        SimSystem.addTransientArray(array, event);
        return array;
    }

    public static byte[] makeTransientByteArray(short length, byte event) throws SystemException {
        byte[] array = new byte[length];
        SimSystem.addTransientArray(array, event);
        return array;
    }

    public static Object[] makeTransientObjectArray(short length, byte event) throws SystemException {
        Object[] array = new Object[length];
        SimSystem.addTransientArray(array, event);
        return array;
    }

    public static short[] makeTransientShortArray(short length, byte event) throws SystemException {
        short[] array = new short[length];
        SimSystem.addTransientArray(array, event);
        return array;
    }
}

