/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AbstrInterp;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassAndFieldDescriptor;
import com.sun.javacard.offcardverifier.ClassAndMethodDescriptor;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.ConstantPoolEntry;
import com.sun.javacard.offcardverifier.ExnHandler;
import com.sun.javacard.offcardverifier.ExnHandlerInfo;
import com.sun.javacard.offcardverifier.FieldTypeAndFlags;
import com.sun.javacard.offcardverifier.Fieldref;
import com.sun.javacard.offcardverifier.Instr;
import com.sun.javacard.offcardverifier.InstrLookupSwitch;
import com.sun.javacard.offcardverifier.InstrTableSwitch;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodInfo;
import com.sun.javacard.offcardverifier.MethodTypeAndFlags;
import com.sun.javacard.offcardverifier.Methodref;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Type;
import com.sun.javacard.offcardverifier.TypeArray;
import com.sun.javacard.offcardverifier.TypeClass;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;

class Checkcode {
    Checkcode() {
    }

    private static void canAccess(int flags, int user, int provider) {
        if ((flags & 1) != 0) {
            return;
        }
        if ((flags & 2) != 0) {
            if (user == provider) {
                return;
            }
            throw new VerifierError("Checkcode.34", provider, user);
        }
        if ((flags & 4) != 0) {
            if (!Classref.isExternal(provider)) {
                return;
            }
            if (Classref.isSubclass(user, provider)) {
                return;
            }
            throw new VerifierError("Checkcode.35", provider, user);
        }
        if (!Classref.isExternal(provider)) {
            return;
        }
        throw new VerifierError("Checkcode.36", provider, user);
    }

    private static void checkAccessClassref(ClassDescriptor user, int idx) {
        int provider = Cap.ConstantPool.entry(idx).classRef();
        int flags = Classref.checkAndGetAccessFlags(provider);
        Checkcode.canAccess(flags & 1, user.thisClass(), provider);
    }

    private static void checkAccessInstanceField(ClassDescriptor user, int idx, boolean write) {
        ConstantPoolEntry entry = Cap.ConstantPool.entry(idx);
        int provider = entry.classRefVirtualRef();
        FieldTypeAndFlags ftyf = Fieldref.findByToken(provider, entry.tokenVirtualRef(), false);
        Checkcode.canAccess(ftyf.flags, user.thisClass(), provider);
        if (write && (ftyf.flags & 0x10) != 0 && user.thisClass() != provider) {
            throw new VerifierError("Checkcode.42");
        }
    }

    private static void checkAccessStaticField(ClassDescriptor user, int idx, boolean write) {
        int flags;
        int provider;
        ConstantPoolEntry entry = Cap.ConstantPool.entry(idx);
        if (entry.isExternalStaticRef()) {
            provider = entry.classStaticRef();
            FieldTypeAndFlags ftyf = Fieldref.findByToken(provider, entry.tokenStaticRef(), true);
            flags = ftyf.flags;
        } else {
            ClassAndFieldDescriptor cf = Fieldref.findDescr(entry.internalStaticRef());
            provider = cf.classDescr.thisClass();
            flags = cf.fieldDescr.flags();
        }
        Checkcode.canAccess(flags, user.thisClass(), provider);
        if (write && (flags & 0x10) != 0) {
            throw new VerifierError("Checkcode.39");
        }
    }

    private static void checkAccessStaticMethod(ClassDescriptor user, int idx) {
        int flags;
        int provider;
        ConstantPoolEntry entry = Cap.ConstantPool.entry(idx);
        if (entry.isExternalStaticRef()) {
            provider = entry.classStaticRef();
            MethodTypeAndFlags mtyf = Methodref.findByToken(provider, entry.tokenStaticRef(), true);
            flags = mtyf.flags;
        } else {
            ClassAndMethodDescriptor cm = Methodref.findDescr(entry.internalStaticRef());
            provider = cm.classDescr.thisClass();
            flags = cm.methodDescr.flags();
        }
        Checkcode.canAccess(flags, user.thisClass(), provider);
    }

    private static void checkAccessVirtualMethod(ClassDescriptor user, int idx) {
        ConstantPoolEntry entry = Cap.ConstantPool.entry(idx);
        int provider = entry.classRefVirtualRef();
        MethodTypeAndFlags mtyf = Methodref.findByToken(provider, entry.tokenVirtualRef(), false);
        Checkcode.canAccess(mtyf.flags, user.thisClass(), provider);
    }

    private static void checkBranchTarget(Instr[] instrs, int pc, int displ) {
        int target = pc + displ;
        if (target < 0 || target >= instrs.length || instrs[target] == null) {
            throw new VerifierError("Checkcode.30", target, pc);
        }
    }

    private static int checkCpoolIndex(int idx) {
        if (idx >= Cap.ConstantPool.count()) {
            throw new VerifierError("Checkcode.32", idx);
        }
        return Cap.ConstantPool.entry(idx).tag();
    }

    private static void checkExnHandlers(Safeptr startCode, Instr[] instrs, int firstExnHandler, int numExnHandlers) {
        int i = 0;
        while (i < numExnHandlers) {
            ExnHandlerInfo exn = Cap.Method.exceptionHandler(firstExnHandler + i);
            Safeptr startPc = Cap.Method.methodCode(exn.startOffset());
            Checkcode.checkExnTarget(instrs, startCode, startPc);
            Safeptr endPc = Cap.Method.methodCode(exn.endOffset());
            if (endPc.ofs != startCode.ofs + instrs.length) {
                Checkcode.checkExnTarget(instrs, startCode, endPc);
            }
            Safeptr handlerPc = Cap.Method.methodCode(exn.handlerOffset());
            Checkcode.checkExnTarget(instrs, startCode, handlerPc);
            int hdlrType = exn.catchType();
            if (hdlrType == 0) {
                if (Checkcode.checkCpoolIndex(0) == 1 && Classref.isSubclass(Cap.ConstantPool.entry(0).classRef(), Classref.Throwable)) {
                    throw new VerifierError("Checkcode.43", firstExnHandler + i);
                }
            } else {
                if (Checkcode.checkCpoolIndex(hdlrType) != 1) {
                    throw new VerifierError("Checkcode.29", hdlrType, (Object)exn);
                }
                if (!Classref.isSubclass(Cap.ConstantPool.entry(hdlrType).classRef(), Classref.Throwable)) {
                    throw new VerifierError("Checkcode.38", firstExnHandler + i);
                }
            }
            int hdlrClass = hdlrType != 0 ? Cap.ConstantPool.entry(hdlrType).classRef() : Classref.Throwable;
            int j = startPc.ofs;
            while (j < endPc.ofs) {
                Instr instr = instrs[j - startCode.ofs];
                if (instr != null) {
                    instr.handler = new ExnHandler(handlerPc.ofs - startCode.ofs, hdlrClass, instr.handler);
                }
                ++j;
            }
            ++i;
        }
    }

    private static void checkExnTarget(Instr[] instrs, Safeptr startCode, Safeptr pc) {
        int target = pc.ofs - startCode.ofs;
        if (target < 0 || target >= instrs.length || instrs[target] == null) {
            throw new VerifierError("Checkcode.31", target);
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void staticCheck(ClassDescriptor thisClass, Instr[] instrs, int maxLocals, TypeMethod methodType, int methodFlags) {
        pc = 0;
        while (pc < instrs.length) {
            block59: {
                try {
                    i = instrs[pc];
                    if (Instr.instrInt[i.opcode]) {
                        Cap.Header.useInts();
                    }
                    block1 : switch (i.opcode) {
                        case 21: 
                        case 22: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 40: 
                        case 41: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 89: 
                        case 114: 
                        case 150: {
                            if (i.arg < maxLocals) break;
                            throw new VerifierError("Checkcode.3", i.arg);
                        }
                        case 23: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 42: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 90: 
                        case 151: {
                            if (i.arg + 1 < maxLocals) break;
                            throw new VerifierError("Checkcode.4", i.arg);
                        }
                        case 63: {
                            m = i.arg;
                            n = i.arg2;
                            mMax = Cap.Header.supportInts != false ? 4 : 2;
                            if (m < 1 || m > mMax || n != 0 && (n < m || n > m + mMax)) {
                                throw new VerifierError("Checkcode.5", m, n);
                            }
                            break block59;
                        }
                        case 64: {
                            m = i.arg;
                            n = i.arg2;
                            mnMax = Cap.Header.supportInts != false ? 2 : 1;
                            if (m < 1 || m > mnMax || n < 1 || n > mnMax) {
                                throw new VerifierError("Checkcode.6", m, n);
                            }
                            break block59;
                        }
                        case 115: 
                        case 116: {
                            it = (InstrTableSwitch)i;
                            if (it.high < it.low || it.high - it.low >= 65536) {
                                throw new VerifierError("Checkcode.7");
                            }
                            Checkcode.checkBranchTarget(instrs, pc, it.dfl);
                            n = 0;
                            while (n < it.offsets.length) {
                                Checkcode.checkBranchTarget(instrs, pc, it.offsets[n]);
                                ++n;
                            }
                            break block59;
                        }
                        case 117: 
                        case 118: {
                            il = (InstrLookupSwitch)i;
                            if (il.ncases >= 65536) {
                                throw new VerifierError("Checkcode.8");
                            }
                            Checkcode.checkBranchTarget(instrs, pc, il.dfl);
                            n = 0;
                            while (true) {
                                if (n < il.ncases) ** GOTO lbl49
                                n = 1;
                                if (true) ** GOTO lbl161
lbl49:
                                // 1 sources

                                Checkcode.checkBranchTarget(instrs, pc, il.offsets[n]);
                                ++n;
                            }
                        }
                        case 119: {
                            if (!(methodType.res instanceof TypeClass) && !(methodType.res instanceof TypeArray)) {
                                throw new VerifierError("Checkcode.9", methodType.res);
                            }
                            break block59;
                        }
                        case 120: {
                            if (!(methodType.res.equals(Type.Short) || methodType.res.equals(Type.Byte) || methodType.res.equals(Type.Boolean))) {
                                throw new VerifierError("Checkcode.10", methodType.res);
                            }
                            break block59;
                        }
                        case 121: {
                            if (methodType.res.equals(Type.Int)) break;
                            throw new VerifierError("Checkcode.11", methodType.res);
                        }
                        case 122: {
                            if (methodType.res.equals(Type.Void)) break;
                            throw new VerifierError("Checkcode.12", methodType.res);
                        }
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 113: 
                        case 152: 
                        case 153: 
                        case 154: 
                        case 155: 
                        case 156: 
                        case 157: 
                        case 158: 
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 165: 
                        case 166: 
                        case 167: 
                        case 168: {
                            Checkcode.checkBranchTarget(instrs, pc, i.arg);
                            break;
                        }
                        case 139: {
                            if (Checkcode.checkCpoolIndex(i.arg) != 3) {
                                throw new VerifierError("Checkcode.13");
                            }
                            Checkcode.checkAccessVirtualMethod(thisClass, i.arg);
                            break;
                        }
                        case 140: {
                            kind = Checkcode.checkCpoolIndex(i.arg);
                            switch (kind) {
                                case 7: {
                                    Checkcode.checkAccessStaticMethod(thisClass, i.arg);
                                    break block1;
                                }
                                case 4: {
                                    Checkcode.checkAccessVirtualMethod(thisClass, i.arg);
                                    break block1;
                                }
                            }
                            throw new VerifierError("Checkcode.14");
                        }
                        case 141: {
                            if (Checkcode.checkCpoolIndex(i.arg) != 6) {
                                throw new VerifierError("Checkcode.15");
                            }
                            Checkcode.checkAccessStaticMethod(thisClass, i.arg);
                            break;
                        }
                        case 142: {
                            if (Checkcode.checkCpoolIndex(i.arg) != 1) {
                                throw new VerifierError("Checkcode.16");
                            }
                            Checkcode.checkAccessClassref(thisClass, i.arg);
                            break;
                        }
                        case 143: 
                        case 145: {
                            if (Checkcode.checkCpoolIndex(i.arg) != 1) {
                                throw new VerifierError("Checkcode.17");
                            }
                            Checkcode.checkAccessClassref(thisClass, i.arg);
                            break;
                        }
                        case 144: {
                            kind = i.arg;
                            if (kind < 10 || kind > 13) {
                                throw new VerifierError("Checkcode.18", kind);
                            }
                            if (kind != 13) break;
                            Cap.Header.useInts();
                            break;
                        }
                        case 148: 
                        case 149: {
                            kind = i.arg;
                            if (kind != 0 && (kind < 10 || kind > 14)) {
                                throw new VerifierError("Checkcode.19");
                            }
                            if (kind == 0 || kind == 14) {
                                if (Checkcode.checkCpoolIndex(i.arg2) != 1) {
                                    throw new VerifierError("Checkcode.20");
                                }
                                Checkcode.checkAccessClassref(thisClass, i.arg2);
                            } else if (i.arg2 != 0) {
                                throw new VerifierError("Checkcode.21");
                            }
                            if (kind != 13) break;
                            Cap.Header.useInts();
                            break;
                        }
                        case 123: 
                        case 124: 
                        case 125: 
                        case 126: 
                        case 127: 
                        case 128: 
                        case 129: 
                        case 130: {
                            idx = i.arg;
                            kind = i.opcode - 123 & 3;
                            if (Checkcode.checkCpoolIndex(idx) != 5) {
                                throw new VerifierError("Checkcode.22");
                            }
                            Checkcode.staticCheckFieldref(idx, kind);
                            Checkcode.checkAccessStaticField(thisClass, idx, i.opcode == 127 || i.opcode == 128 || i.opcode == 129 || i.opcode == 130);
                            break;
                        }
                        case 131: 
                        case 132: 
                        case 133: 
                        case 134: 
                        case 135: 
                        case 136: 
                        case 137: 
                        case 138: {
                            idx = i.arg;
                            kind = i.opcode - 131 & 3;
                            if (Checkcode.checkCpoolIndex(idx) != 2) {
                                throw new VerifierError("Checkcode.23");
                            }
                            Checkcode.staticCheckFieldref(idx, kind);
                            Checkcode.checkAccessInstanceField(thisClass, idx, i.opcode == 135 || i.opcode == 136 || i.opcode == 137 || i.opcode == 138);
                            break;
                        }
                        case 169: 
                        case 170: 
                        case 171: 
                        case 172: 
                        case 177: 
                        case 178: 
                        case 179: 
                        case 180: {
                            idx = i.arg;
                            kind = i.opcode - 169 & 3;
                            if (Checkcode.checkCpoolIndex(idx) != 2) {
                                throw new VerifierError("Checkcode.24");
                            }
                            Checkcode.staticCheckFieldref(idx, kind);
                            Checkcode.checkAccessInstanceField(thisClass, idx, i.opcode == 177 || i.opcode == 178 || i.opcode == 179 || i.opcode == 180);
                            break;
                        }
                        case 173: 
                        case 174: 
                        case 175: 
                        case 176: 
                        case 181: 
                        case 182: 
                        case 183: 
                        case 184: {
                            if (maxLocals == 0) {
                                throw new VerifierError("Checkcode.25");
                            }
                            if ((methodFlags & 8) != 0) {
                                throw new VerifierError("Checkcode.40");
                            }
                            idx = i.arg;
                            kind = i.opcode - 173 & 3;
                            if (Checkcode.checkCpoolIndex(idx) != 2) {
                                throw new VerifierError("Checkcode.26");
                            }
                            Checkcode.staticCheckFieldref(idx, kind);
                            Checkcode.checkAccessInstanceField(thisClass, idx, i.opcode == 181 || i.opcode == 182 || i.opcode == 183 || i.opcode == 184);
                            break;
                        }
                    }
                    break block59;
                    do {
                        if (il.keys[n - 1] >= il.keys[n]) {
                            throw new VerifierError("Checkcode.37");
                        }
                        ++n;
lbl161:
                        // 2 sources

                    } while (n < il.ncases);
                    ** break;
                }
                catch (VerifierError e) {
                    throw new VerifierError("Checkcode.27", pc, (Object)e.getMessage());
                }
            }
            pc += i.length();
        }
        if (pc != instrs.length) {
            throw new VerifierError("Checkcode.28");
        }
    }

    private static void staticCheckFieldref(int idx, int kind) {
        Safeptr typ = Cap.TypeDescr.at(Cap.TypeDescr.constantPoolType(idx));
        int t = typ.nibble(2);
        switch (kind) {
            case 0: {
                if (t != 6 && (t < 10 || t > 14)) break;
                return;
            }
            case 1: {
                if (t != 2 && t != 3) break;
                return;
            }
            case 2: {
                if (t != 4) break;
                return;
            }
            case 3: {
                if (t != 5) break;
                return;
            }
        }
        throw new VerifierError("Checkcode.33");
    }

    static void typecheck(ClassDescriptor cdesc, MethodDescriptor mdesc, MethodInfo minfo) {
        boolean isInit;
        Safeptr startCode;
        int maxLocals;
        int numParams;
        int maxStack;
        if ((minfo.flags() & 8) == 0) {
            maxStack = minfo.maxStackCompact();
            numParams = minfo.numArgsCompact();
            maxLocals = minfo.maxLocalsCompact() + numParams;
            startCode = minfo.bytecodeCompact();
        } else {
            maxStack = minfo.maxStackExtended();
            numParams = minfo.numArgsExtended();
            maxLocals = minfo.maxLocalsExtended() + numParams;
            startCode = minfo.bytecodeExtended();
        }
        int codeLen = mdesc.bytecodeCount();
        int firstExnHandler = mdesc.exnHandlerIndex();
        int numExnHandler = mdesc.exnHandlerCount();
        int flags = mdesc.flags();
        TypeMethod mty = TypeMethod.parseCap(Cap.TypeDescr.at(mdesc.type()));
        int numArgs = mty.args.length;
        if ((flags & 8) == 0) {
            ++numArgs;
        }
        if (numParams != numArgs) {
            throw new VerifierError("Checkcode.1");
        }
        if (maxLocals > 255) {
            throw new VerifierError("Checkcode.41");
        }
        Instr[] instrs = Instr.instrsBetween(startCode, codeLen);
        Checkcode.staticCheck(cdesc, instrs, maxLocals, mty, flags);
        Checkcode.checkExnHandlers(startCode, instrs, firstExnHandler, numExnHandler);
        TypeClass tySelf = (flags & 8) == 0 ? new TypeClass(cdesc.thisClass()) : null;
        boolean bl = isInit = (flags & 0x80) != 0;
        if (Verifier.printTrace) {
            System.out.println("** Verifying method " + minfo.toString());
        }
        AbstrInterp.simulate(instrs, maxStack, maxLocals, mty, tySelf, isInit, new TypeClass(cdesc.thisClass()));
    }
}

