/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassAndMethodDescriptor;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.ConstantPoolEntry;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.FieldTypeAndFlags;
import com.sun.javacard.offcardverifier.Fieldref;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodTypeAndFlags;
import com.sun.javacard.offcardverifier.Methodref;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Type;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;

class ConstantPoolComponent
extends Safeptr {
    ConstantPoolComponent(byte[] data) {
        super(data, "ConstantPool");
    }

    int count() {
        return this.u2(0);
    }

    ConstantPoolEntry entry(int n) {
        return new ConstantPoolEntry(this.offset(2 + n * 4));
    }

    static boolean fieldIsExternalProtected(int pos) {
        ConstantPoolEntry p = Cap.ConstantPool.entry(pos);
        if (!Classref.isExternal(p.classRefVirtualRef())) {
            return false;
        }
        FieldTypeAndFlags ftyf = Fieldref.findByToken(p.classRefVirtualRef(), p.tokenVirtualRef(), false);
        return (ftyf.flags & 4) != 0;
    }

    static int flagsMethodReference(int pos) {
        ConstantPoolEntry p = Cap.ConstantPool.entry(pos);
        switch (p.tag()) {
            case 4: {
                MethodTypeAndFlags mtyf = Methodref.findByToken(p.classRefVirtualRef(), p.tokenVirtualRef(), false);
                return mtyf.flags;
            }
            case 7: {
                if (p.isExternalStaticRef()) {
                    MethodTypeAndFlags mtyf = Methodref.findByToken(p.classRefVirtualRef(), p.tokenVirtualRef(), true);
                    return mtyf.flags;
                }
                ClassAndMethodDescriptor cmdesc = Methodref.findDescr(p.internalStaticRef());
                return cmdesc.methodDescr.flags();
            }
        }
        throw new VerifierError("ConstantPoolComponent.13");
    }

    static boolean methodIsExternalProtected(int pos) {
        ConstantPoolEntry p = Cap.ConstantPool.entry(pos);
        if (!Classref.isExternal(p.classRefVirtualRef())) {
            return false;
        }
        MethodTypeAndFlags mtyf = Methodref.findByToken(p.classRefVirtualRef(), p.tokenVirtualRef(), false);
        return (mtyf.flags & 4) != 0;
    }

    static boolean methodIsInit(int pos) {
        int flags = ConstantPoolComponent.flagsMethodReference(pos);
        return (flags & 0x80) != 0;
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("ConstantPoolComponent.100");
        }
        if (this.count() != Cap.TypeDescr.constantPoolCount()) {
            throw new VerifierError("ConstantPoolComponent.1");
        }
        int i = 0;
        while (i < this.count()) {
            try {
                this.verifyCpoolEntry(i, this.entry(i));
            }
            catch (VerifierError e) {
                throw new VerifierError("ConstantPoolComponent.2", i, (Object)e.getMessage());
            }
            ++i;
        }
        if (this.size() != 2 + 4 * this.count()) {
            throw new VerifierError("ConstantPoolComponent.16");
        }
    }

    private void verifyCpoolEntry(int i, ConstantPoolEntry p) {
        switch (p.tag()) {
            case 1: {
                Classref.check(p.classRef());
                if (p.classPadding() != 0) {
                    throw new VerifierError("ConstantPoolComponent.3");
                }
                if (Cap.TypeDescr.constantPoolType(i) == 65535) break;
                throw new VerifierError("ConstantPoolComponent.15");
            }
            case 2: {
                FieldTypeAndFlags ftyf = Fieldref.findByToken(p.classRefVirtualRef(), p.tokenVirtualRef(), false);
                int tofs = Cap.TypeDescr.constantPoolType(i);
                if (ftyf.fty.equals(Type.parseCap(Cap.TypeDescr.at(tofs)))) break;
                throw new VerifierError("ConstantPoolComponent.4");
            }
            case 3: 
            case 4: {
                MethodTypeAndFlags mtyf = Methodref.findByToken(p.classRefVirtualRef(), p.tokenVirtualRef(), false);
                if (mtyf == null) {
                    throw new VerifierError("ConstantPoolComponent.5");
                }
                int tofs = Cap.TypeDescr.constantPoolType(i);
                if (!mtyf.mty.equals(TypeMethod.parseCap(Cap.TypeDescr.at(tofs)))) {
                    throw new VerifierError("ConstantPoolComponent.6");
                }
                if (p.tag() != 4 || !Classref.isExternal(p.classRefVirtualRef())) break;
                throw new VerifierError("ConstantPoolComponent.14");
            }
            case 5: {
                Type typ;
                if (p.isExternalStaticRef()) {
                    FieldTypeAndFlags ftyf = Fieldref.findByToken(p.classStaticRef(), p.tokenStaticRef(), true);
                    typ = ftyf.fty;
                } else {
                    if (p.internalStaticPadding() != 0) {
                        throw new VerifierError("ConstantPoolComponent.7");
                    }
                    FieldDescriptor fdesc = Fieldref.checkInternalStatic(p.internalStaticRef());
                    typ = Type.parseField(fdesc.type());
                }
                int tofs = Cap.TypeDescr.constantPoolType(i);
                if (typ.equals(Type.parseCap(Cap.TypeDescr.at(tofs)))) break;
                throw new VerifierError("ConstantPoolComponent.8");
            }
            case 6: {
                int flags;
                TypeMethod mty;
                if (p.isExternalStaticRef()) {
                    int token;
                    int cref = p.classStaticRef();
                    MethodTypeAndFlags mtyf = Methodref.findByToken(cref, token = p.tokenStaticRef(), true);
                    if (mtyf == null) {
                        throw new VerifierError("ConstantPoolComponent.9");
                    }
                    mty = mtyf.mty;
                    flags = mtyf.flags;
                } else {
                    if (p.internalStaticPadding() != 0) {
                        throw new VerifierError("ConstantPoolComponent.10");
                    }
                    ClassAndMethodDescriptor cm = Methodref.findDescr(p.internalStaticRef());
                    MethodDescriptor m = cm.methodDescr;
                    mty = TypeMethod.parseCap(Cap.TypeDescr.at(m.type()));
                    flags = m.flags();
                }
                int tofs = Cap.TypeDescr.constantPoolType(i);
                if (!mty.equals(TypeMethod.parseCap(Cap.TypeDescr.at(tofs)))) {
                    throw new VerifierError("ConstantPoolComponent.11");
                }
                if ((flags & 8) != 0) break;
                p.write1(0, 7);
                break;
            }
            default: {
                throw new VerifierError("ConstantPoolComponent.12", p.tag());
            }
        }
    }
}

