/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.TypeDescriptor;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.BitSet;

class DescriptorComponent
extends Safeptr {
    private int maxInterfaceLocation = Integer.MIN_VALUE;
    private int minClassLocation = Integer.MAX_VALUE;

    DescriptorComponent(byte[] data) {
        super(data, "Descriptor");
    }

    int classCount() {
        return this.u1(0);
    }

    ClassDescriptor firstClassDescriptor() {
        return new ClassDescriptor(this.offset(1));
    }

    private static boolean isInitialSegment(BitSet s) {
        int length = s.length();
        int i = 0;
        while (i < length) {
            if (!s.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("DescriptorComponent.100");
        }
        ClassDescriptor p = Cap.Descriptor.firstClassDescriptor();
        int i = Cap.Descriptor.classCount();
        while (i > 0) {
            p.next();
            --i;
        }
        TypeDescriptor td = new TypeDescriptor(p);
        BitSet typemap = new BitSet();
        int tofs = td.firstTypeByte();
        while (tofs <= td.lastTypeByte()) {
            typemap.set(tofs);
            tofs = this.verifyTypeDescr(td, tofs);
        }
        Cap.TypeDescr = td;
        p = Cap.Descriptor.firstClassDescriptor();
        BitSet classTokens = new BitSet();
        int i2 = Cap.Descriptor.classCount();
        while (i2 > 0) {
            try {
                this.verifyClassDescr(typemap, p, classTokens);
            }
            catch (VerifierError e) {
                throw new VerifierError("DescriptorComponent.1", (Object)p, (Object)e.getMessage());
            }
            p.next();
            --i2;
        }
        int i3 = 0;
        while (i3 < td.constantPoolCount()) {
            int tofs2 = td.constantPoolType(i3);
            if (tofs2 != 65535) {
                this.verifyTypeOffset(typemap, tofs2);
            }
            ++i3;
        }
    }

    private void verifyClassDescr(BitSet typemap, ClassDescriptor cdescr, BitSet classTokens) {
        int i;
        int flags = cdescr.flags();
        int token = cdescr.token();
        if ((flags & 0xFFFFFF2E) != 0) {
            throw new VerifierError("DescriptorComponent.7", flags);
        }
        if (Classref.isExternal(cdescr.thisClass())) {
            throw new VerifierError("DescriptorComponent.26");
        }
        if ((flags & 0x40) != 0 && (flags & 0x80) == 0) {
            throw new VerifierError("DescriptorComponent.8");
        }
        if ((flags & 0x90) == 144) {
            throw new VerifierError("DescriptorComponent.31");
        }
        if ((flags & 1) == 0 && token != 255) {
            throw new VerifierError("DescriptorComponent.9", token);
        }
        if ((flags & 1) != 0 && token == 255) {
            throw new VerifierError("DescriptorComponent.27");
        }
        if ((flags & 0x40) != 0) {
            if (cdescr.thisClass() >= this.minClassLocation) {
                throw new VerifierError("DescriptorComponent.44");
            }
            if (cdescr.thisClass() > this.maxInterfaceLocation) {
                this.maxInterfaceLocation = cdescr.thisClass();
            }
            if (cdescr.fieldCount() != 0) {
                throw new VerifierError("DescriptorComponent.37");
            }
            if (cdescr.interfaceCount() != 0) {
                throw new VerifierError("DescriptorComponent.46");
            }
        } else {
            if (cdescr.thisClass() <= this.maxInterfaceLocation) {
                throw new VerifierError("DescriptorComponent.45");
            }
            if (cdescr.thisClass() < this.minClassLocation) {
                this.minClassLocation = cdescr.thisClass();
            }
            BitSet staticFieldTokens = new BitSet();
            BitSet instanceFieldTokens = new BitSet();
            i = 0;
            while (i < cdescr.fieldCount()) {
                try {
                    this.verifyFieldDescr(typemap, cdescr, cdescr.fieldDescr(i), staticFieldTokens, instanceFieldTokens);
                }
                catch (VerifierError e) {
                    throw new VerifierError("DescriptorComponent.10", i, (Object)e.getMessage());
                }
                ++i;
            }
            if (!DescriptorComponent.isInitialSegment(staticFieldTokens)) {
                throw new VerifierError("DescriptorComponent.41");
            }
        }
        BitSet staticMethodTokens = new BitSet();
        BitSet instanceMethodTokens = new BitSet();
        i = 0;
        while (i < cdescr.methodCount()) {
            try {
                this.verifyMethodDescr(cdescr, typemap, cdescr.methodDescr(i), staticMethodTokens, instanceMethodTokens);
            }
            catch (VerifierError e) {
                throw new VerifierError("DescriptorComponent.11", i, (Object)e.getMessage());
            }
            ++i;
        }
        if (!DescriptorComponent.isInitialSegment(staticMethodTokens)) {
            throw new VerifierError("DescriptorComponent.42");
        }
        if ((flags & 0x40) != 0 && !DescriptorComponent.isInitialSegment(instanceMethodTokens)) {
            throw new VerifierError("DescriptorComponent.43");
        }
        if ((flags & 1) != 0) {
            if (classTokens.get(token)) {
                throw new VerifierError("DescriptorComponent.30", token);
            }
            classTokens.set(token);
        }
    }

    private void verifyFieldDescr(BitSet typemap, ClassDescriptor cdescr, FieldDescriptor fdescr, BitSet staticFieldTokens, BitSet instanceFieldTokens) {
        int tofs;
        boolean noTokenAssigned;
        int flags = fdescr.flags();
        int token = fdescr.token();
        if ((flags & 0xFFFFFFE0) != 0) {
            throw new VerifierError("DescriptorComponent.12", flags);
        }
        switch (flags & 7) {
            default: {
                throw new VerifierError("DescriptorComponent.13", flags);
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
        }
        boolean bl = noTokenAssigned = (flags & 8) != 0 && (flags & 5) == 0;
        if (noTokenAssigned && token != 255) {
            throw new VerifierError("DescriptorComponent.14");
        }
        if ((flags & 8) == 0) {
            if (fdescr.classRefVirtualRef() != cdescr.thisClass()) {
                throw new VerifierError("DescriptorComponent.16");
            }
            if (fdescr.tokenVirtualRef() != fdescr.token()) {
                throw new VerifierError("DescriptorComponent.17");
            }
        }
        if (((tofs = fdescr.type()) & 0x8000) == 0) {
            this.verifyTypeOffset(typemap, tofs);
            Safeptr typ = Cap.TypeDescr.at(tofs);
            if (typ.u1(0) == 0 || typ.nibble(2) != 6 && (typ.nibble(2) < 10 || typ.nibble(2) > 14)) {
                throw new VerifierError("DescriptorComponent.24", tofs);
            }
            if (typ.nibble(2) == 13) {
                Cap.Header.useInts();
            }
        } else {
            switch (tofs) {
                case 32773: {
                    Cap.Header.useInts();
                    break;
                }
                default: {
                    throw new VerifierError("DescriptorComponent.18", tofs);
                }
                case 32770: 
                case 32771: 
                case 32772: 
            }
            if ((flags & 0x18) == 24) {
                throw new VerifierError("DescriptorComponent.39");
            }
        }
        if ((flags & 8) != 0 && fdescr.packageTokenRef() != 0) {
            throw new VerifierError("DescriptorComponent.19");
        }
        if (!noTokenAssigned) {
            BitSet fieldTokens;
            BitSet bitSet = fieldTokens = (flags & 8) != 0 ? staticFieldTokens : instanceFieldTokens;
            if (fieldTokens.get(token)) {
                throw new VerifierError("DescriptorComponent.28", token);
            }
            fieldTokens.set(token);
        }
    }

    private void verifyMethodDescr(ClassDescriptor cdescr, BitSet typemap, MethodDescriptor mdescr, BitSet staticMethodTokens, BitSet instanceMethodTokens) {
        boolean noTokenAssigned;
        int flags = mdescr.flags();
        int token = mdescr.token();
        if ((flags & 0xFFFFFF20) != 0) {
            throw new VerifierError("DescriptorComponent.20", flags);
        }
        switch (flags & 7) {
            default: {
                throw new VerifierError("DescriptorComponent.21", flags);
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
        }
        if ((cdescr.flags() & 0x80) == 0 && (flags & 0x40) != 0) {
            throw new VerifierError("DescriptorComponent.40");
        }
        if ((flags & 0x40) != 0 && (flags & 0x12) != 0) {
            throw new VerifierError("DescriptorComponent.38");
        }
        boolean bl = noTokenAssigned = (flags & 2) != 0 || (flags & 5) == 0 && (flags & 0x88) != 0;
        if (noTokenAssigned && token != 255) {
            throw new VerifierError("DescriptorComponent.22");
        }
        this.verifyTypeOffset(typemap, mdescr.type());
        if (!noTokenAssigned) {
            BitSet methodTokens;
            BitSet bitSet = methodTokens = (flags & 0x88) != 0 ? staticMethodTokens : instanceMethodTokens;
            if (methodTokens.get(token)) {
                throw new VerifierError("DescriptorComponent.29", token);
            }
            methodTokens.set(token);
        }
        if ((cdescr.flags() & 0x40) != 0) {
            if (flags != 65) {
                throw new VerifierError("DescriptorComponent.32");
            }
            if (mdescr.methodOffset() != 0) {
                throw new VerifierError("DescriptorComponent.33");
            }
            if (mdescr.bytecodeCount() != 0) {
                throw new VerifierError("DescriptorComponent.34");
            }
            if (mdescr.exnHandlerCount() != 0) {
                throw new VerifierError("DescriptorComponent.35");
            }
            if (mdescr.exnHandlerIndex() != 0) {
                throw new VerifierError("DescriptorComponent.36");
            }
        }
    }

    private int verifyTypeDescr(TypeDescriptor td, int tofs) {
        Safeptr typtr = td.offset(tofs);
        int nibbleCount = typtr.u1(0);
        Safeptr p = typtr.offset(1);
        if (nibbleCount == 0) {
            throw new VerifierError("DescriptorComponent.2", typtr);
        }
        int i = 0;
        while (i < nibbleCount) {
            switch (p.nibble(i)) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    ++i;
                    break;
                }
                case 6: 
                case 14: {
                    i += 5;
                    break;
                }
                default: {
                    throw new VerifierError("DescriptorComponent.3", p.nibble(i), (Object)typtr);
                }
            }
        }
        if (i > nibbleCount) {
            throw new VerifierError("DescriptorComponent.4", typtr);
        }
        if ((nibbleCount & 1) == 1 && p.nibble(nibbleCount) != 0) {
            throw new VerifierError("DescriptorComponent.5", typtr);
        }
        return tofs + 1 + (nibbleCount + 1) / 2;
    }

    private void verifyTypeOffset(BitSet typemap, int tofs) {
        if (!typemap.get(tofs)) {
            throw new VerifierError("DescriptorComponent.6", tofs);
        }
    }
}

