/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AbstrInterp;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.ImportComponent;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.VerifierError;
import java.io.File;

class Verifier {
    static int verbose = 1;
    static String packageName = null;
    static boolean printTrace = false;

    Verifier() {
    }

    private static void consistencyChecks() {
        Cap.Header.verify();
        Cap.Directory.verify();
        Cap.Descriptor.verify();
        Cap.Import.verify();
        if (Cap.Export != null) {
            Cap.Export.findExportFile();
        }
        Classref.initialize();
        AbstrInterp.initialize();
        Cap.Import.initialize();
        Cap.ConstantPool.verify();
        Cap.Class.verify();
        Cap.Method.verify();
        Cap.StaticField.verify();
        Cap.ReferenceLocation.verify();
        if (Cap.Applet != null) {
            Cap.Applet.verify();
        }
        if (Cap.Export != null) {
            Cap.Export.verify();
        }
        Cap.Import.checkUnreferencedPackages();
        Cap.Header.checkIntFlag();
    }

    public static void main(String[] argv) {
        boolean banner = true;
        int i = 0;
        while (i < argv.length && argv[i].length() > 0 && argv[i].charAt(0) == '-') {
            String s = argv[i];
            if (s.equals("-verbose")) {
                ++verbose;
            } else if (s.equals("-nobanner")) {
                banner = false;
            } else if (s.equals("-help")) {
                Verifier.printUsageAndExit();
            } else if (s.equals("-version")) {
                Messages.println("Main.3");
                System.exit(2);
            } else if (s.equals("-package") && i + 1 < argv.length) {
                packageName = argv[++i];
            } else {
                Verifier.printUsageAndExit();
            }
            ++i;
        }
        if (i == argv.length) {
            Verifier.printUsageAndExit();
        }
        if (verbose >= 1 && banner) {
            Messages.println("Main.3");
        }
        boolean foundCapFile = false;
        while (i < argv.length) {
            try {
                String s = argv[i];
                File f = new File(s);
                if (s.endsWith(".exp")) {
                    ImportComponent.readExportFile(f);
                } else {
                    if (verbose >= 1) {
                        Messages.println("Main.4", s);
                    }
                    Messages.numWarning = 0;
                    Cap.readComponents(f);
                    Verifier.consistencyChecks();
                    if (verbose >= 1) {
                        Messages.println("Main.5", Messages.numWarning);
                    }
                    foundCapFile = true;
                }
            }
            catch (VerifierError e) {
                Messages.printTo(System.err);
                Messages.println("Main.2", Messages.numWarning, (Object)e.getMessage(), (Object)Messages.format("Main.6"));
                System.exit(2);
            }
            ++i;
        }
        if (!foundCapFile && verbose >= 1) {
            Verifier.printUsageAndExit();
        }
    }

    private static void printUsageAndExit() {
        Messages.printTo(System.err);
        Messages.println("Main.1");
        System.exit(2);
    }
}

