/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.jcdebugproxy;

import com.oracle.javacard.jcdebugproxy.ArrayDebugInfoImpl;
import com.oracle.javacard.jcdebugproxy.DebugComponentMissingException;
import com.oracle.tee.tools.util.CapFile;
import com.oracle.tee.tools.util.Closables;
import com.oracle.tee.tools.util.IOUtils;
import com.oracle.tee.tools.util.Utils;
import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classparser.ClassDebugInfo;
import com.sun.javacard.debugproxy.classparser.FieldDebugInfo;
import com.sun.javacard.debugproxy.classparser.LocalVariable;
import com.sun.javacard.debugproxy.classparser.MethodDebugInfo;
import com.sun.javacard.debugproxy.classparser.VMClassPool;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassFileTokens {
    public static final int CONSTANT_Classref = 1;
    public static final int CONSTANT_InstanceFieldref = 2;
    public static final int CONSTANT_VirtualMethodref = 3;
    public static final int CONSTANT_SuperMethodref = 4;
    public static final int CONSTANT_StaticFieldref = 5;
    public static final int CONSTANT_StaticMethodref = 6;
    public static final byte CLASS_TYPE = 1;
    public static final byte INTERFACE_TYPE = 2;
    public static final byte ARRAY_TYPE = 3;
    private int classCount = 256;
    private boolean hasDebugInfo = true;
    private String[] strings_table;
    private String packageName;
    private ClassDebugInfo[] classes;
    private byte[] method_component;
    private byte[] packageAID;

    public boolean hasDebugInfo() {
        return this.hasDebugInfo;
    }

    public void updateClassLocation(int classToken, int classOffset) {
        if (this.hasDebugInfo) {
            return;
        }
        for (int i = 0; i < this.classCount; ++i) {
            if (!(this.classes[i] instanceof ClassDebugInfoImpl)) continue;
            ClassDebugInfoImpl cl = (ClassDebugInfoImpl)this.classes[i];
            if (cl.token != classToken) continue;
            Log.LOG(3, "Update " + cl.getClassName() + " location: from " + cl.location + " to " + classOffset);
            cl.location = classOffset;
        }
    }

    public ClassFileTokens(boolean hasDebugInfo, byte[] packageAID, ClassDebugInfoImpl[] classes) throws IOException {
        this.packageAID = (byte[])packageAID.clone();
        this.initClasses(classes);
        this.hasDebugInfo = hasDebugInfo;
    }

    private void initClasses(ClassDebugInfoImpl[] classList) {
        this.classCount = classList.length;
        this.classes = new ClassDebugInfo[classList.length * 2];
        for (int i = 0; i < classList.length; ++i) {
            this.classes[i] = classList[i];
            classList[i].classId = i + 1;
            ArrayDebugInfoImpl array = new ArrayDebugInfoImpl(classList[i]);
            array.classId = this.classCount + i + 1;
            this.classes[this.classCount + i] = array;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassFileTokens(CapFile cf) throws IOException, DebugComponentMissingException {
        Closables manager = new Closables();
        InputStream in = null;
        try {
            in = cf.getComponent("Method.cap");
            manager.add(in);
            if (in.skip(3L) != 3L) {
                throw new IOException("Skip failed");
            }
            this.method_component = IOUtils.readBytesFromStream(in);
            in = cf.getComponent("Debug.cap");
            if (in == null) {
                throw new DebugComponentMissingException("SCD Warning: " + cf + " Does not have a debug component. check SCD mode or re-try with EXP file.", cf.toString());
            }
            in = new BufferedInputStream(in);
            manager.add(in);
            in.read();
            ClassFileTokens.read(in, 2);
            this.strings_table = new String[ClassFileTokens.read(in, 2)];
            for (int i = 0; i < this.strings_table.length; ++i) {
                this.strings_table[i] = ClassFileTokens.readUTF(in, ClassFileTokens.read(in, 2));
            }
            this.packageName = this.strings_table[ClassFileTokens.read(in, 2)];
            ClassDebugInfoImpl[] classList = new ClassDebugInfoImpl[ClassFileTokens.read(in, 2)];
            for (int i = 0; i < classList.length; ++i) {
                classList[i] = this.readClassDebugInfo(in, i);
            }
            this.initClasses(classList);
            in = new BufferedInputStream(cf.getComponent("Header.cap"));
            manager.add(in);
            if (in.skip(12L) != 12L) {
                throw new IOException("Skip failed");
            }
            this.packageAID = new byte[in.read()];
            if (in.read(this.packageAID) == -1) {
                throw new IOException("Read failed");
            }
        }
        finally {
            manager.close();
            if (in != null) {
                in.close();
            }
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String name) {
        this.packageName = name;
    }

    public byte[] getPackageAID() {
        byte[] retVal = new byte[this.packageAID.length];
        System.arraycopy(this.packageAID, 0, retVal, 0, this.packageAID.length);
        return retVal;
    }

    public ClassDebugInfo[] getClasses() {
        return (ClassDebugInfo[])this.classes.clone();
    }

    private ClassDebugInfoImpl readClassDebugInfo(InputStream in, int id) throws IOException {
        int i;
        ClassDebugInfoImpl cl = new ClassDebugInfoImpl(id);
        cl.name = this.strings_table[ClassFileTokens.read(in, 2)];
        cl.access_flags = ClassFileTokens.read(in, 2);
        cl.location = ClassFileTokens.read(in, 2);
        cl.superclass_name = this.strings_table[ClassFileTokens.read(in, 2)];
        cl.source_file = this.strings_table[ClassFileTokens.read(in, 2)];
        cl.interface_count = ClassFileTokens.read(in, 1);
        cl.field_count = ClassFileTokens.read(in, 2);
        cl.method_count = ClassFileTokens.read(in, 2);
        cl.interface_names = new String[cl.interface_count];
        for (i = 0; i < cl.interface_names.length; ++i) {
            cl.interface_names[i] = this.strings_table[ClassFileTokens.read(in, 2)];
        }
        cl.fields = new FieldDebugInfoImpl[cl.field_count];
        for (i = 0; i < cl.field_count; ++i) {
            cl.fields[i] = new FieldDebugInfoImpl(this.strings_table, in);
        }
        cl.methods = new MethodDebugInfoImpl[cl.method_count];
        for (i = 0; i < cl.method_count; ++i) {
            cl.methods[i] = new MethodDebugInfoImpl(cl, i, this.strings_table, in, this.method_component);
        }
        return cl;
    }

    private static int read(InputStream in, int numberOfBytes) throws IOException {
        int retVal = 0;
        for (int i = 0; i < numberOfBytes; ++i) {
            retVal = retVal << 8 | in.read() & 0xFF;
        }
        return retVal;
    }

    public static String readUTF(InputStream in, int length) throws IOException {
        StringBuilder val = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int y;
            char c;
            int x = in.read();
            if (x < 0) {
                throw new IOException("Class is incomplete");
            }
            if (((x &= 0xFF) & 0x80) == 0) {
                c = (char)x;
            } else if ((x & 0xE0) == 192) {
                if (++i >= length) {
                    throw new IOException("Corrupted UTF-8:1");
                }
                y = in.read();
                c = (char)(((x & 0x1F) << 6) + (y & 0x3F));
            } else if ((x & 0xF0) == 224) {
                if (++i >= length) {
                    throw new IOException("Corrupted UTF-8:2");
                }
                y = in.read();
                if (++i >= length) {
                    throw new IOException("Corrupted UTF-8:3");
                }
                int z = in.read();
                c = (char)(((x & 0xF) << 12) + ((y & 0x3F) << 6) + (z & 0x3F));
            } else {
                throw new IOException("Corrupted UTF-8");
            }
            val.append(c);
        }
        return val.toString();
    }

    public static class MethodDebugInfoImpl
    extends MemberDebugInfo
    implements MethodDebugInfo {
        private static final long serialVersionUID = 42L;
        String[] strings_table;
        int location;
        int header_size;
        int body_size;
        int variable_count;
        int line_count;
        VariableInfo[] variable_table;
        LineInfo[] line_table;
        private byte[] methodDescr;
        public ClassDebugInfo parent;
        int index;

        public MethodDebugInfoImpl(ClassDebugInfo parent, int index) {
            this.variable_table = new VariableInfo[0];
            this.line_table = new LineInfo[0];
            this.parent = parent;
            this.index = index;
        }

        public MethodDebugInfoImpl(ClassDebugInfo parent, int index, String name, String descriptor) {
            this.init(name, descriptor, 0);
            this.variable_table = new VariableInfo[0];
            this.line_table = new LineInfo[]{new LineInfo(0, 0, 0xFFFFFF)};
            this.location = 1;
            this.line_count = 1;
            this.parent = parent;
            this.index = index;
        }

        public MethodDebugInfoImpl(ClassDebugInfo parent, int index, String[] strings_table, InputStream in, byte[] methodDescr) throws IOException {
            super(strings_table, in);
            int i;
            this.parent = parent;
            this.index = index;
            this.strings_table = (String[])strings_table.clone();
            this.location = ClassFileTokens.read(in, 2);
            this.header_size = ClassFileTokens.read(in, 1);
            this.body_size = ClassFileTokens.read(in, 2);
            this.variable_count = ClassFileTokens.read(in, 2);
            this.line_count = ClassFileTokens.read(in, 2);
            this.variable_table = new VariableInfo[this.variable_count];
            for (i = 0; i < this.variable_count; ++i) {
                this.variable_table[i] = new VariableInfo(strings_table, in);
            }
            this.methodDescr = (byte[])methodDescr.clone();
            this.line_table = new LineInfo[this.line_count];
            for (i = 0; i < this.line_count; ++i) {
                this.line_table[i] = new LineInfo(in);
            }
        }

        public String printCodeInfo() {
            try {
                StringBuilder retVal = new StringBuilder();
                retVal.append("Method:").append(this).append('\n');
                int start = this.getCodeOffset();
                if (start > 0) {
                    int offset = Math.max(0, start - 4);
                    retVal.append("  ");
                    retVal.append(Utils.canonize(this.methodDescr, offset, start - offset)).append(">>>\n");
                }
                int last = 0;
                for (LineInfo line : this.line_table) {
                    retVal.append("    ").append(line.source_line).append('[').append(line.start_pc).append('-').append(line.end_pc).append(']').append(":");
                    retVal.append(Utils.canonize(this.methodDescr, start + line.start_pc, line.end_pc - line.start_pc + 1)).append('\n');
                    last = line.end_pc;
                }
                if ((long)(++last) < this.getCodeAttributeLength()) {
                    retVal.append("    Undefined:").append(Utils.canonize(this.methodDescr, start + last, (int)(this.getCodeAttributeLength() - (long)last))).append('\n');
                } else if ((long)last > this.getCodeAttributeLength()) {
                    retVal.append("    OUT-OF-METHOD:").append((long)last - this.getCodeAttributeLength());
                }
                int offset = (int)((long)start + this.getCodeAttributeLength());
                if (offset < this.methodDescr.length) {
                    retVal.append("  <<<").append(Utils.canonize(this.methodDescr, offset, Math.min(4, this.methodDescr.length - offset))).append('\n');
                }
                return retVal.toString();
            }
            catch (Exception e) {
                return e.toString();
            }
        }

        public String toString() {
            return this.parent.getClassName() + "." + this.name + this.descriptor + " at " + this.parent.getPackageID() + ":" + this.location;
        }

        @Override
        public List<LocalVariable> getLocalVariables() {
            ArrayList<LocalVariable> list = new ArrayList<LocalVariable>();
            for (VariableInfo var : this.variable_table) {
                list.add(new LocalVariable(var.name, var.descriptor, var.start_pc, var.length, var.index));
            }
            return list;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getSignatureRaw() {
            return this.descriptor;
        }

        @Override
        public int getAccessFlags() {
            return this.access_flags;
        }

        @Override
        public long getCodeAttributeLength() {
            if (this.location == 0) {
                return 0L;
            }
            if (this.line_table.length <= 0) {
                Log.LOG(3, "Warning: --------- " + this.parent.getClassName() + "." + this.name + " line_table empty => return -1 --------- ");
                return -1L;
            }
            return this.line_table[this.line_table.length - 1].end_pc + 1;
        }

        @Override
        public int[][] getBreakableLineNumbers() {
            int[][] lines = new int[this.line_table.length][2];
            for (int i = 0; i < lines.length; ++i) {
                lines[i][0] = this.line_table[i].source_line;
                lines[i][1] = this.line_table[i].start_pc;
            }
            return lines;
        }

        @Override
        public int getArgCount() {
            if ((this.methodDescr[this.location] & 0x80) != 0) {
                return this.methodDescr[this.location + 2];
            }
            return this.methodDescr[this.location + 1] >> 4;
        }

        public byte[] getByteCodes() {
            return new byte[0];
        }

        @Override
        public int getMethodOffset() {
            return this.location;
        }

        @Override
        public int getCodeOffset() {
            if (this.methodDescr == null) {
                return 0;
            }
            boolean isExtended = (this.methodDescr[this.location] & 0x80) != 0;
            return this.location + (isExtended ? 4 : 2);
        }

        @Override
        public int getID() {
            return this.parent.getClassID() << 8 | this.index;
        }

        @Override
        public ClassDebugInfo getParent() {
            return this.parent;
        }
    }

    public static class LineInfo
    implements Serializable {
        private static final long serialVersionUID = 42L;
        int start_pc;
        int end_pc;
        int source_line;

        public LineInfo(InputStream in) throws IOException {
            this.start_pc = ClassFileTokens.read(in, 2);
            this.end_pc = ClassFileTokens.read(in, 2);
            this.source_line = ClassFileTokens.read(in, 2);
        }

        public LineInfo(int lineNumber, int from, int to) {
            this.source_line = lineNumber;
            this.start_pc = from;
            this.end_pc = to;
        }

        public String toString() {
            return "Line:" + this.source_line + " from " + this.start_pc + " to " + this.end_pc;
        }
    }

    public static class VariableInfo
    implements Serializable {
        private static final long serialVersionUID = 42L;
        int index;
        String name;
        String descriptor;
        int start_pc;
        int length;

        public VariableInfo(String[] strings_table, InputStream in) throws IOException {
            this.index = ClassFileTokens.read(in, 1);
            this.name = strings_table[ClassFileTokens.read(in, 2)];
            this.descriptor = strings_table[ClassFileTokens.read(in, 2)];
            this.start_pc = ClassFileTokens.read(in, 2);
            this.length = ClassFileTokens.read(in, 2);
        }
    }

    public static class FieldDebugInfoImpl
    extends MemberDebugInfo
    implements FieldDebugInfo {
        private static final long serialVersionUID = 42L;
        int contents;

        public FieldDebugInfoImpl() {
        }

        public FieldDebugInfoImpl(String[] strings_table, InputStream in) throws IOException {
            super(strings_table, in);
            this.contents = ClassFileTokens.read(in, 4);
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return this.descriptor;
        }

        @Override
        public int getAccessFlags() {
            return this.access_flags;
        }

        @Override
        public int getContents() {
            return this.contents;
        }
    }

    public static class MemberDebugInfo
    implements Serializable {
        private static final long serialVersionUID = 42L;
        public int token;
        protected String name;
        protected String descriptor;
        protected int access_flags;

        public MemberDebugInfo() {
        }

        public MemberDebugInfo(String[] strings_table, InputStream in) throws IOException {
            this.name = strings_table[ClassFileTokens.read(in, 2)];
            this.descriptor = strings_table[ClassFileTokens.read(in, 2)];
            this.access_flags = ClassFileTokens.read(in, 2);
        }

        public void init(String name, String descriptor, int access_flags) {
            this.name = name;
            this.descriptor = descriptor;
            this.access_flags = access_flags;
        }
    }

    public static class ClassDebugInfoImpl
    implements ClassDebugInfo {
        private static final long serialVersionUID = 42L;
        String name;
        int access_flags;
        int location;
        String[] superClasses;
        String superclass_name;
        String source_file;
        int interface_count;
        int field_count;
        int method_count;
        String[] interface_names;
        FieldDebugInfoImpl[] fields;
        MethodDebugInfoImpl[] methods;
        int classId;
        private static final int classStatus = 0;
        short packageId = (short)-1;
        int token;
        public boolean isSyntetic = false;

        public ClassDebugInfoImpl(int id) {
            this.classId = id;
        }

        public static ClassDebugInfoImpl createThird(ClassDebugInfoImpl wanted, ClassDebugInfoImpl unwanted) {
            ClassDebugInfoImpl third = new ClassDebugInfoImpl(unwanted.classId);
            third.access_flags = unwanted.access_flags;
            third.interface_count = unwanted.interface_count;
            third.interface_names = unwanted.interface_names;
            third.isSyntetic = unwanted.isSyntetic;
            third.location = unwanted.location;
            third.name = unwanted.name;
            third.packageId = unwanted.packageId;
            third.source_file = unwanted.source_file;
            third.superClasses = wanted.superClasses;
            third.superclass_name = wanted.superclass_name;
            third.token = unwanted.token;
            third.field_count = wanted.field_count;
            for (FieldDebugInfoImpl thirdField : third.fields = wanted.fields) {
                boolean fieldFound = false;
                for (FieldDebugInfoImpl unwantedField : unwanted.fields) {
                    boolean sameName;
                    boolean sameDescriptor;
                    boolean bl = thirdField.descriptor == null ? unwantedField.descriptor == null : (sameDescriptor = thirdField.descriptor.equals(unwantedField.descriptor));
                    boolean bl2 = thirdField.name == null ? unwantedField.name == null : (sameName = thirdField.name.equals(unwantedField.name));
                    if (!sameDescriptor || !sameName) continue;
                    thirdField = unwantedField;
                    System.out.println("\t" + Modifier.toString(thirdField.getAccessFlags()) + " " + thirdField.getName());
                    fieldFound = true;
                    break;
                }
                if (fieldFound) continue;
                System.out.println("fieldFound: " + fieldFound);
            }
            third.method_count = wanted.method_count;
            third.methods = wanted.methods;
            for (int i = 0; i < third.method_count; ++i) {
                MethodDebugInfoImpl thirdMethod = third.methods[i];
                boolean methodFound = false;
                System.out.println("\t" + Modifier.toString(thirdMethod.getAccessFlags()) + " " + thirdMethod.getName());
                for (MethodDebugInfoImpl unwantedMethod : unwanted.methods) {
                    boolean sameName;
                    boolean sameDescriptor;
                    boolean bl = thirdMethod.descriptor == null ? unwantedMethod.descriptor == null : (sameDescriptor = thirdMethod.descriptor.equals(unwantedMethod.descriptor));
                    boolean bl3 = thirdMethod.name == null ? unwantedMethod.name == null : (sameName = thirdMethod.name.equals(unwantedMethod.name));
                    if (!sameDescriptor || !sameName) continue;
                    System.out.println("\t\tfound: " + Modifier.toString(unwantedMethod.getAccessFlags()) + " " + unwantedMethod.getName());
                    third.methods[i] = unwantedMethod;
                    third.methods[i].index = i;
                    methodFound = true;
                    break;
                }
                if (methodFound) continue;
                System.out.println("methodFound: " + methodFound);
            }
            return third;
        }

        public String toString() {
            return "{" + this.name + " " + Arrays.asList(this.fields) + " " + Arrays.asList(this.methods) + "}";
        }

        @Override
        public String getClassName() {
            return this.name.replace('/', '.');
        }

        @Override
        public String getClassSignature() {
            return "L" + this.name + ";";
        }

        @Override
        public int getRawAccessFlags() {
            return this.access_flags;
        }

        @Override
        public List<FieldDebugInfo> getAllFieldInfo() {
            ArrayList<FieldDebugInfo> retVal = new ArrayList<FieldDebugInfo>();
            retVal.addAll(Arrays.asList(this.fields));
            return retVal;
        }

        @Override
        public int getClassID() {
            return 0xFFFFFF & (this.packageId << 16 | this.classId | 0x8000);
        }

        @Override
        public byte getJDWPTypeTag() {
            if (Modifier.isInterface(this.access_flags)) {
                return 2;
            }
            return 1;
        }

        @Override
        public List<MethodDebugInfo> getAllMethodInfo() {
            ArrayList<MethodDebugInfo> retVal = new ArrayList<MethodDebugInfo>();
            retVal.addAll(Arrays.asList(this.methods));
            return retVal;
        }

        @Override
        public String getSourceFileName() {
            return this.source_file;
        }

        @Override
        public List<String> getAllInterfaces() {
            ArrayList<String> retVal = new ArrayList<String>();
            for (String ind : this.interface_names) {
                retVal.add(ind.replace('/', '.'));
            }
            return retVal;
        }

        @Override
        public MethodDebugInfo getMethodInfoByIndex(int mid) {
            return this.methods[mid & 0xFF];
        }

        @Override
        public FieldDebugInfo getFieldInfoByIndex(long fid) {
            return this.fields[(int)(fid & 0xFFFFL)];
        }

        @Override
        public int getClassStatus() {
            return 0;
        }

        @Override
        public String getSuperClass() {
            if (this.superclass_name == null) {
                return null;
            }
            return this.superclass_name.replace('/', '.');
        }

        @Override
        public void setPackageID(short packageId) {
            this.packageId = packageId;
        }

        @Override
        public short getPackageID() {
            return this.packageId;
        }

        @Override
        public int getLocation() {
            return this.location;
        }

        public void assignSuperClass(VMClassPool pool) {
            if (this.getSuperClass() != null || this.superClasses == null) {
                return;
            }
            for (String current : this.superClasses) {
                Set<String> all = this.findAllSuperClasses(pool, new HashSet<String>(), current);
                if (!this.equals(all, this.superClasses)) continue;
                this.superclass_name = current;
                return;
            }
        }

        private boolean equals(Set<String> set, String ... names) {
            return set.size() == names.length && set.equals(new HashSet<String>(Arrays.asList(names)));
        }

        private Set<String> findAllSuperClasses(VMClassPool pool, Set<String> all, String superClassName) {
            if (superClassName == null) {
                return all;
            }
            all.add(superClassName.replace('.', '/'));
            ClassDebugInfo info = pool.getClassBySignature(VMClassPool.getJNISignature(superClassName));
            if (info instanceof ClassDebugInfoImpl) {
                ClassDebugInfoImpl cl = (ClassDebugInfoImpl)info;
                if (cl.superClasses == null) {
                    Set<String> supersSet = this.findAllSuperClasses(pool, new HashSet<String>(), cl.getSuperClass());
                    cl.superClasses = supersSet.toArray(new String[supersSet.size()]);
                    all.addAll(supersSet);
                } else {
                    all.addAll(Arrays.asList(cl.superClasses));
                }
            } else {
                this.findAllSuperClasses(pool, all, info.getSuperClass());
            }
            return all;
        }
    }
}

