/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.jcdebugproxy.events;

import com.oracle.javacard.jcdebugproxy.events.EventFilter;
import com.oracle.javacard.jcdebugproxy.events.EventHandler;
import com.oracle.javacard.jcdebugproxy.events.OnCardEvent;
import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.ClassicProxyProtocol;
import com.sun.javacard.debugproxy.classic.HandlerState;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Collection;

public class EventHandlerImpl
implements EventHandler {
    public static final String EVENT_FILTERS_KEY = "event-filters";
    private static final String EVENT_FILTER_KEY = "event-filter";
    protected ClassicProxyProtocol proxy;

    @Override
    public void init(ClassicProxyProtocol proxy) {
        this.proxy = proxy;
    }

    @Override
    public ClassicPacketHandler.DeliveryType handleSetEventRequest(EventFilter filter, HandlerState state, DataOutputStream toVM) throws Exception {
        filter.state = EventFilter.State.EnablingInProcess;
        state.args.put(EVENT_FILTER_KEY, filter);
        return ClassicPacketHandler.DeliveryType.NONE;
    }

    @Override
    public void handleSetConfirmation(HandlerState state, DataInputStream fromVM, int length) throws Exception {
        EventFilter filter = (EventFilter)state.args.get(EVENT_FILTER_KEY);
        filter.state = EventFilter.State.Enabled;
    }

    @Override
    public void handleEventFromCard(OnCardEvent event) throws Exception {
    }

    @Override
    public ClassicPacketHandler.DeliveryType handleClearEventRequest(int id, HandlerState state, DataOutputStream toVM) throws Exception {
        return ClassicPacketHandler.DeliveryType.NONE;
    }

    @Override
    public void handleClearConfirmation(HandlerState state, DataInputStream fromVM, int length) throws Exception {
        if (state.receipt == ClassicPacketHandler.DeliveryType.NOT_COMPLETED) {
            return;
        }
        Collection filters = (Collection)state.args.get(EVENT_FILTERS_KEY);
        if (filters != null) {
            for (EventFilter filter : filters) {
                filter.state = EventFilter.State.Disabled;
            }
        }
    }

    @Override
    public void clear() throws Exception {
    }
}

