/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.jcdebugproxy.events;

import com.oracle.javacard.jcdebugproxy.events.EventFilter;
import com.oracle.javacard.jcdebugproxy.events.EventHandlerImpl;
import com.oracle.javacard.jcdebugproxy.events.JDWPEvent;
import com.oracle.javacard.jcdebugproxy.events.OnCardEvent;
import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.HandlerState;
import com.sun.javacard.debugproxy.classic.VmState;
import java.io.DataOutputStream;
import java.util.Collection;
import java.util.LinkedHashMap;

public class MethodExitHandler
extends EventHandlerImpl {
    private final LinkedHashMap<Integer, EventFilter> methodExitRequests = new LinkedHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassicPacketHandler.DeliveryType handleClearEventRequest(int id, HandlerState state, DataOutputStream toVM) throws Exception {
        boolean isEmpty;
        LinkedHashMap<Integer, EventFilter> linkedHashMap = this.methodExitRequests;
        synchronized (linkedHashMap) {
            EventFilter filter = (EventFilter)this.methodExitRequests.remove(id);
            if (filter != null) {
                filter.state = EventFilter.State.Disabled;
            }
            isEmpty = this.methodExitRequests.isEmpty();
        }
        if (isEmpty) {
            toVM.writeByte(4);
            return ClassicPacketHandler.DeliveryType.NORMAL;
        }
        return super.handleClearEventRequest(id, state, toVM);
    }

    @Override
    public void handleEventFromCard(OnCardEvent event) throws Exception {
        Collection<JDWPEvent> reported = JDWPEvent.convertEvent(event, this.methodExitRequests);
        if (reported.isEmpty()) {
            this.proxy.requestVMStateChange(VmState.State.RUNNING);
        }
        this.proxy.sendEventsToIDE((byte)2, reported);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassicPacketHandler.DeliveryType handleSetEventRequest(EventFilter filter, HandlerState state, DataOutputStream toVm) throws Exception {
        boolean wasEmpty;
        LinkedHashMap<Integer, EventFilter> linkedHashMap = this.methodExitRequests;
        synchronized (linkedHashMap) {
            wasEmpty = this.methodExitRequests.isEmpty();
            this.methodExitRequests.put(filter.getID(), filter);
        }
        if (wasEmpty) {
            toVm.writeByte(4);
            toVm.writeShort((short)this.proxy.state().getNextRequestCounter());
            return ClassicPacketHandler.DeliveryType.NORMAL;
        }
        return ClassicPacketHandler.DeliveryType.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassicPacketHandler.DeliveryType clearMethodExit(int id, HandlerState state, DataOutputStream toVm) throws Exception {
        boolean isEmpty;
        LinkedHashMap<Integer, EventFilter> linkedHashMap = this.methodExitRequests;
        synchronized (linkedHashMap) {
            this.methodExitRequests.remove(id);
            isEmpty = this.methodExitRequests.isEmpty();
        }
        if (isEmpty) {
            toVm.writeByte(4);
            toVm.writeShort((short)this.proxy.state().getNextRequestCounter());
            return ClassicPacketHandler.DeliveryType.NORMAL;
        }
        return ClassicPacketHandler.DeliveryType.NONE;
    }

    @Override
    public synchronized void clear() throws Exception {
        super.clear();
        this.methodExitRequests.clear();
    }
}

