/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy;

import com.sun.javacard.debugproxy.classparser.ClassDebugInfo;
import com.sun.javacard.debugproxy.classparser.MethodDebugInfo;
import com.sun.javacard.debugproxy.classparser.VMClassPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PacketEncodingUtils {
    public static MethodDebugInfo resolveMethod(VMClassPool pool, int id, ClassDebugInfo instanceCl) {
        int clID = id >>> 8;
        int index = id & 0xFF;
        ClassDebugInfo cl = pool.getClassByID(clID);
        if (cl == null) {
            throw new IllegalArgumentException("Can not find class for method ID: 0x" + Integer.toHexString(id));
        }
        MethodDebugInfo meth = cl.getMethodInfoByIndex(index);
        int modifiers = meth.getAccessFlags();
        if (PacketEncodingUtils.isStatic(modifiers) || PacketEncodingUtils.isPrivate(modifiers)) {
            return meth;
        }
        if (PacketEncodingUtils.isPackageVisible(modifiers)) {
            instanceCl = PacketEncodingUtils.findFirstFromSamePackage(PacketEncodingUtils.getPackName(cl.getClassName()), pool, instanceCl);
        }
        return PacketEncodingUtils.resolve(pool, instanceCl, meth.getName(), meth.getSignatureRaw());
    }

    public static boolean isStatic(int accessFlags) {
        return (accessFlags & 8) != 0;
    }

    public static boolean isPublic(int accessFlags) {
        return (accessFlags & 1) != 0;
    }

    public static boolean isProtected(int accessFlags) {
        return (accessFlags & 4) != 0;
    }

    public static boolean isPrivate(int accessFlags) {
        return (accessFlags & 2) != 0;
    }

    public static boolean isPackageVisible(int accessFlags) {
        return (accessFlags & 7) == 0;
    }

    public static int[] readIntArray(DataInputStream in) throws IOException {
        int[] retVal = new int[in.readInt()];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = in.readInt();
        }
        return retVal;
    }

    public static byte[] readJCBytetArray(DataInputStream in) throws IOException {
        byte[] retVal = new byte[in.read()];
        if (in.read(retVal) == -1) {
            throw new IOException("Read failed");
        }
        return retVal;
    }

    public static void writeJCBytetArray(DataOutputStream out, byte[] data) throws IOException {
        PacketEncodingUtils.checkThatU1(data.length);
        out.write(data.length);
        out.write(data);
    }

    public static void writeJCInttArray(DataOutputStream out, int[] data) throws IOException {
        PacketEncodingUtils.checkThatU1(data.length);
        out.write(data.length);
        for (int current : data) {
            PacketEncodingUtils.checkThatU1(current);
            out.write(current);
        }
    }

    private static void checkThatU1(int val) {
        int masked = val & 0xFFFFFF00;
        if (masked != 0 && masked != -256) {
            throw new IllegalArgumentException();
        }
    }

    private static String getPackName(String clName) {
        int pos = clName.lastIndexOf(46);
        return pos < 0 ? "" : clName.substring(0, pos);
    }

    private static MethodDebugInfo resolve(VMClassPool pool, ClassDebugInfo cl, String name, String signature) {
        while (cl != null) {
            for (MethodDebugInfo meth : cl.getAllMethodInfo()) {
                if (!meth.getName().equals(name) || !meth.getSignatureRaw().equals(signature)) continue;
                return meth;
            }
            String parent = VMClassPool.getJNISignature(cl.getSuperClass());
            cl = pool.getClassBySignature(parent);
        }
        throw new IllegalArgumentException("Can not resolve method");
    }

    private static ClassDebugInfo findFirstFromSamePackage(String packName, VMClassPool pool, ClassDebugInfo instanceCl) {
        while (!packName.equals(PacketEncodingUtils.getPackName(instanceCl.getClassName()))) {
            String signature = VMClassPool.getJNISignature(instanceCl.getSuperClass());
            instanceCl = pool.getClassBySignature(signature);
        }
        return instanceCl;
    }
}

