/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classic;

import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.ClassicProxyProtocol;
import com.sun.javacard.debugproxy.classic.HandlerState;
import com.sun.javacard.debugproxy.classic.InvalidRequestException;
import com.sun.javacard.debugproxy.classic.ObjectReferenceConverters;
import com.sun.javacard.debugproxy.classic.ReferenceTypeConverters;
import com.sun.javacard.debugproxy.classic.VMPacketHandler;
import com.sun.javacard.debugproxy.classic.handlers.ChainPacketHandler;
import com.sun.javacard.debugproxy.classic.handlers.ClassInfoPacketHandler;
import com.sun.javacard.debugproxy.classic.handlers.ClassicPacketHandlerImpl;
import com.sun.javacard.debugproxy.classparser.ClassDebugInfo;
import com.sun.javacard.debugproxy.classparser.FieldDebugInfo;
import com.sun.javacard.debugproxy.classparser.MethodDebugInfo;
import com.sun.javacard.debugproxy.classparser.VMClassPool;
import com.sun.javacard.debugproxy.comm.EncodingUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class ClassTypeConverters {
    static void registerClassTypeConverters(ClassicProxyProtocol proxy) {
        proxy.addConverter(3, 1, new ClassInfoPacketHandler("SuperClass"){

            @Override
            public void handleClass(DataInputStream fromIde, DataOutputStream toIdePacket, int cid, ClassDebugInfo classFile) throws Exception {
                String superClassName = classFile.getSuperClass();
                if (superClassName == null) {
                    toIdePacket.writeInt(0);
                    return;
                }
                String jniSignature = VMClassPool.getJNISignature(superClassName);
                ClassDebugInfo parent = this.proxy.state().classes().getClassBySignature(jniSignature);
                if (parent == null) {
                    toIdePacket.writeInt(0);
                } else {
                    toIdePacket.writeInt(parent.getClassID());
                }
            }
        });
        proxy.addConverter(3, 2, new ChainPacketHandler(VMPacketHandler.CommandCode.SET_STATIC_FIELD, 50){

            @Override
            protected int startChain(HandlerState state) throws Exception {
                int cid = state.in.readInt();
                ClassDebugInfo cl = this.proxy.state().classes().getClassByID(cid);
                if (cl == null) {
                    throw new InvalidRequestException(21);
                }
                state.args.put("class", cl);
                return EncodingUtils.copyInt(state.in, state.out);
            }

            @Override
            protected void handleChunk(boolean isHead, HandlerState state, DataOutputStream toVm, int chunkSize) throws Exception {
                ClassDebugInfo cl = (ClassDebugInfo)state.args.get("class");
                byte packageID = (byte)cl.getPackageID();
                toVm.writeByte(packageID);
                Log.LOGN(3, "packageID: " + packageID);
                toVm.writeByte((byte)chunkSize);
                for (int field = 0; field < chunkSize; ++field) {
                    long fieldID = state.in.readLong();
                    FieldDebugInfo fieldDebugInfo = this.proxy.state().classes().findFieldInfoByIndex(fieldID);
                    if (fieldDebugInfo == null) {
                        throw new InvalidRequestException(25);
                    }
                    String staticFieldType = fieldDebugInfo.getType();
                    byte typeTag = ReferenceTypeConverters.getTypeTag(staticFieldType);
                    int staticFieldIndex = fieldDebugInfo.getContents();
                    toVm.writeShort((short)staticFieldIndex);
                    Log.LOGN(3, "staticFieldIndex: " + staticFieldIndex);
                    ObjectReferenceConverters.writeTaggedValue(state.in, toVm, typeTag, (short)25);
                }
            }
        });
        proxy.addConverter(3, 3, new ClassicPacketHandlerImpl(VMPacketHandler.CommandCode.INVOKE_METHOD){

            @Override
            public ClassicPacketHandler.DeliveryType handleRequest(HandlerState handlerState, DataOutputStream toVm) throws Exception {
                Log.LOGN(3, "ClassType: InvokeMethod");
                int classID = handlerState.in.readInt();
                handlerState.in.readInt();
                int methodID = handlerState.in.readInt();
                ClassDebugInfo cl = this.proxy.state().classes().getClassByID(classID);
                MethodDebugInfo method = cl.getMethodInfoByIndex(methodID);
                int methodAddr = method.getMethodOffset();
                if (methodAddr == 0) {
                    throw new InvalidRequestException(23);
                }
                toVm.writeByte(ObjectReferenceConverters.getReturnTypeTag(method));
                int numArguments = handlerState.in.readInt();
                toVm.writeByte((byte)numArguments);
                ObjectReferenceConverters.writeArgumentList(handlerState.in, toVm, numArguments);
                handlerState.in.readInt();
                toVm.writeByte((byte)cl.getPackageID());
                toVm.writeShort((short)methodAddr);
                return ClassicPacketHandler.DeliveryType.NORMAL;
            }

            @Override
            public void processResponseData(HandlerState state, DataInputStream fromVm, int length) throws Exception {
                EncodingUtils.copy(fromVm, state.out, length);
            }
        });
        proxy.addConverter(3, 4, new ClassicPacketHandlerImpl(VMPacketHandler.CommandCode.NEW_INSTANCE){

            @Override
            public ClassicPacketHandler.DeliveryType handleRequest(HandlerState handlerState, DataOutputStream toVm) throws Exception {
                Log.LOGN(3, "ClassType: NewInstance");
                int classID = handlerState.in.readInt();
                handlerState.in.readInt();
                int methodID = handlerState.in.readInt();
                ClassDebugInfo cl = this.proxy.state().classes().getClassByID(classID);
                toVm.writeByte((byte)cl.getPackageID());
                toVm.writeShort((short)cl.getLocation());
                MethodDebugInfo method = cl.getMethodInfoByIndex(methodID);
                int methodAddr = method.getMethodOffset();
                if (methodAddr == 0) {
                    throw new InvalidRequestException(23);
                }
                toVm.writeByte(ObjectReferenceConverters.getReturnTypeTag(method));
                int numArguments = handlerState.in.readInt();
                toVm.writeByte((byte)numArguments);
                ObjectReferenceConverters.writeArgumentList(handlerState.in, toVm, numArguments);
                handlerState.in.readInt();
                toVm.writeByte((byte)cl.getPackageID());
                toVm.writeShort((short)methodAddr);
                return ClassicPacketHandler.DeliveryType.NORMAL;
            }

            @Override
            public void processResponseData(HandlerState state, DataInputStream fromVm, int length) throws Exception {
                state.out.writeByte(fromVm.readByte());
                state.out.writeInt(fromVm.readInt());
                fromVm.readByte();
                EncodingUtils.copy(fromVm, state.out, length - 5);
            }
        });
    }
}

