/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classic;

import com.oracle.javacard.jcdebugproxy.ClassFileTokens;
import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.ClassicProxyProtocol;
import com.sun.javacard.debugproxy.classic.HandlerState;
import com.sun.javacard.debugproxy.classic.VMPacketHandler;
import com.sun.javacard.debugproxy.classic.VmState;
import com.sun.javacard.debugproxy.classic.handlers.ChangeStateHandler;
import com.sun.javacard.debugproxy.classic.handlers.ClassAccessHandler;
import com.sun.javacard.debugproxy.classic.handlers.ClassInfoPacketHandler;
import com.sun.javacard.debugproxy.classic.handlers.ClassicPacketHandlerImpl;
import com.sun.javacard.debugproxy.classic.handlers.FixedDataHandler;
import com.sun.javacard.debugproxy.classic.handlers.UnsupportedOperationHandler;
import com.sun.javacard.debugproxy.classparser.ClassDebugInfo;
import com.sun.javacard.debugproxy.classparser.VMClassPool;
import com.sun.javacard.debugproxy.comm.EncodingUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class VirtualMachineConverter {
    VirtualMachineConverter() {
    }

    static void registerConverters(ClassicProxyProtocol proxy, Map<String, ClassFileTokens> map) {
        proxy.addConverter(1, 1, new FixedDataHandler("Version 1.0", 1, 4, "1.0", "Java Card 3 Platform RI"));
        proxy.addConverter(1, 2, new ClassAccessHandler((Map)map){

            @Override
            public ClassicPacketHandler.DeliveryType handleRequest(HandlerState state, DataOutputStream toVm) throws Exception {
                state.args.put("class-signature", EncodingUtils.readString(state.in));
                return super.handleRequest(state, null);
            }

            @Override
            public void processParameters(DataOutputStream toIde, HashMap<String, Object> args) throws Exception {
                String classToMatch = (String)args.get("class-signature");
                ClassDebugInfo classFile = this.proxy.state().classes().getClassBySignature(classToMatch);
                if (classFile == null) {
                    toIde.writeInt(0);
                } else {
                    Log.LOGN(3, "ClassBySig matched " + classFile.getClassName());
                    Log.LOGN(6, "Class Signature: " + classFile.getClassSignature());
                    toIde.writeInt(1);
                    toIde.writeByte(classFile.getJDWPTypeTag());
                    toIde.writeInt(classFile.getClassID());
                    toIde.writeInt(classFile.getClassStatus());
                }
            }
        });
        proxy.addConverter(1, 3, new ClassAccessHandler((Map)map){

            @Override
            public void processParameters(DataOutputStream toIde, HashMap<String, Object> args) throws Exception {
                Collection<ClassDebugInfo> classes = this.proxy.state().classes().getClasses();
                toIde.writeInt(classes.size());
                Log.LOG(3, "handler for [VIRTUALMACHINE_CMDSET, ALL_CLASSES_CMD] classes num:" + classes.size());
                for (ClassDebugInfo classFile : classes) {
                    VMClassPool.writeClass(toIde, classFile);
                }
            }
        });
        proxy.addConverter(1, 4, new FixedDataHandler(1, -31));
        proxy.addConverter(1, 5, new FixedDataHandler(1, -32));
        ClassicPacketHandlerImpl disposer = new ClassicPacketHandlerImpl(VMPacketHandler.CommandCode.NONE){

            @Override
            public ClassicPacketHandler.DeliveryType handleRequest(HandlerState state, DataOutputStream toVm) throws Exception {
                this.proxy.detach();
                return super.handleRequest(state, toVm);
            }
        };
        proxy.addConverter(1, 6, disposer);
        proxy.addConverter(1, 10, disposer);
        proxy.addConverter(1, 7, new FixedDataHandler(8, 4, 4, 4, 4));
        proxy.addConverter(1, 12, new FixedDataHandler(Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE));
        proxy.addConverter(1, 8, new ChangeStateHandler(VmState.State.SUSPENDED));
        proxy.addConverter(1, 9, new ChangeStateHandler(VmState.State.RUNNING));
        proxy.addConverter(11, 3, new ChangeStateHandler(VmState.State.RUNNING));
        proxy.addConverter(11, 2, new ChangeStateHandler(VmState.State.SUSPENDED));
        proxy.addConverter(1, 13, new FixedDataHandler("", 0, 0));
        proxy.addConverter(1, 14, new FixedDataHandler(new Object[0]));
        proxy.addConverter(1, 17, new FixedDataHandler(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false));
        proxy.addConverter(1, 18, new UnsupportedOperationHandler(99));
        proxy.addConverter(1, 19, new UnsupportedOperationHandler(99));
        proxy.addConverter(2, 9, new FixedDataHandler(4));
        proxy.addConverter(2, 1, new ClassInfoPacketHandler("Signature"){

            @Override
            public void handleClass(DataInputStream fromIde, DataOutputStream toIdePacket, int cid, ClassDebugInfo classFile) throws Exception {
                EncodingUtils.writeString(toIdePacket, cid == -32 ? "Lkvm_threadgroup;" : classFile.getClassSignature());
            }
        });
    }
}

