/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classic.handlers;

import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.HandlerState;
import com.sun.javacard.debugproxy.classic.VMPacketHandler;
import com.sun.javacard.debugproxy.classic.handlers.ClassicPacketHandlerImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Map;

public abstract class ChainPacketHandler
extends ClassicPacketHandlerImpl {
    private static final String COUNT_PROPERTY = "handler.counter";
    private static final String TOTAL_COUNT_PROPERTY = "handler.counter.total";
    private static final String CHUNK_SIZE_PROPERTY = "handler.chunk.size";
    private static final String CHUNK_IS_HEAD_PROPERTY = "handler.chunk.is.head";
    protected int limit;

    public ChainPacketHandler(VMPacketHandler.CommandCode code, int limit) {
        super(code);
        this.limit = limit;
    }

    @Override
    public ClassicPacketHandler.DeliveryType handleRequest(HandlerState state, DataOutputStream toVm) throws Exception {
        int counter;
        boolean isAlreadyStarted = ChainPacketHandler.isAlreadyStarted(state.args);
        if (isAlreadyStarted) {
            counter = ChainPacketHandler.getInt(state.args, COUNT_PROPERTY);
        } else {
            counter = this.startChain(state);
            state.args.put(TOTAL_COUNT_PROPERTY, counter);
        }
        int chunkSize = counter <= this.limit ? counter : this.limit;
        this.handleChunk(!isAlreadyStarted, state, toVm, chunkSize);
        state.args.put(COUNT_PROPERTY, counter - chunkSize);
        state.args.put(CHUNK_SIZE_PROPERTY, chunkSize);
        state.args.put(CHUNK_IS_HEAD_PROPERTY, !isAlreadyStarted);
        return counter <= this.limit ? ClassicPacketHandler.DeliveryType.IMMEDIATELY : ClassicPacketHandler.DeliveryType.NOT_COMPLETED;
    }

    @Override
    public void processResponseData(HandlerState state, DataInputStream in, int length) throws Exception {
        this.handleResponseChunk((Boolean)state.args.get(CHUNK_IS_HEAD_PROPERTY), state, ChainPacketHandler.getInt(state.args, CHUNK_SIZE_PROPERTY), in, length);
        if (ChainPacketHandler.getInt(state.args, COUNT_PROPERTY) == 0) {
            this.finishChain(state, ChainPacketHandler.getInt(state.args, TOTAL_COUNT_PROPERTY));
        }
    }

    private static boolean isAlreadyStarted(Map<String, Object> args) {
        return args.containsKey(COUNT_PROPERTY);
    }

    public static int getInt(Map<String, Object> args, String key) {
        Integer val = (Integer)args.get(key);
        return val == null ? 0 : val;
    }

    protected abstract int startChain(HandlerState var1) throws Exception;

    protected abstract void handleChunk(boolean var1, HandlerState var2, DataOutputStream var3, int var4) throws Exception;

    protected void handleResponseChunk(boolean isHead, HandlerState state, int chunkSize, DataInputStream in, int length) throws Exception {
    }

    protected void finishChain(HandlerState state, int totalLength) throws Exception {
    }
}

