/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.comm;

import com.oracle.tee.tools.util.Closables;
import com.sun.javacard.debugproxy.JDWPListener;
import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.comm.CommConnection;
import com.sun.javacard.debugproxy.comm.Packet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;

public final class SocketConnection
implements CommConnection {
    Socket socket;
    DataOutputStream out;
    DataInputStream in;
    JDWPListener proxy;
    Closables manager = new Closables();
    private boolean isRunning = true;

    public SocketConnection(Socket socket) throws IOException {
        this.socket = socket;
        this.manager.add(socket);
        socket.setTcpNoDelay(true);
        this.in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.manager.add(this.in);
        this.out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        this.manager.add(this.out);
    }

    @Override
    public void close() {
        this.manager.flush();
        this.manager.close();
    }

    public byte receiveByte() throws IOException {
        int b = this.in.read();
        return (byte)b;
    }

    public void sendByte(byte b) throws IOException {
        this.out.write(b);
        this.out.flush();
    }

    @Override
    public void stop() {
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setPriority(10);
        try {
            while (this.isRunning) {
                Packet packet = this.receivePacket();
                System.out.println("DB->" + packet.toString());
                this.proxy.packetReceived(packet);
            }
            Log.LOGN(2, "IDE disconnected");
        }
        catch (Exception e) {
            Log.LOGN(2, "IDE disconnected: " + e);
        }
        finally {
            try {
                this.proxy.detached();
            }
            catch (Exception exception) {}
            this.close();
        }
    }

    public Packet receivePacket() throws IOException {
        int count;
        Packet packet = new Packet();
        int b1 = this.in.read();
        int b2 = this.in.read();
        int b3 = this.in.read();
        int b4 = this.in.read();
        if (b1 < 0 || b2 < 0 || b3 < 0 || b4 < 0) {
            throw new EOFException();
        }
        int length = (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
        b1 = this.in.read();
        b2 = this.in.read();
        b3 = this.in.read();
        b4 = this.in.read();
        if (b1 < 0 || b2 < 0 || b3 < 0 || b4 < 0) {
            throw new EOFException();
        }
        packet.id = (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
        packet.flags = (short)this.in.read();
        if (packet.flags < 0) {
            throw new EOFException();
        }
        if (!packet.isReplyPacket()) {
            packet.commandSet = (short)this.in.read();
            packet.command = (short)this.in.read();
            if (packet.commandSet < 0 || packet.command < 0) {
                throw new EOFException();
            }
        } else {
            b1 = this.in.read();
            b2 = this.in.read();
            if (b1 < 0 || b2 < 0) {
                throw new EOFException();
            }
            packet.errorCode = (short)((b1 << 8) + b2);
        }
        if ((length -= 11) < 0) {
            System.err.println("length is " + length);
            System.err.println("Read is " + this.in.read());
        }
        packet.data = new byte[length];
        for (int n = 0; n < packet.data.length; n += count) {
            count = this.in.read(packet.data, n, packet.data.length - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
        return packet;
    }

    @Override
    public synchronized void send(Packet packet) throws IOException {
        int length = packet.data.length + 11;
        System.out.println("DB<-" + packet.toString());
        this.out.write(length >>> 24 & 0xFF);
        this.out.write(length >>> 16 & 0xFF);
        this.out.write(length >>> 8 & 0xFF);
        this.out.write(length & 0xFF);
        this.out.write(packet.id >>> 24 & 0xFF);
        this.out.write(packet.id >>> 16 & 0xFF);
        this.out.write(packet.id >>> 8 & 0xFF);
        this.out.write(packet.id & 0xFF);
        this.out.write(packet.flags);
        if (!packet.isReplyPacket()) {
            this.out.write(packet.commandSet);
            this.out.write(packet.command);
        } else {
            this.out.write(packet.errorCode >>> 8 & 0xFF);
            this.out.write(packet.errorCode & 0xFF);
        }
        this.out.write(packet.data);
        this.out.flush();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void setProxyListener(JDWPListener listener) {
        this.proxy = listener;
    }
}

