/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.types;

import com.sun.javacard.debugproxy.classparser.ClassDebugInfo;
import com.sun.javacard.debugproxy.classparser.MethodDebugInfo;
import com.sun.javacard.debugproxy.types.PacketElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Location
implements PacketElement {
    public ClassDebugInfo cl;
    public MethodDebugInfo meth;
    public int classId;
    public int methodId;
    public long offset;
    public byte typeTag;

    @Override
    public void read(DataInputStream in) throws IOException {
        this.typeTag = in.readByte();
        this.classId = in.readInt();
        this.methodId = in.readInt();
        this.offset = in.readLong();
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeByte(this.typeTag);
        out.writeInt(this.classId);
        out.writeInt(this.methodId);
        out.writeLong(this.offset);
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("at ");
        if (this.cl == null) {
            buff.append("<Unknown Class>").append(this.classId);
        } else {
            buff.append(this.cl.getClassName());
        }
        buff.append(".");
        if (this.meth == null) {
            buff.append("<Unknown Mehod>").append(this.methodId);
        } else {
            buff.append(this.meth.getName()).append(this.meth.getSignatureRaw());
        }
        buff.append(":").append(this.offset);
        return buff.toString();
    }
}

