/*
 * Decompiled with CFR 0.152.
 */
package javacardx.framework.tlv;

import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacardx.framework.tlv.BERTLV;
import javacardx.framework.tlv.BERTag;
import javacardx.framework.tlv.ConstructedBERTag;
import javacardx.framework.tlv.PrimitiveBERTLV;
import javacardx.framework.tlv.TLVException;

public final class ConstructedBERTLV
extends BERTLV {
    private static final short FIND = 1;
    private static final short FIND_NEXT = 2;

    public ConstructedBERTLV(short numTLVs) {
        try {
            this.berTLV = new BERTLV[numTLVs];
        }
        catch (Exception e2) {
            TLVException.throwIt((short)1);
        }
        this.emptyTLV = true;
        this.numDeletedTLVs = 0;
    }

    public short init(byte[] bArray, short bOff, short bLen) throws TLVException {
        boolean thisValueLength = false;
        short totalTLVs = BERTLV.verifyFormatInternal(bArray, bOff, bLen);
        this.sharedBeginInit(bArray, bOff, bLen, totalTLVs);
        if (!BERTag.isConstructed(bArray, bOff)) {
            TLVException.throwIt((short)6);
        }
        if (this.theBERTag != null) {
            JCSystem.requestObjectDeletion();
        }
        this.theBERTag = BERTag.getInstance(bArray, bOff);
        short valueLen = BERTLV.getLength(bArray, bOff);
        short offset = ConstructedBERTLV.getValueOffsetInternal(bArray, bOff);
        return this.sharedEndInit(bArray, bOff, bLen, offset, valueLen, totalTLVs);
    }

    public short init(ConstructedBERTag tag, BERTLV aTLV) throws TLVException {
        if (aTLV.contains(this)) {
            TLVException.throwIt((short)1);
        }
        if (this.theBERTag != null) {
            JCSystem.requestObjectDeletion();
        }
        this.theBERTag = tag;
        if (this.numTLVs > 0) {
            for (short i2 = 0; i2 < (short)(this.numTLVs + this.numDeletedTLVs); i2 = (short)(i2 + 1)) {
                this.berTLV[i2] = null;
            }
            JCSystem.requestObjectDeletion();
        } else {
            this.berTLV = new BERTLV[8];
            JCSystem.requestObjectDeletion();
        }
        this.berTLV[0] = aTLV;
        this.numTLVs = 1;
        this.numDeletedTLVs = 0;
        this.emptyTLV = false;
        return this.size();
    }

    public short init(ConstructedBERTag tag, byte[] vArray, short vOff, short vLen) throws TLVException {
        boolean valueLen = false;
        short totalTLVs = BERTLV.verifyFormatInternal(vArray, vOff, vLen);
        totalTLVs = (short)(totalTLVs + 1);
        if (!tag.isConstructed()) {
            TLVException.throwIt((short)6);
        }
        this.sharedBeginInit(vArray, vOff, vLen, totalTLVs);
        if (this.theBERTag != null) {
            JCSystem.requestObjectDeletion();
        }
        this.theBERTag = tag;
        short offset = vOff;
        return this.sharedEndInit(vArray, vOff, vLen, offset, (short)0, totalTLVs);
    }

    private void sharedBeginInit(byte[] bArray, short bOff, short bLen, short totalTLVs) {
        if (totalTLVs == -1) {
            TLVException.throwIt((short)6);
        } else if (totalTLVs == -2) {
            TLVException.throwIt((short)2);
        } else if (totalTLVs == -3) {
            TLVException.throwIt((short)6);
        }
        if (totalTLVs > this.berTLV.length) {
            this.berTLV = new BERTLV[(short)(totalTLVs + 8)];
            JCSystem.requestObjectDeletion();
        } else if (this.numTLVs > 0) {
            for (short i2 = 0; i2 < (short)(this.numTLVs + this.numDeletedTLVs); i2 = (short)(i2 + 1)) {
                this.berTLV[i2] = null;
            }
            JCSystem.requestObjectDeletion();
        }
    }

    private short sharedEndInit(byte[] bArray, short bOff, short bLen, short offset, short checkValueLen, short totalTLVs) {
        short thisValueLength = 0;
        short TLVValueLength = 0;
        short valueLen = 0;
        if (totalTLVs == 0) {
            this.numTLVs = 0;
            this.numDeletedTLVs = 0;
            this.emptyTLV = false;
            return 0;
        }
        for (short i2 = 0; i2 < totalTLVs; i2 = (short)(i2 + 1)) {
            thisValueLength = (short)(BERTLV.getLength(bArray, offset) + ConstructedBERTLV.getValueOffsetInternal(bArray, offset) - offset);
            if (BERTag.isConstructed(bArray, offset)) {
                this.berTLV[i2] = new ConstructedBERTLV(8);
                this.berTLV[i2].init(bArray, offset, thisValueLength);
            } else {
                TLVValueLength = BERTLV.getLength(bArray, offset);
                this.berTLV[i2] = new PrimitiveBERTLV(TLVValueLength);
                this.berTLV[i2].init(bArray, offset, thisValueLength);
            }
            offset = (short)(offset + thisValueLength);
            valueLen = (short)(valueLen + thisValueLength);
        }
        if (checkValueLen != 0 && checkValueLen != valueLen) {
            TLVException.throwIt((short)6);
        }
        this.numTLVs = totalTLVs;
        this.numDeletedTLVs = 0;
        this.emptyTLV = false;
        return (short)(this.theBERTag.size() + valueLen + BERTLV.getValueLengthSize(valueLen));
    }

    public short append(BERTLV aTLV) throws TLVException {
        short lastTLV = (short)(this.numTLVs + this.numDeletedTLVs);
        if (aTLV.contains(this)) {
            TLVException.throwIt((short)1);
        }
        if ((short)(lastTLV + 1) > this.berTLV.length) {
            BERTLV[] tempTLV = this.berTLV;
            this.berTLV = new BERTLV[(short)(this.berTLV.length + 8)];
            for (short i2 = 0; i2 < this.numTLVs; i2 = (short)(i2 + 1)) {
                this.berTLV[i2] = tempTLV[i2];
            }
            JCSystem.requestObjectDeletion();
        }
        this.berTLV[lastTLV] = aTLV;
        this.numTLVs = (short)(this.numTLVs + 1);
        short valueLen = this.getLength();
        return (short)(valueLen + this.theBERTag.size() + ConstructedBERTLV.getValueLengthSize(valueLen));
    }

    public short delete(BERTLV aTLV, short occurrenceNum) throws TLVException {
        boolean TLVFound = false;
        short lastTLV = (short)(this.numTLVs + this.numDeletedTLVs);
        short occurs = 1;
        if (occurrenceNum <= 0) {
            TLVException.throwIt((short)1);
        }
        for (short i2 = 0; i2 < lastTLV; i2 = (short)(i2 + 1)) {
            if (this.berTLV[i2] == null || !this.berTLV[i2].equals(aTLV)) continue;
            if (occurs == occurrenceNum) {
                this.berTLV[i2] = null;
                this.numDeletedTLVs = (short)(this.numDeletedTLVs + 1);
                this.numTLVs = (short)(this.numTLVs - 1);
                TLVFound = true;
                break;
            }
            occurs = (short)(occurs + 1);
        }
        if (!TLVFound) {
            TLVException.throwIt((short)1);
        }
        JCSystem.requestObjectDeletion();
        short valueLen = this.getLength();
        return (short)(valueLen + this.theBERTag.size() + ConstructedBERTLV.getValueLengthSize(valueLen));
    }

    public BERTLV find(BERTag tag) {
        short lastTLV = (short)(this.numTLVs + this.numDeletedTLVs);
        if (tag == null) {
            return this.berTLV[0];
        }
        for (short i2 = 0; i2 < lastTLV; i2 = (short)(i2 + 1)) {
            if (this.berTLV[i2] == null || !this.berTLV[i2].theBERTag.equals(tag)) continue;
            return this.berTLV[i2];
        }
        return null;
    }

    public BERTLV findNext(BERTag tag, BERTLV aTLV, short occurrenceNum) {
        short lastTLV = (short)(this.numTLVs + this.numDeletedTLVs);
        short occurs = 0;
        if (occurrenceNum <= 0) {
            TLVException.throwIt((short)1);
        }
        for (short i2 = 0; i2 < lastTLV; i2 = (short)(i2 + 1)) {
            if (this.berTLV[i2] == null || !this.berTLV[i2].equals(aTLV) || (occurs = (short)(occurs + 1)) != occurrenceNum) continue;
            for (short j2 = (short)(i2 + 1); j2 < lastTLV; j2 = (short)(j2 + 1)) {
                if (this.berTLV[i2] == null) continue;
                if (tag == null) {
                    return this.berTLV[j2];
                }
                if (!this.berTLV[j2].theBERTag.equals(tag)) continue;
                return this.berTLV[j2];
            }
        }
        if (occurs < occurrenceNum) {
            TLVException.throwIt((short)1);
        }
        return null;
    }

    public static short append(byte[] berTLVInArray, short bTLVInOff, byte[] berTLVOutArray, short bTLVOutOff) throws TLVException {
        short tagSize = 0;
        short sizeOfLength = 0;
        short valueLength = ConstructedBERTLV.getLength(berTLVInArray, bTLVInOff);
        short valueOffset = ConstructedBERTLV.getValueOffsetInternal(berTLVInArray, bTLVInOff);
        short inTLVLength = (short)(valueOffset + valueLength - bTLVInOff);
        if (!BERTLV.verifyFormat(berTLVInArray, bTLVInOff, inTLVLength)) {
            TLVException.throwIt((short)6);
        }
        if (!BERTag.isConstructed(berTLVOutArray, bTLVOutOff)) {
            TLVException.throwIt((short)6);
        }
        if (BERTLV.verifyFormat(berTLVOutArray, bTLVOutOff, (short)((valueOffset = ConstructedBERTLV.getValueOffsetInternal(berTLVOutArray, bTLVOutOff)) + (valueLength = ConstructedBERTLV.getLength(berTLVOutArray, bTLVOutOff)) - bTLVOutOff))) {
            short temp = BERTag.tagNumber(berTLVOutArray, bTLVOutOff);
            tagSize = BERTag.getTagSize(temp);
            short offSet = ConstructedBERTLV.getLengthOffset(berTLVOutArray, bTLVOutOff);
            if ((berTLVOutArray[offSet] & 0xFFFFFF80) != 0) {
                sizeOfLength = (short)(1 + (berTLVOutArray[offSet] & 0x7F));
                if (sizeOfLength == 2) {
                    berTLVOutArray[(short)(offSet + 1)] = (byte)(valueLength + inTLVLength);
                } else {
                    for (short i2 = 1; i2 < (short)(sizeOfLength - 2); i2 = (short)(i2 + 1)) {
                        if (berTLVOutArray[(short)(offSet + i2)] == 0) continue;
                        valueLength = (short)(valueLength + inTLVLength);
                        Util.setShort(berTLVOutArray, (short)(offSet + i2), valueLength);
                    }
                }
            } else {
                berTLVOutArray[offSet] = (byte)(valueLength + inTLVLength);
                sizeOfLength = 1;
            }
            Util.arrayCopy(berTLVInArray, bTLVInOff, berTLVOutArray, (short)(bTLVOutOff + valueLength + tagSize + sizeOfLength), inTLVLength);
            valueLength = (short)(valueLength + (short)(inTLVLength + tagSize + sizeOfLength));
        } else {
            TLVException.throwIt((short)6);
        }
        return valueLength;
    }

    public static short find(byte[] berTLVArray, short bTLVOff, byte[] berTagArray, short bTagOff) throws TLVException {
        return ConstructedBERTLV.findInternal(berTLVArray, bTLVOff, bTLVOff, berTagArray, bTagOff, (short)1);
    }

    public static short findNext(byte[] berTLVArray, short bTLVOff, short startOffset, byte[] berTagArray, short bTagOff) throws TLVException {
        return ConstructedBERTLV.findInternal(berTLVArray, bTLVOff, startOffset, berTagArray, bTagOff, (short)2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static short findInternal(byte[] berTLVArray, short bTLVOff, short startOffset, byte[] berTagArray, short bTagOff, short calledFromMethod) throws TLVException {
        short i2;
        short valueOffset;
        short valueLength;
        block13: {
            block12: {
                block11: {
                    valueLength = ConstructedBERTLV.getLength(berTLVArray, bTLVOff);
                    if (valueLength == 0) {
                        return -1;
                    }
                    valueOffset = ConstructedBERTLV.getValueOffsetInternal(berTLVArray, bTLVOff);
                    if (!BERTLV.verifyFormat(berTLVArray, bTLVOff, (short)(valueOffset + valueLength - bTLVOff))) break block11;
                    if (!BERTag.isConstructed(berTLVArray, bTLVOff)) {
                        TLVException.throwIt((short)6);
                    }
                    if (berTagArray != null && BERTag.verifyFormatInternal(berTagArray, bTagOff) < 0) {
                        TLVException.throwIt((short)5);
                    }
                    i2 = valueOffset;
                    if (startOffset != bTLVOff) break block12;
                    if (calledFromMethod == 2) {
                        TLVException.throwIt((short)1);
                    }
                    break block13;
                }
                TLVException.throwIt((short)6);
                return -1;
            }
            while (i2 < (short)(valueOffset + valueLength) && i2 != startOffset) {
                i2 = (short)(ConstructedBERTLV.getValueOffsetInternal(berTLVArray, i2) + ConstructedBERTLV.getLength(berTLVArray, i2));
            }
            if (i2 == (short)(valueOffset + valueLength)) {
                TLVException.throwIt((short)1);
            }
        }
        if (calledFromMethod == 2) {
            i2 = (short)(ConstructedBERTLV.getValueOffsetInternal(berTLVArray, startOffset) + ConstructedBERTLV.getLength(berTLVArray, startOffset));
        }
        if (berTagArray == null) {
            if (i2 != (short)(valueOffset + valueLength) || calledFromMethod != 2) return i2;
            return -1;
        }
        while (i2 < (short)(valueOffset + valueLength)) {
            if (BERTag.tagNumber(berTagArray, bTagOff) == BERTag.tagNumber(berTLVArray, i2) && BERTag.isConstructed(berTagArray, bTagOff) == BERTag.isConstructed(berTLVArray, i2) && BERTag.tagClass(berTagArray, bTagOff) == BERTag.tagClass(berTLVArray, i2)) {
                return i2;
            }
            i2 = (short)(ConstructedBERTLV.getValueOffsetInternal(berTLVArray, i2) + ConstructedBERTLV.getLength(berTLVArray, i2));
        }
        return -1;
    }
}

