/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.normalizer;

import com.sun.javacard.cli.CommandOption;
import com.sun.javacard.cli.SubCommand;
import com.sun.javacard.components.ClassicCAPFile;
import com.sun.javacard.normalizer.OptionNames;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.Verifier;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.apache.commons.cli.Option;

public class NormalizeCommand
extends SubCommand {
    private File inFile;
    Vector<File> exportFiles;
    boolean keepall = false;
    String keepallDirectory;

    public NormalizeCommand() {
        super("normalize");
    }

    @Override
    public void setup() {
        this.addOption(new CommandOption("i", "in"));
        this.addOption(new CommandOption("p", "exportpath"));
        this.addOption(new CommandOption("f", "exportfile"));
        this.addOption(new CommandOption("o", "out"));
        this.addOption(new CommandOption("k", "keepall"));
    }

    @Override
    public int execute() throws Exception {
        String inFileName = null;
        Vector<String> exportPathNames = new Vector<String>();
        Vector<String> exportFileNames = new Vector<String>();
        String outPath = ".";
        block16: for (Option option : this.optionsArray) {
            switch (OptionNames.valueOf(option.getLongOpt().toUpperCase())) {
                case IN: {
                    inFileName = option.getValue();
                    continue block16;
                }
                case EXPORTPATH: {
                    exportPathNames.addElement(option.getValue());
                    continue block16;
                }
                case EXPORTFILE: {
                    exportFileNames.addElement(option.getValue());
                    continue block16;
                }
                case OUT: {
                    outPath = option.getValue();
                    continue block16;
                }
                case KEEPALL: {
                    this.keepall = true;
                    this.keepallDirectory = option.getValue();
                }
            }
        }
        if (inFileName == null) {
            throw new Exception(this.getResourceString("normalize.error.0"));
        }
        this.inFile = new File(inFileName);
        if (!this.inFile.exists()) {
            throw new Exception(this.getResourceString("normalize.error.0"));
        }
        this.exportFiles = new Vector();
        for (String s : exportPathNames) {
            File folder = new File(s);
            if (!folder.exists()) {
                throw new Exception(this.getFormattedResourceString("normalize.error.3", s));
            }
            if (!folder.isDirectory()) {
                throw new Exception(this.getFormattedResourceString("normalize.error.1", s));
            }
            this.populateExportFiles(this.exportFiles, folder);
        }
        for (String s : exportFileNames) {
            File f = new File(s);
            if (!f.exists()) {
                throw new Exception(this.getResourceString("normalize.error.2"));
            }
            this.exportFiles.addElement(f);
        }
        this.toolsLogger.info(this.getResourceString("normalize.info.0"), new Object[0]);
        ClassicCAPFile capFile = new ClassicCAPFile(this.inFile, this.exportFiles, outPath, this.keepallDirectory);
        if (this.keepall) {
            ZipFile j = null;
            try {
                this.toolsLogger.info(this.getResourceString("normalize.info.5"), new Object[0]);
                FileInputStream fis = new FileInputStream(this.inFile);
                this.toolsLogger.info(this.getResourceString("normalize.info.1"), new Object[0]);
                Verifier.verifyCap(fis, null, this.exportFiles);
                String pkgName = new String(Cap.getPackageDirectory());
                this.toolsLogger.info(this.getResourceString("normalize.info.4"), new Object[0]);
                File finalCAPFile = this.getFinalCAPFile(pkgName, outPath);
                JarEntry je = null;
                j = new JarFile(finalCAPFile);
                Enumeration<JarEntry> e = ((JarFile)j).entries();
                while (e.hasMoreElements()) {
                    je = e.nextElement();
                    if (!je.getName().endsWith(".cap") && !je.getName().endsWith(".class")) continue;
                    byte[] data = new byte[(int)je.getSize()];
                    InputStream is = ((JarFile)j).getInputStream(je);
                    is.read(data);
                    File f = new File(this.keepallDirectory, this.getFileName(je.getName()));
                    File parent = f.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(f);
                    BufferedOutputStream bos = new BufferedOutputStream(fos);
                    DataOutputStream dos = new DataOutputStream(bos);
                    dos.write(data);
                    dos.close();
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (j != null) {
                    try {
                        j.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return 0;
    }

    String getFileName(String name) {
        int startIndex = "APPLET-INF/classes/".length();
        if (name.startsWith("APPLET-INF/classes/")) {
            return name.substring(startIndex);
        }
        return name;
    }

    private File getFinalCAPFile(String pkgName, String outPath) throws Exception {
        char c = File.separatorChar;
        int index = pkgName.lastIndexOf("/");
        String capFileName = pkgName;
        if (index >= 0) {
            capFileName = pkgName.substring(pkgName.lastIndexOf("/"));
        }
        capFileName = outPath + c + pkgName.replace('/', c) + c + "javacard" + c + capFileName + ".cap";
        return new File(capFileName);
    }

    private void populateExportFiles(Vector<File> exportFiles, File f) {
        if (f.isFile()) {
            if (f.getName().endsWith(".exp")) {
                exportFiles.addElement(f);
            }
            return;
        }
        File[] files = f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File p) {
                return p.isDirectory() || p.getName().endsWith(".exp");
            }
        });
        if (files != null) {
            for (File x : files) {
                this.populateExportFiles(exportFiles, x);
            }
        }
    }
}

