/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Type;
import com.sun.javacard.offcardverifier.TypeArray;
import com.sun.javacard.offcardverifier.TypeClass;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.Arrays;
import java.util.Objects;
import java.util.Vector;

public class TypeMethod {
    public Type[] args;
    public Type res;

    public TypeMethod() {
    }

    public TypeMethod(Type tyres) {
        this.args = new Type[0];
        this.res = tyres;
    }

    public TypeMethod(Type tyarg1, Type tyres) {
        this.args = new Type[1];
        this.args[0] = tyarg1;
        this.res = tyres;
    }

    public TypeMethod(Type tyarg1, Type tyarg2, Type tyres) {
        this.args = new Type[2];
        this.args[0] = tyarg1;
        this.args[1] = tyarg2;
        this.res = tyres;
    }

    public TypeMethod(Type tyarg1, Type tyarg2, Type tyarg3, Type tyres) {
        this.args = new Type[3];
        this.args[0] = tyarg1;
        this.args[1] = tyarg2;
        this.args[2] = tyarg3;
        this.res = tyres;
    }

    public int argumentsWordSize() {
        return this.args.length;
    }

    public static TypeMethod parseCap(Safeptr typtr) {
        int i;
        Vector<Type> tyvec = new Vector<Type>(4);
        int nibbleCount = typtr.u1(0);
        Safeptr p = typtr.offset(1);
        Type ty = null;
        block13: for (i = 0; i < nibbleCount; ++i) {
            if (ty != null) {
                tyvec.add(ty);
                if (ty.equals(Type.Int)) {
                    tyvec.add(Type.Int2);
                }
                ty = null;
            }
            switch (p.nibble(i)) {
                case 1: {
                    ty = Type.Void;
                    continue block13;
                }
                case 2: {
                    ty = Type.Boolean;
                    continue block13;
                }
                case 3: {
                    ty = Type.Byte;
                    continue block13;
                }
                case 4: {
                    ty = Type.Short;
                    continue block13;
                }
                case 5: {
                    ty = Type.Int;
                    continue block13;
                }
                case 6: {
                    int cref = p.nibble(i + 1) << 12 | p.nibble(i + 2) << 8 | p.nibble(i + 3) << 4 | p.nibble(i + 4);
                    Classref.check(cref);
                    ty = new TypeClass(cref);
                    i += 4;
                    continue block13;
                }
                case 10: {
                    ty = Type.BooleanArray;
                    continue block13;
                }
                case 11: {
                    ty = Type.ByteArray;
                    continue block13;
                }
                case 12: {
                    ty = Type.ShortArray;
                    continue block13;
                }
                case 13: {
                    ty = Type.IntArray;
                    continue block13;
                }
                case 14: {
                    int cref = p.nibble(i + 1) << 12 | p.nibble(i + 2) << 8 | p.nibble(i + 3) << 4 | p.nibble(i + 4);
                    Classref.check(cref);
                    ty = new TypeArray(new TypeClass(cref));
                    i += 4;
                    continue block13;
                }
                default: {
                    throw new VerifierError("TypeMethod.1", p.nibble(i), (Object)typtr);
                }
            }
        }
        if (i > nibbleCount) {
            throw new VerifierError("TypeMethod.2", typtr);
        }
        if (ty == null) {
            throw new VerifierError("TypeMethod.3", typtr);
        }
        TypeMethod mty = new TypeMethod();
        mty.res = ty;
        mty.args = new Type[tyvec.size()];
        for (i = 0; i < mty.args.length; ++i) {
            mty.args[i] = (Type)tyvec.elementAt(i);
            if (mty.args[i].equals(Type.Void)) {
                throw new VerifierError("TypeMethod.4", typtr);
            }
            if (!mty.args[i].equals(Type.Int) && !mty.args[i].equals(Type.IntArray)) continue;
            Cap.Header.useInts();
        }
        return mty;
    }

    public static TypeMethod parseExport(String sig) {
        int i;
        Vector<Type> tyvec = new Vector<Type>(4);
        Type ty = null;
        block17: for (i = 0; i < sig.length(); ++i) {
            if (ty != null) {
                tyvec.add(ty);
                if (ty.equals(Type.Int)) {
                    tyvec.add(Type.Int2);
                }
                ty = null;
            }
            switch (sig.charAt(i)) {
                case 'B': {
                    ty = Type.Byte;
                    continue block17;
                }
                case 'I': {
                    ty = Type.Int;
                    continue block17;
                }
                case 'L': {
                    int j = sig.indexOf(59, i + 1);
                    if (j == -1) {
                        throw new VerifierError("TypeMethod.5", sig);
                    }
                    int cref = Classref.refForName(sig.substring(i + 1, j));
                    ty = new TypeClass(cref);
                    i = j;
                    continue block17;
                }
                case 'S': {
                    ty = Type.Short;
                    continue block17;
                }
                case 'Z': {
                    ty = Type.Boolean;
                    continue block17;
                }
                case '[': {
                    int cref;
                    int j;
                    switch (sig.charAt(++i)) {
                        case 'B': {
                            ty = Type.ByteArray;
                            continue block17;
                        }
                        case 'I': {
                            ty = Type.IntArray;
                            continue block17;
                        }
                        case 'L': {
                            j = sig.indexOf(59, i + 1);
                            if (j == -1) {
                                throw new VerifierError("TypeMethod.6", sig);
                            }
                            cref = Classref.refForName(sig.substring(i + 1, j));
                            ty = new TypeArray(new TypeClass(cref));
                            i = j;
                            continue block17;
                        }
                        case 'S': {
                            ty = Type.ShortArray;
                            continue block17;
                        }
                        case 'Z': {
                            ty = Type.BooleanArray;
                            continue block17;
                        }
                    }
                    throw new VerifierError("TypeMethod.7", (Object)sig.substring(i, i + 1), (Object)sig);
                }
                case 'V': {
                    ty = Type.Void;
                    continue block17;
                }
                case '(': 
                case ')': {
                    continue block17;
                }
                default: {
                    throw new VerifierError("TypeMethod.8", (Object)sig.substring(i, i + 1), (Object)sig);
                }
            }
        }
        if (ty == null) {
            throw new VerifierError("TypeMethod.9", sig);
        }
        TypeMethod mty = new TypeMethod();
        mty.res = ty;
        mty.args = new Type[tyvec.size()];
        for (i = 0; i < mty.args.length; ++i) {
            mty.args[i] = (Type)tyvec.elementAt(i);
            if (!mty.args[i].equals(Type.Void)) continue;
            throw new VerifierError("TypeMethod.10", sig);
        }
        return mty;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TypeMethod)) {
            return false;
        }
        TypeMethod mty = (TypeMethod)obj;
        if (mty.args.length != this.args.length) {
            return false;
        }
        for (int i = 0; i < this.args.length; ++i) {
            if (mty.args[i].equals(this.args[i])) continue;
            return false;
        }
        return mty.res.equals(this.res);
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Arrays.deepHashCode(this.args);
        hash = 37 * hash + Objects.hashCode(this.res);
        return hash;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.res.toString());
        sb.append('(');
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.args[i].toString());
        }
        sb.append(')');
        return sb.toString();
    }
}

