/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.util.Diagnostics;
import com.sun.javacard.util.FileUtils;
import com.sun.javacard.validator.Bundle;
import com.sun.javacard.validator.ClassicLibrary;
import com.sun.javacard.validator.ClassicModule;
import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.ExtendedModule;
import com.sun.javacard.validator.ExtensionLibrary;
import com.sun.javacard.validator.WebModule;
import java.io.File;
import java.util.Vector;

public class Validator {
    private static File workDir = null;
    public static final int TYPE_WEB_APP = 10;
    public static final int TYPE_EXTENDED_APPLET_APP = 11;
    public static final int TYPE_CLASSIC_APPLET_APP = 12;
    public static final int TYPE_EXTENSION_LIBRARY = 1;
    public static final int TYPE_CLASSIC_LIBRARY = 0;
    private int moduleType;
    private Bundle bundle;
    private static Vector<File> exportFiles;

    public Diagnostics validate(String bundlePath, int type, File workDirectory) {
        if (!new File(bundlePath).isDirectory() && workDirectory == null) {
            this.createWorkDir();
        } else {
            workDir = workDirectory;
        }
        this.moduleType = type;
        this.bundle = new Bundle();
        switch (type) {
            case 10: {
                this.bundle.addItem(new WebModule(bundlePath));
                break;
            }
            case 11: {
                this.bundle.addItem(new ExtendedModule(bundlePath));
                break;
            }
            case 12: {
                ClassicModule cm = new ClassicModule(bundlePath);
                cm.setExportFiles(exportFiles);
                this.bundle.addItem(cm);
                break;
            }
            case 1: {
                this.bundle.addItem(new ExtensionLibrary(bundlePath));
                break;
            }
            case 0: {
                ClassicLibrary cl = new ClassicLibrary(bundlePath);
                cl.setExportFiles(exportFiles);
                this.bundle.addItem(cl);
            }
        }
        this.bundle.initialize();
        this.bundle.process();
        Diagnostics diagnostics = new Diagnostics();
        diagnostics.ok = this.bundle.isOk(true);
        this.bundle.gatherDiagnostics(diagnostics);
        if (workDir != null) {
            FileUtils.deleteDir(workDir);
        }
        return diagnostics;
    }

    public static File getWorkDir() {
        return workDir;
    }

    public int getModuleType() {
        return this.moduleType;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setExportFiles(Vector<File> exportFiles) {
        Validator.exportFiles = exportFiles;
    }

    private void createWorkDir() {
        workDir = new File(System.getProperty("java.io.tmpdir") + "packager_temp_root_" + System.currentTimeMillis()).getAbsoluteFile();
        if (!workDir.mkdirs()) {
            System.out.println(ErrorKey.UnableToCreateWorkingFolder.getMessage(workDir));
            System.exit(1);
        }
    }
}

