/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.stringproc;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javacardx.annotations.StringDef;
import javacardx.annotations.StringPool;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"javacardx.annotations.StringPool", "javacardx.annotations.StringDef"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class StringConstantsProcessor
extends AbstractProcessor {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".messages");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.OTHER, StringConstantsProcessor.getCopyrightBanner());
        Types types = this.processingEnv.getTypeUtils();
        boolean onError = false;
        for (Element element : roundEnv.getElementsAnnotatedWith(StringPool.class)) {
            String msg = MessageFormat.format(this.resourceBundle.getString("annotations.processing"), element.getSimpleName());
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
            String poolName = element.getAnnotation(StringPool.class).name();
            if (!poolName.equals("") && !this.isJavaIdentifier(poolName)) {
                msg = MessageFormat.format(this.resourceBundle.getString("name.malformed"), poolName);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element);
                onError = true;
                continue;
            }
            String encoding = "UTF-8";
            boolean export = element.getAnnotation(StringPool.class).export();
            String poolClassQName = poolName.equals("") ? ((TypeElement)element).getQualifiedName() + "$$Strings" : ((PackageElement)element.getEnclosingElement()).getQualifiedName() + "." + poolName;
            String poolClassName = poolName.equals("") ? ((TypeElement)element).getSimpleName() + "$$Strings" : poolName;
            HashSet<String> names = new HashSet<String>();
            HashMap<String, String> imports = new HashMap<String, String>();
            StringDef[] values = element.getAnnotation(StringPool.class).value();
            int seq = 0;
            for (int i = 0; i < values.length; ++i) {
                String name = values[i].name();
                if (name.equals("") || !this.isJavaIdentifier(name)) {
                    msg = MessageFormat.format(this.resourceBundle.getString("name.malformed"), name, element);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
                    onError = true;
                    continue;
                }
                if (names.contains(name)) {
                    msg = MessageFormat.format(this.resourceBundle.getString("name.duplicate"), name, element);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
                    onError = true;
                    continue;
                }
                names.add(name);
                String reference = values[i].reference();
                if (reference.equals("")) continue;
                if (!this.isQualifiedJavaIdentifier(reference)) {
                    msg = MessageFormat.format(this.resourceBundle.getString("reference.malformed"), reference);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
                    onError = true;
                    continue;
                }
                String value = values[i].value();
                if (!value.equals("")) {
                    msg = MessageFormat.format(this.resourceBundle.getString("reference.unexpected"), reference, value);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
                    onError = true;
                    continue;
                }
                String[] components = this.getComponents(reference);
                if (components == null) {
                    msg = MessageFormat.format(this.resourceBundle.getString("reference.malformed"), reference);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
                    onError = true;
                    continue;
                }
                if (imports.containsKey(components[0])) continue;
                imports.put(components[0], "__x" + seq++);
            }
            if (onError) {
                msg = MessageFormat.format(this.resourceBundle.getString("annotations.error"), element.getSimpleName());
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
                return false;
            }
            try {
                JavaFileObject f = this.processingEnv.getFiler().createSourceFile(poolClassQName, new Element[0]);
                msg = MessageFormat.format(this.resourceBundle.getString("class.creating"), f.toUri());
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
                Writer w = f.openWriter();
                PrintWriter pw = new PrintWriter(w);
                try {
                    String value;
                    String name;
                    String reference;
                    int i;
                    pw.println("package " + ((PackageElement)element.getEnclosingElement()).getQualifiedName() + ";");
                    pw.println();
                    if (!export) {
                        pw.println("final class " + poolClassName + " {");
                    } else {
                        pw.println("public final class " + poolClassName + " {");
                    }
                    if (!imports.isEmpty()) {
                        for (Map.Entry entry : imports.entrySet()) {
                            pw.println("    private static " + (String)entry.getKey() + " " + (String)entry.getValue() + ";");
                        }
                    }
                    pw.println();
                    if (!export) {
                        StringDef[] values2 = element.getAnnotation(StringPool.class).value();
                        for (i = 0; i < values2.length; ++i) {
                            reference = values2[i].reference();
                            name = values2[i].name();
                            value = values2[i].value();
                            if (!reference.equals("")) {
                                pw.println("    static byte[] " + name + ";");
                                continue;
                            }
                            pw.println("    static final byte[] " + name + " = new byte[] " + this.PrintByteArrayInit(value, encoding) + ";");
                        }
                        pw.println();
                        if (!imports.isEmpty()) {
                            pw.println("    static void importLibConstants() {");
                            if (!imports.isEmpty()) {
                                for (Map.Entry entry : imports.entrySet()) {
                                    pw.println("        " + (String)entry.getValue() + " = new " + (String)entry.getKey() + "();");
                                }
                            }
                            for (i = 0; i < values2.length; ++i) {
                                String[] components;
                                reference = values2[i].reference();
                                name = values2[i].name();
                                value = values2[i].value();
                                if (reference.equals("") || (components = this.getComponents(reference)) == null) continue;
                                String instanceName = (String)imports.get(components[0]);
                                pw.println("        " + name + " = " + instanceName + "." + components[1] + ";");
                            }
                            pw.println("    }");
                        }
                    } else {
                        StringDef[] values2 = element.getAnnotation(StringPool.class).value();
                        for (int i2 = 0; i2 < values2.length; ++i2) {
                            reference = values2[i2].reference();
                            name = values2[i2].name();
                            value = values2[i2].value();
                            if (!reference.equals("")) {
                                pw.println("    public byte[] " + name + ";");
                                continue;
                            }
                            pw.println("    public final byte[] " + name + " = new byte[] " + this.PrintByteArrayInit(value, encoding) + ";");
                        }
                        pw.println();
                        pw.println("    public " + poolClassName + "() {");
                        if (!imports.isEmpty()) {
                            for (Map.Entry entry : imports.entrySet()) {
                                pw.println("        " + (String)entry.getValue() + " = new " + (String)entry.getKey() + "();");
                            }
                        }
                        for (i = 0; i < values2.length; ++i) {
                            String[] components;
                            reference = values2[i].reference();
                            name = values2[i].name();
                            if (reference.equals("") || (components = this.getComponents(reference)) == null) continue;
                            String instanceName = (String)imports.get(components[0]);
                            pw.println("        " + name + " = " + instanceName + "." + components[1] + ";");
                        }
                        pw.println("    }");
                    }
                    pw.println("}");
                    pw.flush();
                }
                finally {
                    pw.close();
                    w.close();
                }
            }
            catch (IOException x) {
                msg = MessageFormat.format(this.resourceBundle.getString("io.error"), x.toString());
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
            }
        }
        return true;
    }

    private String PrintByteArrayInit(String name, String encoding) throws UnsupportedEncodingException {
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        for (byte b : name.getBytes(encoding)) {
            if (b < 0) {
                buf.append("(byte)");
            }
            buf.append("0x").append(Integer.toString(b & 0xFF, 16));
            buf.append(", ");
        }
        buf.append('}');
        return buf.toString();
    }

    private String[] getComponents(String qName) {
        int i = qName.lastIndexOf(46);
        if (i >= 0) {
            return new String[]{qName.substring(0, i), qName.substring(i + 1)};
        }
        return null;
    }

    private boolean isJavaIdentifier(String name) {
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isQualifiedJavaIdentifier(String name) {
        int i = 0;
        block0: while (i < name.length()) {
            if (!Character.isJavaIdentifierStart(name.charAt(i++))) {
                return false;
            }
            while (i < name.length()) {
                if (name.charAt(i) == '.') {
                    if (i + 1 < name.length()) {
                        ++i;
                        continue block0;
                    }
                    return false;
                }
                if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static String getCopyrightBanner() {
        return "    Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.\n    \n    ";
    }
}

