/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile.instructions;

import com.sun.javacard.classfile.constants.JConstantInterfaceMethodRef;
import com.sun.javacard.classfile.constants.JConstantPool;
import com.sun.javacard.classfile.instructions.JInstrMethodRef;
import java.io.DataInputStream;
import java.io.IOException;

public class JInstrInterfaceRef
extends JInstrMethodRef {
    private int num_of_args;

    public JInstrInterfaceRef(JConstantPool cp, int pc, int opcode) {
        super(cp, pc, opcode);
    }

    @Override
    public int getSizeInBytes() {
        return 5;
    }

    public int getNumOfArgs() {
        return this.num_of_args;
    }

    @Override
    public void parse(DataInputStream dis) throws IOException {
        super.parse(dis);
        this.num_of_args = dis.readUnsignedByte();
        if (0 != dis.readByte()) {
            throw new ClassFormatError();
        }
    }

    @Override
    public void resolve() {
        JConstantInterfaceMethodRef const_interface_methodref = this.cp.getConstantInterfaceMethodRef(this.cp_index);
        this.constant_ref = const_interface_methodref;
        if (const_interface_methodref == null) {
            throw new ClassFormatError();
        }
        this.class_name = const_interface_methodref.getClassName();
        this.method_name = const_interface_methodref.getMethodName();
        this.descriptor = const_interface_methodref.getDescriptor();
    }
}

