/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.Util;
import java.io.ByteArrayOutputStream;

public class AttributeInfo {
    short nameIndex;
    int length;
    byte[] value;

    public void setNameIndex(short nameIndex) {
        this.nameIndex = nameIndex;
    }

    public void setValue(int valueLength, byte[] valueBytes) {
        this.length = valueLength;
        this.value = new byte[this.length];
        System.arraycopy(valueBytes, 0, this.value, 0, this.length);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AttributeInfo)) {
            return false;
        }
        AttributeInfo otherAttr = (AttributeInfo)obj;
        if (this.length != otherAttr.length) {
            return false;
        }
        return Util.compareByteArrays(this.value, otherAttr.value);
    }

    void write(ByteArrayOutputStream bos) {
        byte[] buff = Util.getShortBytes(this.nameIndex);
        bos.write(buff, 0, buff.length);
        byte[] lengthBytes = Util.getIntBytes(this.length);
        bos.write(lengthBytes, 0, 4);
        bos.write(this.value, 0, this.length);
    }

    public void print(String str) {
        byte[] buff = Util.getShortBytes(this.nameIndex);
        Util.printArray(str + "\tAttribute name index: ", buff, buff.length);
        byte[] lengthBytes = Util.getIntBytes(this.length);
        Util.printArray(str + "\tAttribute Length (" + this.length + "): ", lengthBytes, 4);
        Util.printArray(str + "\tAttribute Info bytes: ", this.value, this.length);
    }
}

