/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.AttributeInfo;
import com.sun.javacard.components.caputils.CAPUtil;
import com.sun.javacard.components.caputils.ClassConstantPool;
import com.sun.javacard.components.caputils.Util;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ConstantPoolEntry;
import com.sun.javacard.offcardverifier.ExnHandlerInfo;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import java.io.ByteArrayOutputStream;
import java.util.Vector;

public class ExceptionsAttribute
extends AttributeInfo {
    private ClassConstantPool constantPool;
    private static final String attributeName = "Exceptions";
    private short attributeNameIndex = (short)-1;
    private MethodDescriptor md;
    Vector<Short> exceptionIndexTable;

    public ExceptionsAttribute(ClassConstantPool cp, MethodDescriptor md) {
        this.constantPool = cp;
        this.md = md;
        this.exceptionIndexTable = new Vector();
        this.attributeNameIndex = (short)this.constantPool.addConstantUtf8Info(attributeName);
        this.setNameIndex(this.attributeNameIndex);
        this.createtExceptionsList();
    }

    private void createtExceptionsList() {
        int codeStartOffset = this.md.methodOffset();
        int byteCodeCount = this.md.bytecodeCount();
        int codeEndOffset = codeStartOffset + this.md.bytecodeCount();
        int numExcHandlers = Cap.Method.handlerCount();
        for (int i = 0; i < numExcHandlers; ++i) {
            ExnHandlerInfo exnHandler = Cap.Method.exceptionHandler(i);
            int handlerStartOffset = exnHandler.startOffset();
            int handlerEndOffset = exnHandler.endOffset();
            if (handlerStartOffset < codeStartOffset || handlerStartOffset >= codeEndOffset || handlerEndOffset >= codeEndOffset) continue;
            String refName = null;
            int handlerType = exnHandler.catchType();
            ConstantPoolEntry entry = Cap.ConstantPool.entry(handlerType);
            int classRef = entry.classRef();
            refName = CAPUtil.getRefName(classRef);
            short exnClassRef = this.constantPool.getClassRefIndex(refName);
            this.exceptionIndexTable.add(new Short(exnClassRef));
            this.length += 2;
        }
    }

    public int getExceptionsCount() {
        return this.exceptionIndexTable.size();
    }

    @Override
    public boolean equals(Object otherAttr) {
        if (!(otherAttr instanceof ExceptionsAttribute)) {
            return false;
        }
        if (this.length != ((ExceptionsAttribute)otherAttr).length) {
            return false;
        }
        return this.exceptionIndexTable.equals(((ExceptionsAttribute)otherAttr).exceptionIndexTable);
    }

    @Override
    void write(ByteArrayOutputStream bos) {
        byte[] buff = Util.getShortBytes(this.attributeNameIndex);
        bos.write(buff, 0, buff.length);
        byte[] lengthBytes = Util.getIntBytes(this.length);
        bos.write(lengthBytes, 0, 4);
        int numExceptions = this.exceptionIndexTable.size();
        byte[] numExceptionsBytes = Util.getShortBytes((short)numExceptions);
        bos.write(numExceptionsBytes, 0, 2);
        for (int i = 0; i < numExceptions; ++i) {
            Short exnRefIndex = this.exceptionIndexTable.elementAt(i);
            byte[] exnRefIndexBytes = Util.getShortBytes(exnRefIndex);
            bos.write(exnRefIndexBytes, 0, 2);
        }
    }

    @Override
    public void print(String str) {
        byte[] buff = Util.getShortBytes(this.nameIndex);
        Util.printArray(str + "\tAttribute name index: ", buff, buff.length);
        byte[] lengthBytes = Util.getIntBytes(this.length);
        Util.printArray(str + "\tAttribute Length (" + this.length + "): ", lengthBytes, 4);
        int numExceptions = this.exceptionIndexTable.size();
        byte[] numExceptionsBytes = Util.getShortBytes((short)numExceptions);
        Util.printArray(str + "\tNumber of exceptions: ", numExceptionsBytes, numExceptionsBytes.length);
        System.out.println(str + "\tException Ref List");
        for (int i = 0; i < numExceptions; ++i) {
            Short exnRefIndex = this.exceptionIndexTable.elementAt(i);
            byte[] exnRefIndexBytes = Util.getShortBytes(exnRefIndex);
            Util.printArray(str + "\t", exnRefIndexBytes, 2);
        }
    }
}

