/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.cap.TypeDescriptorEntry;
import java.util.Vector;

public class SignaturePool {
    JCPackage parentPackage;
    public Vector<TypeDescriptorEntry> methodSignaturePool;
    public int relocAddress;

    public SignaturePool(JCPackage p) {
        this.parentPackage = p;
    }

    public short addMethodToSignaturePool(String methodNameDescr, JCClass parentClass) {
        TypeDescriptorEntry desc = new TypeDescriptorEntry(methodNameDescr, parentClass);
        int index = this.methodSignaturePool.indexOf(desc);
        if (index == -1) {
            this.methodSignaturePool.addElement(desc);
        }
        return this.getMethodSignatureOffset(desc);
    }

    public short getMethodSignatureOffset(TypeDescriptorEntry desc) {
        short addressOffset = 0;
        int index = this.methodSignaturePool.indexOf(desc);
        for (int i = 0; i < index; ++i) {
            desc = this.methodSignaturePool.elementAt(i);
            addressOffset = (short)(addressOffset + (short)desc.getData().length);
        }
        return addressOffset;
    }

    public short getMethodSignatureOffset(JCMethod m) {
        assert (m != null) : "method != null";
        TypeDescriptorEntry desc = new TypeDescriptorEntry(m, 0);
        return this.getMethodSignatureOffset(desc);
    }

    public void relocate(int address) {
        this.relocAddress = address;
    }

    public int getAddressForOffset(int offset) {
        return this.relocAddress + offset;
    }

    public int getSize() {
        int size = 0;
        byte[] data = null;
        for (int i = 0; i < this.methodSignaturePool.size(); ++i) {
            TypeDescriptorEntry desc = this.methodSignaturePool.elementAt(i);
            data = desc.getData();
            size += data.length;
        }
        return size;
    }
}

