/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AppletComponent;
import com.sun.javacard.offcardverifier.ClassComponent;
import com.sun.javacard.offcardverifier.ConstantPoolComponent;
import com.sun.javacard.offcardverifier.DebugComponent;
import com.sun.javacard.offcardverifier.DescriptorComponent;
import com.sun.javacard.offcardverifier.DirectoryComponent;
import com.sun.javacard.offcardverifier.ExportComponent;
import com.sun.javacard.offcardverifier.HeaderComponent;
import com.sun.javacard.offcardverifier.ImportComponent;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.MethodComponent;
import com.sun.javacard.offcardverifier.RefLocComponent;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.StaticFieldComponent;
import com.sun.javacard.offcardverifier.TypeDescriptor;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class Cap {
    static final short COMPONENT_COUNT_2_1 = 11;
    static final short COMPONENT_COUNT_2_2 = 12;
    static final int DEBUG_2_1_TAG = 219;
    static final int DEBUG_2_2_TAG = 12;
    public static HeaderComponent Header;
    static DirectoryComponent Directory;
    public static AppletComponent Applet;
    public static ImportComponent Import;
    public static ConstantPoolComponent ConstantPool;
    public static ClassComponent Class;
    public static MethodComponent Method;
    public static StaticFieldComponent StaticField;
    public static RefLocComponent ReferenceLocation;
    public static ExportComponent Export;
    public static DescriptorComponent Descriptor;
    public static DebugComponent Debug;
    static byte[] debugComponentDataBuffer;
    static int debugComponentTag;
    public static TypeDescriptor TypeDescr;
    static int capMinorVersion;
    public static final int ACC_INT = 1;
    public static final int ACC_EXPORT = 2;
    public static final int ACC_APPLET = 4;
    public static final int ACC_INTERFACE = 8;
    public static final int ACC_SHAREABLE = 4;
    public static final int ACC_EXTENDED = 8;
    public static final int ACC_ABSTRACT = 4;
    public static final int ACC_REMOTE = 2;
    public static final int CF_ACC_PUBLIC = 1;
    public static final int CF_ACC_FINAL = 16;
    public static final int CF_ACC_INTERFACE = 64;
    public static final int CF_ACC_ABSTRACT = 128;
    public static final int CF_ACC_REMOTE = 32;
    public static final int FF_ACC_PUBLIC = 1;
    public static final int FF_ACC_PRIVATE = 2;
    public static final int FF_ACC_PROTECTED = 4;
    public static final int FF_ACC_STATIC = 8;
    public static final int FF_ACC_FINAL = 16;
    public static final int MF_ACC_PUBLIC = 1;
    public static final int MF_ACC_PRIVATE = 2;
    public static final int MF_ACC_PROTECTED = 4;
    public static final int MF_ACC_STATIC = 8;
    public static final int MF_ACC_FINAL = 16;
    public static final int MF_ACC_ABSTRACT = 64;
    public static final int MF_ACC_INIT = 128;
    public static final int CONSTANT_Classref = 1;
    public static final int CONSTANT_InstanceFieldref = 2;
    public static final int CONSTANT_VirtualMethodref = 3;
    public static final int CONSTANT_SuperMethodref = 4;
    public static final int CONSTANT_StaticFieldref = 5;
    public static final int CONSTANT_StaticMethodref = 6;
    public static final int CONSTANT_PrivateMethodref = 7;
    public static final int TypeVoid = 1;
    public static final int TypeBoolean = 2;
    public static final int TypeByte = 3;
    public static final int TypeShort = 4;
    public static final int TypeInt = 5;
    public static final int TypeObjectref = 6;
    public static final int TypeBoolarray = 10;
    public static final int TypeBytearray = 11;
    public static final int TypeShortarray = 12;
    public static final int TypeIntarray = 13;
    public static final int TypeObjectrefarray = 14;
    static final int FieldtypeBoolean = 32770;
    static final int FieldtypeByte = 32771;
    static final int FieldtypeShort = 32772;
    static final int FieldtypeInt = 32773;
    public static final int ArrayInitBoolean = 2;
    public static final int ArrayInitByte = 3;
    public static final int ArrayInitShort = 4;
    public static final int ArrayInitInt = 5;
    private static String[] componentNames;
    private static Hashtable<Integer, Safeptr> customComponents;
    public static String packageDirectory;

    private static void doRead(InputStream is, String name, byte[] data, int numBytes) throws IOException {
        int r;
        for (int pos = 0; pos < numBytes; pos += r) {
            r = is.read(data, pos, numBytes - pos);
            if (r != -1) continue;
            throw new VerifierError("Cap.1", name);
        }
    }

    private static void readOneComponent(InputStream is, String name, int expectedTag) throws IOException {
        byte[] header = new byte[3];
        Cap.doRead(is, name, header, 3);
        int tag = header[0] & 0xFF;
        int size = (header[1] & 0xFF) << 8 | header[2] & 0xFF;
        if (tag != 219 && tag != 12) {
            if (expectedTag != 0 && tag != expectedTag) {
                throw new VerifierError("Cap.17", (Object)name, tag, expectedTag);
            }
            if (expectedTag == 0 && tag < 128) {
                throw new VerifierError("Cap.18", (Object)name, tag);
            }
        }
        byte[] data = new byte[size];
        Cap.doRead(is, name, data, size);
        if (is.read(header, 0, 1) != -1) {
            throw new VerifierError("Cap.2", name);
        }
        Object old = null;
        switch (tag) {
            case 1: {
                old = Header;
                Header = new HeaderComponent(data);
                break;
            }
            case 2: {
                old = Directory;
                Directory = new DirectoryComponent(data);
                break;
            }
            case 3: {
                old = Applet;
                Applet = new AppletComponent(data);
                break;
            }
            case 4: {
                old = Import;
                Import = new ImportComponent(data);
                break;
            }
            case 5: {
                old = ConstantPool;
                ConstantPool = new ConstantPoolComponent(data);
                break;
            }
            case 6: {
                old = Class;
                Class = new ClassComponent(data);
                break;
            }
            case 7: {
                old = Method;
                Method = new MethodComponent(data);
                break;
            }
            case 8: {
                old = StaticField;
                StaticField = new StaticFieldComponent(data);
                break;
            }
            case 9: {
                old = ReferenceLocation;
                ReferenceLocation = new RefLocComponent(data);
                break;
            }
            case 10: {
                old = Export;
                Export = new ExportComponent(data);
                break;
            }
            case 11: {
                old = Descriptor;
                Descriptor = new DescriptorComponent(data);
                break;
            }
            case 12: 
            case 219: {
                old = debugComponentDataBuffer;
                debugComponentDataBuffer = data;
                debugComponentTag = tag;
                break;
            }
            default: {
                Safeptr ptr = new Safeptr(data, "Custom#" + tag);
                old = customComponents.put(new Integer(tag), ptr);
            }
        }
        if (old != null) {
            throw new VerifierError("Cap.4", tag);
        }
    }

    static void readComponents(File capfile) {
        try {
            JarEntry je;
            Header = null;
            Directory = null;
            Applet = null;
            Import = null;
            ConstantPool = null;
            Class = null;
            Method = null;
            StaticField = null;
            ReferenceLocation = null;
            Export = null;
            Descriptor = null;
            Debug = null;
            TypeDescr = null;
            customComponents = new Hashtable(7);
            packageDirectory = Verifier.packageName == null ? null : Verifier.packageName.replace('.', '/');
            FileInputStream fs = new FileInputStream(capfile);
            JarInputStream js = new JarInputStream(fs);
            while ((je = js.getNextJarEntry()) != null) {
                int tag;
                int lastslash;
                int penultimateslash;
                String name = je.getName();
                if (name.length() < 4 || !name.substring(name.length() - 4).equalsIgnoreCase(".cap") || (penultimateslash = name.lastIndexOf(47, (lastslash = name.lastIndexOf(47)) - 1)) == -1 || !name.substring(penultimateslash + 1, lastslash).equalsIgnoreCase("javacard")) continue;
                String filename = name.substring(lastslash + 1);
                String pkgname = name.substring(0, penultimateslash);
                if (packageDirectory == null) {
                    packageDirectory = pkgname;
                    if (Verifier.verbose >= 2) {
                        Messages.println("Cap.21", packageDirectory.replace('/', '.'), (Object)capfile);
                    }
                } else if (!pkgname.equals(packageDirectory)) {
                    VerifierError.warning("Cap.16", name, packageDirectory.replace('/', '.'));
                    continue;
                }
                for (tag = 1; tag <= componentNames.length - 1 && !filename.equalsIgnoreCase(componentNames[tag]); ++tag) {
                }
                if (tag <= 12) {
                    Cap.readOneComponent(js, name, tag);
                    continue;
                }
                try {
                    Cap.readOneComponent(js, name, 0);
                }
                catch (IOException exn) {
                    throw new VerifierError("Cap.19", name);
                }
                catch (VerifierError exn) {
                    throw new VerifierError("Cap.20", (Object)name, (Object)exn.getMessage());
                }
            }
            fs.close();
            if (Header == null) {
                throw new VerifierError("Cap.5");
            }
            if (Directory == null) {
                throw new VerifierError("Cap.6");
            }
            if (ConstantPool == null) {
                throw new VerifierError("Cap.7");
            }
            if (Class == null) {
                throw new VerifierError("Cap.8");
            }
            if (Method == null) {
                throw new VerifierError("Cap.9");
            }
            if (StaticField == null) {
                throw new VerifierError("Cap.10");
            }
            if (ReferenceLocation == null) {
                throw new VerifierError("Cap.11");
            }
            if (Descriptor == null) {
                throw new VerifierError("Cap.12");
            }
        }
        catch (FileNotFoundException exn) {
            throw new VerifierError("Cap.14", capfile);
        }
        catch (IOException exn) {
            throw new VerifierError("Cap.13", (Object)capfile.getPath(), (Object)exn.toString());
        }
        catch (VerifierError exn) {
            throw new VerifierError("Cap.13", (Object)capfile.getPath(), (Object)exn.getMessage());
        }
    }

    public static void readComponents(FileInputStream fs) {
        try {
            JarEntry je;
            Header = null;
            Directory = null;
            Applet = null;
            Import = null;
            ConstantPool = null;
            Class = null;
            Method = null;
            StaticField = null;
            ReferenceLocation = null;
            Export = null;
            Descriptor = null;
            Debug = null;
            TypeDescr = null;
            customComponents = new Hashtable(7);
            packageDirectory = Verifier.packageName == null ? null : Verifier.packageName.replace('.', '/');
            JarInputStream js = new JarInputStream(fs);
            while ((je = js.getNextJarEntry()) != null) {
                int tag;
                int lastslash;
                int penultimateslash;
                String name = je.getName();
                if (name.length() < 4 || !name.substring(name.length() - 4).equalsIgnoreCase(".cap") || (penultimateslash = name.lastIndexOf(47, (lastslash = name.lastIndexOf(47)) - 1)) == -1 || !name.substring(penultimateslash + 1, lastslash).equalsIgnoreCase("javacard")) continue;
                String filename = name.substring(lastslash + 1);
                String pkgname = name.substring(0, penultimateslash);
                if (packageDirectory == null) {
                    packageDirectory = pkgname;
                    if (Verifier.verbose >= 2) {
                        Messages.println("Cap.21", packageDirectory.replace('/', '.'));
                    }
                } else if (!pkgname.equals(packageDirectory) && Verifier.packageName == null) {
                    VerifierError.warning("Cap.16", name, packageDirectory.replace('/', '.'));
                    continue;
                }
                for (tag = 1; tag <= componentNames.length - 1 && !filename.equalsIgnoreCase(componentNames[tag]); ++tag) {
                }
                if (tag <= 12) {
                    Cap.readOneComponent(js, name, tag);
                    continue;
                }
                try {
                    Cap.readOneComponent(js, name, 0);
                }
                catch (IOException exn) {
                    throw new VerifierError("Cap.19", name);
                }
                catch (VerifierError exn) {
                    throw new VerifierError("Cap.20", (Object)name, (Object)exn.getMessage());
                }
            }
            fs.close();
            if (Header == null) {
                throw new VerifierError("Cap.5");
            }
            if (Directory == null) {
                throw new VerifierError("Cap.6");
            }
            if (ConstantPool == null) {
                throw new VerifierError("Cap.7");
            }
            if (Class == null) {
                throw new VerifierError("Cap.8");
            }
            if (Method == null) {
                throw new VerifierError("Cap.9");
            }
            if (StaticField == null) {
                throw new VerifierError("Cap.10");
            }
            if (ReferenceLocation == null) {
                throw new VerifierError("Cap.11");
            }
            if (Descriptor == null) {
                throw new VerifierError("Cap.12");
            }
        }
        catch (FileNotFoundException exn) {
            throw new VerifierError("Cap.23");
        }
        catch (IOException exn) {
            throw new VerifierError("Cap.24");
        }
        catch (VerifierError exn) {
            throw new VerifierError("Cap.24");
        }
    }

    static void addCustomComponent(byte[] data, int tag) {
        Safeptr ptr = new Safeptr(data, "Custom#" + tag);
        Safeptr old = customComponents.put(new Integer(tag), ptr);
        if (old != null) {
            throw new VerifierError("Cap.4", tag);
        }
    }

    static Safeptr customComponent(int tag) {
        return customComponents.get(new Integer(tag));
    }

    static {
        capMinorVersion = 0;
        componentNames = new String[]{null, "Header.cap", "Directory.cap", "Applet.cap", "Import.cap", "ConstantPool.cap", "Class.cap", "Method.cap", "StaticField.cap", "RefLocation.cap", "Export.cap", "Descriptor.cap", "Debug.cap"};
    }
}

