/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.validator.Classes;
import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.Module;
import com.sun.javacard.validator.WebXML;
import java.io.File;

public class WebModule
extends Module {
    private WebXML webXML;

    public WebModule(String path) {
        super(path);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.isOk()) {
            return;
        }
        String infFolder = "WEB-INF";
        File webXMLFile = new File(this.folder, "WEB-INF/web.xml");
        if (webXMLFile.exists()) {
            this.webXML = new WebXML(webXMLFile);
            this.addItem(this.webXML);
            this.webXML.initialize();
        } else {
            this.addError(ErrorKey.WebXmlFileDoesNotExists, new Object[0]);
        }
        File classesFolder = new File(this.folder, infFolder + "/classes");
        if (!classesFolder.exists()) {
            classesFolder = null;
        }
        this.classes = new Classes(classesFolder);
        this.addItem(this.classes);
        this.classes.initialize();
        File webInfLibFolder = new File(this.folder, infFolder + "/lib");
        if (webInfLibFolder.exists()) {
            this.addWarning(ErrorKey.WebInfLibFolderIsIgnored, webInfLibFolder.getAbsolutePath());
        }
    }

    @Override
    public void processInternal() {
        super.processInternal();
        if (!this.isOk()) {
            return;
        }
        this.webXML.process();
    }

    public WebXML getWebXML() {
        return this.webXML;
    }
}

