/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.i18n.j2me;

import com.sun.cldc.i18n.StreamReader;
import com.sun.javacard.impl.NativeMethods;
import java.io.IOException;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class UTF8_Reader
extends StreamReader {
    private static boolean SUB_MODE = true;
    private static char SUB_CHAR = (char)65533;
    private static int BBUF_LEN = 128;
    private int charOff;
    private int byteOff;
    private int badInputLength;
    private int savedSize = 0;
    private byte[] savedBytes = new byte[5];
    private int savedChar = -1;

    @Override
    public synchronized int read() throws IOException {
        if (this.in == null) {
            throw new IOException("ISO8859_1_Reader: input stream is null");
        }
        char[] c = new char[1];
        int count = this.read(c, 0, 1);
        return count == 1 ? c[0] : -1;
    }

    @Override
    public synchronized int read(char[] cbuf, int off, int len) throws IOException {
        int bbuflen = len > BBUF_LEN ? BBUF_LEN : len;
        byte[] bbuf = new byte[bbuflen];
        NativeMethods.setGloballyAccessible(bbuf);
        int count = 0;
        int remaining = len;
        if (this.savedChar != -1) {
            cbuf[off] = (char)this.savedChar;
            this.savedChar = -1;
            ++count;
            --remaining;
        }
        while (count < len) {
            int nbytes = (len - count) / 3;
            if (nbytes > bbuflen) {
                nbytes = bbuflen;
            }
            if (nbytes == 0) {
                nbytes = 1;
            }
            if (this.in == null) {
                throw new IOException("UTF8_Reader: input stream is null");
            }
            if ((nbytes = this.in.read(bbuf, 0, nbytes)) == -1) {
                if (this.savedSize != 0) {
                    throw new IOException("UTF8_Reader: Malformed UTF-8 input.");
                }
                return count == 0 ? -1 : count;
            }
            int n = this.convert(bbuf, 0, nbytes, cbuf, off, len);
            count += n;
            off += n;
            remaining -= n;
        }
        return len;
    }

    @Override
    public int sizeOf(byte[] array, int offset, int length) {
        return length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int convert(byte[] input, int inOff, int inEnd, char[] output, int outOff, int outEnd) throws IOException {
        int i;
        char[] outputChar = new char[2];
        int byteOffAdjustment = 0;
        if (!SUB_MODE && this.badInputLength != 0) {
            this.byteOff += this.badInputLength;
            this.badInputLength = 0;
        }
        if (this.savedSize != 0) {
            byte[] newBuf = new byte[inEnd - inOff + this.savedSize];
            for (i = 0; i < this.savedSize; ++i) {
                newBuf[i] = this.savedBytes[i];
            }
            System.arraycopy(input, inOff, newBuf, this.savedSize, inEnd - inOff);
            input = newBuf;
            inOff = 0;
            inEnd = newBuf.length;
            byteOffAdjustment = -this.savedSize;
            this.savedSize = 0;
        }
        this.charOff = outOff;
        this.byteOff = inOff;
        while (this.byteOff < inEnd) {
            int byte3;
            int byte2;
            int outputSize;
            int byte1;
            int startByteOff = this.byteOff;
            if (((byte1 = input[this.byteOff++] & 0xFF) & 0x80) == 0) {
                outputChar[0] = (char)byte1;
                outputSize = 1;
            } else if ((byte1 & 0xE0) == 192) {
                if (this.byteOff >= inEnd) {
                    this.savedSize = 1;
                    this.savedBytes[0] = (byte)byte1;
                    break;
                }
                if (((byte2 = input[this.byteOff++] & 0xFF) & 0xC0) != 128) {
                    this.badInputLength = 2;
                    this.byteOff += byteOffAdjustment;
                    if (!SUB_MODE) throw new IOException("UTF8_Reader: Malformed UTF-8 input.");
                    outputChar[0] = SUB_CHAR;
                    outputSize = 1;
                    this.byteOff += this.badInputLength;
                    this.badInputLength = 0;
                } else {
                    outputChar[0] = (char)((byte1 & 0x1F) << 6 | byte2 & 0x3F);
                    outputSize = 1;
                }
            } else if ((byte1 & 0xF0) == 224) {
                if (this.byteOff + 1 >= inEnd) {
                    this.savedBytes[0] = (byte)byte1;
                    if (this.byteOff >= inEnd) {
                        this.savedSize = 1;
                        break;
                    }
                    this.savedSize = 2;
                    this.savedBytes[1] = input[this.byteOff++];
                    break;
                }
                byte2 = input[this.byteOff++] & 0xFF;
                byte3 = input[this.byteOff++] & 0xFF;
                if ((byte2 & 0xC0) != 128 || (byte3 & 0xC0) != 128) {
                    this.badInputLength = 3;
                    this.byteOff += byteOffAdjustment;
                    if (!SUB_MODE) throw new IOException("UTF8_Reader: Malformed UTF-8 input.");
                    outputChar[0] = SUB_CHAR;
                    outputSize = 1;
                    this.byteOff += this.badInputLength;
                    this.badInputLength = 0;
                } else {
                    outputChar[0] = (char)((byte1 & 0xF) << 12 | (byte2 & 0x3F) << 6 | byte3 & 0x3F);
                    outputSize = 1;
                }
            } else if ((byte1 & 0xF8) == 240) {
                if (this.byteOff + 2 >= inEnd) {
                    this.savedBytes[0] = (byte)byte1;
                    if (this.byteOff >= inEnd) {
                        this.savedSize = 1;
                        break;
                    }
                    if (this.byteOff + 1 >= inEnd) {
                        this.savedSize = 2;
                        this.savedBytes[1] = input[this.byteOff++];
                        break;
                    }
                    this.savedSize = 3;
                    this.savedBytes[1] = input[this.byteOff++];
                    this.savedBytes[2] = input[this.byteOff++];
                    break;
                }
                byte2 = input[this.byteOff++] & 0xFF;
                byte3 = input[this.byteOff++] & 0xFF;
                int byte4 = input[this.byteOff++] & 0xFF;
                if ((byte2 & 0xC0) != 128 || (byte3 & 0xC0) != 128 || (byte4 & 0xC0) != 128) {
                    this.badInputLength = 4;
                    this.byteOff += byteOffAdjustment;
                    if (!SUB_MODE) throw new IOException("UTF8_Reader: Malformed UTF-8 input.");
                    outputChar[0] = SUB_CHAR;
                    outputSize = 1;
                    this.byteOff += this.badInputLength;
                    this.badInputLength = 0;
                } else {
                    int ucs4 = (7 & byte1) << 18 | (0x3F & byte2) << 12 | (0x3F & byte3) << 6 | 0x3F & byte4;
                    outputChar[0] = (char)((ucs4 - 65536) / 1024 + 55296);
                    outputChar[1] = (char)((ucs4 - 65536) % 1024 + 56320);
                    this.savedChar = outputChar[1];
                    outputSize = 2;
                }
            } else {
                this.badInputLength = 1;
                this.byteOff += byteOffAdjustment;
                if (!SUB_MODE) throw new IOException("UTF8_Reader: Malformed UTF-8 input.");
                outputChar[0] = SUB_CHAR;
                outputSize = 1;
                this.byteOff += this.badInputLength;
                this.badInputLength = 0;
            }
            if (this.charOff + outputSize > outEnd) {
                if (this.charOff + outputSize != outEnd + 1 || this.savedChar == -1) {
                    this.byteOff = startByteOff;
                    this.byteOff += byteOffAdjustment;
                    throw new IOException("UTF8_Reader: Conversion buffer full.");
                }
                --outputSize;
            } else {
                this.savedChar = -1;
            }
            for (i = 0; i < outputSize; ++i) {
                output[this.charOff + i] = outputChar[i];
            }
            this.charOff += outputSize;
        }
        this.byteOff += byteOffAdjustment;
        return this.charOff - outOff;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.charOff = 0;
        this.byteOff = 0;
        this.savedSize = 0;
        this.savedChar = -1;
    }
}

