/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class ResourceInputStream
extends InputStream {
    private Object handle;
    private int pos;
    private int size;

    private static String fixResourceName(String name) throws IOException {
        Vector<String> dirVector = new Vector<String>();
        int startIdx = 0;
        int endIdx = 0;
        while ((endIdx = name.indexOf(47, startIdx)) != -1) {
            if (endIdx == startIdx) {
                ++startIdx;
                continue;
            }
            String curDir = name.substring(startIdx, endIdx);
            startIdx = endIdx + 1;
            if (curDir.equals(".")) continue;
            if (curDir.equals("..")) {
                try {
                    dirVector.removeElementAt(dirVector.size() - 1);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    throw new IOException();
                }
            }
            dirVector.addElement(curDir);
        }
        StringBuffer dirName = new StringBuffer();
        int nelements = dirVector.size();
        for (int i = 0; i < nelements; ++i) {
            dirName.append((String)dirVector.elementAt(i));
            dirName.append("/");
        }
        if (startIdx < name.length()) {
            String filename = name.substring(startIdx);
            if (filename.endsWith(".class") && !".class".equals(filename)) {
                throw new IOException();
            }
            dirName.append(name.substring(startIdx));
        }
        return dirName.toString();
    }

    public ResourceInputStream(String name) throws IOException {
        String fixedName = ResourceInputStream.fixResourceName(name);
        this.handle = ResourceInputStream.open(fixedName);
        if (this.handle == null) {
            throw new IOException();
        }
        this.size = ResourceInputStream.size(this.handle);
        this.pos = 0;
    }

    @Override
    public int read() throws IOException {
        int result = ResourceInputStream.read(this.handle);
        if (result != -1) {
            ++this.pos;
        }
        return result;
    }

    @Override
    public synchronized void close() throws IOException {
        ResourceInputStream.close(this.handle);
        this.handle = null;
    }

    @Override
    public int available() {
        return this.size - this.pos;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.size) {
            return -1;
        }
        if (this.pos + len > this.size) {
            len = this.size - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        int readLength = ResourceInputStream.readBytes(this.handle, b, off, this.pos, len);
        if (readLength != -1) {
            this.pos += readLength;
        }
        return readLength;
    }

    private static native Object open(String var0) throws IOException;

    private static native void close(Object var0) throws IOException;

    private static native int size(Object var0) throws IOException;

    private static native int read(Object var0) throws IOException;

    private static native int readBytes(Object var0, byte[] var1, int var2, int var3, int var4) throws IOException;
}

