/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.CadEvent;
import com.sun.javacard.apduio.CadServerListener;
import com.sun.javacard.apduio.CadT0;
import com.sun.javacard.apduio.T0ServerClosed;
import com.sun.javacard.apduio.T0ServerOpen;
import com.sun.javacard.apduio.T0ServerState;
import com.sun.javacard.apduio.TLP224Exception;
import com.sun.javacard.apduio.TLP224Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public final class ServerT0Protocol {
    TLP224Message tlp224Msg;
    CadT0 cad;
    private T0ServerState state;
    private Vector<CadServerListener> listeners = new Vector();

    public ServerT0Protocol(InputStream in, OutputStream out) {
        this.cad = new CadT0(in, out);
        this.tlp224Msg = new TLP224Message();
        this.state = T0ServerClosed.instance();
    }

    void changeState(T0ServerState newState) {
        this.state = newState;
        Vector<CadServerListener> v = this.listeners;
        for (int i = 0; i < v.size(); ++i) {
            if (this.state instanceof T0ServerClosed) {
                v.elementAt(i).powerDown(new CadEvent(this));
                continue;
            }
            if (!(this.state instanceof T0ServerOpen)) continue;
            v.elementAt(i).powerUp(new CadEvent(this));
        }
    }

    public void addCadServerListener(CadServerListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeCadServerListener(CadServerListener listener) {
        this.listeners.removeElement(listener);
    }

    public byte t0RcvCommand(byte[] command) {
        try {
            return (byte)this.state.t0RcvCommand(this, command);
        }
        catch (TLP224Exception e) {
            return 1;
        }
        catch (IOException e) {
            return 1;
        }
    }

    public byte t0SndStatusRcvCommand(byte[] command, short sw1sw2) {
        try {
            return (byte)this.state.t0SndStatusRcvCommand(this, command, sw1sw2);
        }
        catch (TLP224Exception e) {
            return 1;
        }
        catch (IOException e) {
            return 1;
        }
    }

    public byte t0RcvData(byte[] buffer, short offset, short count, byte procByte) {
        try {
            return (byte)this.state.t0RcvData(this, buffer, offset, count, procByte);
        }
        catch (TLP224Exception e) {
            return 1;
        }
        catch (IOException e) {
            return 1;
        }
    }

    public byte t0SndData(byte[] buffer, short offset, short count, byte procByte) {
        try {
            return (byte)this.state.t0SndData(this, buffer, offset, count, procByte);
        }
        catch (TLP224Exception e) {
            return 1;
        }
        catch (IOException e) {
            return 1;
        }
    }

    public byte t0SndData(byte[] buffer, short offset, short count) {
        try {
            return (byte)this.state.t0SndData(this, buffer, offset, count);
        }
        catch (TLP224Exception e) {
            return 1;
        }
        catch (IOException e) {
            return 1;
        }
    }

    public void sendATR(byte[] atr) throws IOException, TLP224Exception {
        this.state.sendATR(this, atr);
    }
}

