/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.CadEvent;
import com.sun.javacard.apduio.CadServerListener;
import com.sun.javacard.apduio.CadT1;
import com.sun.javacard.apduio.T1Block;
import com.sun.javacard.apduio.T1Exception;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class ServerT1Protocol {
    CadT1 cad;
    private Vector<CadServerListener> listeners = new Vector();
    protected boolean numSeq = false;
    protected boolean numSeqTx = true;
    protected boolean numSeqRcv = true;
    protected T1Block nextIBlock = null;
    protected int nextBlockDataOffset = 0;
    protected T1Block blockOutgoing;
    protected T1Block blockIncoming;
    protected boolean lastBlockFlag = false;
    int sizeINF;
    private int sizeIFSD;
    private int sizeIFSC;
    private boolean recvFirstBlock = true;
    private static final int T1SERVER_STATE_CLOSED = 0;
    private static final int T1SERVER_STATE_OPEN = 1;
    private static final int T1SERVER_STATE_ACTIVE = 2;
    private int serverState = 0;

    public ServerT1Protocol(InputStream in, OutputStream out) {
        this.cad = new CadT1(in, out);
        this.sizeIFSC = 32;
        this.sizeIFSD = 32;
        this.blockOutgoing = new T1Block();
        this.blockIncoming = new T1Block();
    }

    public void addCadServerListener(CadServerListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeCadServerListener(CadServerListener listener) {
        this.listeners.removeElement(listener);
    }

    private void notifyPowerDown() {
        Vector<CadServerListener> v = this.listeners;
        for (int i = 0; i < v.size(); ++i) {
            v.elementAt(i).powerDown(new CadEvent(this));
        }
    }

    private void placeDataInBuffer(byte[] bufferINF, short[] LEN, short offset, short buffSize) {
        boolean discardingData = bufferINF == null;
        byte[] data = this.nextIBlock.getINFBytes();
        int dataLen = this.nextIBlock.getLEN() - this.nextBlockDataOffset;
        if (dataLen + offset > buffSize) {
            int maxSize = buffSize - offset;
            if (!discardingData) {
                System.arraycopy(data, this.nextBlockDataOffset, bufferINF, offset, maxSize);
            }
            LEN[0] = (short)maxSize;
            this.nextBlockDataOffset += maxSize;
            this.lastBlockFlag = false;
        } else {
            if (!discardingData) {
                System.arraycopy(data, this.nextBlockDataOffset, bufferINF, offset, dataLen);
            }
            LEN[0] = (short)dataLen;
            this.lastBlockFlag = this.nextIBlock.isLastBlock();
            if (!discardingData) {
                this.nextIBlock = null;
                this.nextBlockDataOffset = 0;
            }
        }
    }

    private short t1ReplySBlock(boolean[] retransmit) throws T1Exception, IOException {
        byte sbType = this.blockIncoming.getSBlockType();
        switch (sbType) {
            case -64: 
            case -63: {
                throw new T1Exception(-125);
            }
            case -61: {
                throw new T1Exception(-124);
            }
            case -62: {
                boolean retransmitSBlock = true;
                while (retransmitSBlock) {
                    boolean seqBlock;
                    byte incomingBlockType;
                    this.blockOutgoing.setSBlock((byte)0, (byte)0, -30, 0);
                    boolean result = this.cad.exchangeBlock(this.blockOutgoing, this.blockIncoming);
                    if (!result) {
                        this.notifyPowerDown();
                    }
                    if ((incomingBlockType = this.blockIncoming.getBlockType()) == 0) {
                        seqBlock = this.blockIncoming.getSequence();
                        if (seqBlock != this.numSeqRcv) {
                            this.numSeqRcv = seqBlock;
                            this.nextIBlock = this.blockIncoming;
                            retransmit[0] = false;
                            retransmitSBlock = false;
                            continue;
                        }
                        throw new T1Exception(-126);
                    }
                    if (incomingBlockType == -128) {
                        seqBlock = this.blockIncoming.getSequence();
                        if (seqBlock != this.numSeqTx) {
                            retransmit[0] = true;
                            continue;
                        }
                        throw new T1Exception(-124);
                    }
                    throw new T1Exception(-126);
                }
                break;
            }
            default: {
                throw new T1Exception(-124);
            }
        }
        return 0;
    }

    public short t1SndBlockRcvAck(byte[] buffer, int dataOffset, int dataLength, boolean isLastBlock) throws T1Exception {
        try {
            boolean retransmit = true;
            block7: while (retransmit) {
                this.blockOutgoing.setIBlock((byte)0, (byte)0, this.numSeq, isLastBlock, buffer, dataOffset, dataLength);
                boolean result = this.cad.exchangeBlock(this.blockOutgoing, this.blockIncoming);
                if (!result) {
                    this.notifyPowerDown();
                    return -14;
                }
                this.numSeqTx = this.numSeq;
                this.numSeq = !this.numSeq;
                byte incomingBlockType = this.blockIncoming.getBlockType();
                switch (incomingBlockType) {
                    case 0: {
                        if (!isLastBlock) {
                            throw new T1Exception(-124);
                        }
                        boolean seqBlock = this.blockIncoming.getSequence();
                        if (seqBlock != this.numSeqRcv) {
                            this.numSeqRcv = seqBlock;
                            this.nextIBlock = this.blockIncoming;
                            retransmit = false;
                            this.lastBlockFlag = false;
                            continue block7;
                        }
                        this.numSeq = !this.numSeq;
                        retransmit = true;
                        continue block7;
                    }
                    case -128: {
                        boolean seqBlock = this.blockIncoming.getSequence();
                        if (isLastBlock) {
                            if (seqBlock != this.numSeqTx) {
                                throw new T1Exception(-126);
                            }
                            this.numSeq = !this.numSeq;
                            retransmit = true;
                            continue block7;
                        }
                        if (seqBlock != this.numSeqTx) {
                            retransmit = false;
                            continue block7;
                        }
                        this.numSeq = !this.numSeq;
                        retransmit = true;
                        continue block7;
                    }
                    case -64: {
                        boolean[] bRetransmit = new boolean[]{retransmit};
                        short sresult = this.t1ReplySBlock(bRetransmit);
                        retransmit = bRetransmit[0];
                        if (sresult == 0) continue block7;
                        return sresult;
                    }
                }
                throw new T1Exception(-126);
            }
            return 0;
        }
        catch (IOException ie) {
            throw new T1Exception(-126);
        }
    }

    public short t1RcvBlock(byte[] bufferINF, short[] LEN, short offset, short buffSize) throws T1Exception {
        try {
            if (this.nextIBlock != null) {
                this.placeDataInBuffer(bufferINF, LEN, offset, buffSize);
            } else {
                boolean retransmit = true;
                block12: while (retransmit) {
                    boolean seqBlock;
                    byte inBlockType;
                    boolean result;
                    if (this.recvFirstBlock) {
                        result = this.cad.receiveBlock(this.blockIncoming);
                        if (!result) {
                            this.notifyPowerDown();
                        }
                        this.recvFirstBlock = false;
                        inBlockType = this.blockIncoming.getBlockType();
                        switch (inBlockType) {
                            case 0: {
                                seqBlock = this.blockIncoming.getSequence();
                                if (seqBlock != this.numSeqRcv) {
                                    this.numSeqRcv = seqBlock;
                                    this.nextIBlock = this.blockIncoming;
                                    this.nextBlockDataOffset = 0;
                                    retransmit = false;
                                    break;
                                }
                                retransmit = true;
                                break;
                            }
                            case -128: {
                                throw new T1Exception(-126);
                            }
                            case -64: {
                                throw new T1Exception(-126);
                            }
                            default: {
                                throw new T1Exception(-126);
                            }
                        }
                        continue;
                    }
                    this.blockOutgoing.setRBlock((byte)0, (byte)0, !this.numSeqRcv);
                    result = this.cad.exchangeBlock(this.blockOutgoing, this.blockIncoming);
                    if (!result) {
                        this.notifyPowerDown();
                    }
                    inBlockType = this.blockIncoming.getBlockType();
                    switch (inBlockType) {
                        case 0: {
                            seqBlock = this.blockIncoming.getSequence();
                            if (seqBlock != this.numSeqRcv) {
                                this.numSeqRcv = seqBlock;
                                this.nextIBlock = this.blockIncoming;
                                this.nextBlockDataOffset = 0;
                                retransmit = false;
                                continue block12;
                            }
                            retransmit = true;
                            continue block12;
                        }
                        case -128: {
                            retransmit = true;
                            continue block12;
                        }
                        case -64: {
                            boolean[] bRetransmit = new boolean[]{retransmit};
                            short sresult = this.t1ReplySBlock(bRetransmit);
                            retransmit = bRetransmit[0];
                            if (sresult == 0) continue block12;
                            return sresult;
                        }
                    }
                    throw new T1Exception(-126);
                }
                this.placeDataInBuffer(bufferINF, LEN, offset, buffSize);
            }
            return 0;
        }
        catch (IOException ei) {
            throw new T1Exception(-126);
        }
    }

    public boolean t1Abort() throws T1Exception {
        try {
            boolean retransmit = true;
            block7: while (retransmit) {
                this.blockOutgoing.setSBlock((byte)0, (byte)0, -62, 0);
                boolean result = this.cad.exchangeBlock(this.blockOutgoing, this.blockIncoming);
                if (!result) {
                    this.notifyPowerDown();
                }
                byte incomingBlockType = this.blockIncoming.getBlockType();
                switch (incomingBlockType) {
                    case 0: {
                        throw new T1Exception(-126);
                    }
                    case -128: {
                        boolean seqBlock = this.blockIncoming.getSequence();
                        if (seqBlock != this.numSeqTx) {
                            retransmit = true;
                            continue block7;
                        }
                        throw new T1Exception(-126);
                    }
                    case -64: {
                        byte sbType = this.blockIncoming.getSBlockType();
                        if (sbType != -30) {
                            throw new T1Exception(-126);
                        }
                        this.nextBlockDataOffset = 0;
                        this.nextIBlock = null;
                        this.lastBlockFlag = true;
                        return true;
                    }
                }
                throw new T1Exception(-126);
            }
            return false;
        }
        catch (IOException ie) {
            throw new T1Exception(-126);
        }
    }

    public boolean t1Wait() throws T1Exception {
        try {
            boolean retransmit = true;
            block7: while (retransmit) {
                this.blockOutgoing.setSBlock((byte)0, (byte)0, -61, 0);
                boolean result = this.cad.exchangeBlock(this.blockOutgoing, this.blockIncoming);
                if (!result) {
                    this.notifyPowerDown();
                }
                byte incomingBlockType = this.blockIncoming.getBlockType();
                switch (incomingBlockType) {
                    case 0: {
                        throw new T1Exception(-126);
                    }
                    case -128: {
                        boolean seqBlock = this.blockIncoming.getSequence();
                        if (seqBlock != this.numSeqTx) {
                            retransmit = true;
                            continue block7;
                        }
                        throw new T1Exception(-126);
                    }
                    case -64: {
                        byte sbType = this.blockIncoming.getSBlockType();
                        if (sbType != -29) {
                            throw new T1Exception(-126);
                        }
                        return true;
                    }
                }
                throw new T1Exception(-126);
            }
            return false;
        }
        catch (IOException ie) {
            throw new T1Exception(-126);
        }
    }

    public byte t1GetNAD() {
        return 0;
    }

    public short t1GetIFSC() {
        return (short)this.sizeIFSC;
    }

    public short t1GetIFSD() {
        return (short)this.sizeIFSD;
    }

    public boolean t1LastBlockReceived() {
        return this.lastBlockFlag;
    }

    public void sendATR(byte[] atr) throws IOException, T1Exception {
        if (!this.cad.receivePowerUp()) {
            this.powerDown();
            throw new T1Exception(2);
        }
        this.powerUp();
        this.cad.sendATR(atr);
        this.serverState = 2;
    }

    private void powerUp() {
        this.serverState = 1;
    }

    private void powerDown() {
        this.serverState = 0;
    }

    public void discardIncomingGetLe(short[] LEN, short numBytesExpected, short numBytesReceived) {
        byte[] data = this.nextIBlock.getINFBytes();
        int dataLen = this.nextIBlock.getLEN() - this.nextBlockDataOffset;
        LEN[0] = (short)dataLen;
        this.lastBlockFlag = this.nextIBlock.isLastBlock();
        numBytesReceived = (short)(numBytesReceived + dataLen);
        short diff = (short)(numBytesExpected - numBytesReceived);
        short leOffset = 0;
        if (diff < 0) {
            if (diff == -1) {
                leOffset = (short)(this.nextBlockDataOffset + dataLen - 1);
                LEN[1] = (short)(data[leOffset] & 0xFF);
            } else if (dataLen >= 2) {
                leOffset = (short)(this.nextBlockDataOffset + dataLen - 2);
                LEN[1] = (short)(data[leOffset] << 8);
                LEN[1] = (short)(LEN[1] + (short)(data[(short)(leOffset + 1)] & 0xFF));
            } else {
                leOffset = (short)(this.nextBlockDataOffset + dataLen - 1);
                LEN[1] = (short)(LEN[1] << 8);
                LEN[1] = (short)(LEN[1] + (short)(data[leOffset] & 0xFF));
            }
        }
        this.nextIBlock = null;
        this.nextBlockDataOffset = 0;
    }
}

