/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.CadEvent;
import com.sun.javacard.apduio.CadServerListener;
import com.sun.javacard.apduio.ServerT0Protocol;
import com.sun.javacard.appletcontainer.APDUDispatcher;
import com.sun.javacard.impl.Constants;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.SocketConnection;

public class T0APDUConnection
implements CadServerListener,
Constants {
    private static final short BUFFER_OVERFLOW = -16383;
    private static final short READ_ERROR = -16381;
    private static final short WRITE_ERROR = -16380;
    private static final short INVALID_GET_RESPONSE = -16378;
    private static final byte ACK_NONE = 0;
    private static final byte ACK_INS = 1;
    private static final byte ACK_NOT_INS = 2;
    private static final byte GET_RESPONSE_CLA = 0;
    private static final byte GET_RESPONSE_INS = -64;
    private static final byte GET_RESPONSE_P1 = 0;
    private static final byte GET_RESPONSE_P2 = 0;
    private boolean invalidGetResponse = false;
    public int port = 0;
    public ServerSocketConnection serverSocketConnection = null;
    protected ServerT0Protocol t0Protocol;
    private byte[] t0APDUBuffer = new byte[133];
    private byte[] t0ScratchAPDUBuffer = new byte[133];
    private short apduStatus = 0;
    private byte[] command = new byte[5];

    public T0APDUConnection(int port) {
        this.port = port;
        try {
            this.serverSocketConnection = (ServerSocketConnection)Connector.open("socket://:" + port);
        }
        catch (Exception iE) {
            System.err.println(iE);
            throw new RuntimeException();
        }
    }

    public byte[] t0InitAPDUBuffer() {
        return this.t0APDUBuffer;
    }

    private ServerT0Protocol getClient() {
        byte[] atr = new byte[]{59, -16, 17, 0, -1, 0};
        if (this.t0Protocol == null) {
            SocketConnection sock = null;
            try {
                sock = (SocketConnection)this.serverSocketConnection.acceptAndOpen();
                this.t0Protocol = new ServerT0Protocol(sock.openInputStream(), sock.openOutputStream());
                this.t0Protocol.addCadServerListener(this);
                this.t0Protocol.sendATR(atr);
            }
            catch (Exception e) {
                if (sock != null) {
                    try {
                        sock.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                this.powerDown(null);
                throw new RuntimeException();
            }
        }
        return this.t0Protocol;
    }

    @Override
    public void powerUp(CadEvent evt) {
    }

    @Override
    public void powerDown(CadEvent evt) {
        this.t0Protocol = null;
        Thread ct = Thread.currentThread();
        if (ct instanceof APDUDispatcher) {
            APDUDispatcher dispatcher = (APDUDispatcher)ct;
            dispatcher.getChannelManager().deselectAll();
        }
    }

    public short t0RcvCommand() {
        if (this.getClient().t0RcvCommand(this.t0ScratchAPDUBuffer) != 0) {
            return -16381;
        }
        System.arraycopy(this.t0ScratchAPDUBuffer, 0, this.command, 0, 5);
        return 0;
    }

    public short t0SndStatusRcvCommand() {
        byte x = 0;
        if (this.invalidGetResponse) {
            this.invalidGetResponse = false;
            System.arraycopy(this.command, 0, this.t0ScratchAPDUBuffer, 0, 5);
        } else {
            x = this.getClient().t0SndStatusRcvCommand(this.t0ScratchAPDUBuffer, this.apduStatus);
            if (x != 0 && x != -14) {
                return -16381;
            }
            System.arraycopy(this.t0ScratchAPDUBuffer, 0, this.command, 0, 5);
        }
        return x;
    }

    public short t0RcvData(short offset) {
        byte status = 0;
        short receiveLen = (short)(this.command[4] & 0xFF);
        short receiveSpace = (short)(133 - offset);
        if (receiveLen > receiveSpace) {
            receiveLen = receiveSpace;
            while (true) {
                short s = receiveSpace;
                receiveSpace = (short)(receiveSpace - 1);
                if (s != 0 && status == 0) {
                    short s2 = offset;
                    offset = (short)(offset + 1);
                    status = this.getClient().t0RcvData(this.t0ScratchAPDUBuffer, s2, (short)1, ~this.command[1]);
                    continue;
                }
                break;
            }
        } else {
            status = this.getClient().t0RcvData(this.t0ScratchAPDUBuffer, offset, receiveLen, this.command[1]);
        }
        this.command[4] = (byte)(this.command[4] - receiveLen);
        if (status == 0) {
            return receiveLen;
        }
        return -16381;
    }

    public short t0SndData(byte[] data, short offset, short length, byte procByteType) {
        switch (procByteType) {
            case 0: {
                if (this.getClient().t0SndData(data, offset, length) == 0) break;
                return -16380;
            }
            case 1: {
                if (this.getClient().t0SndData(data, offset, length, this.command[1]) == 0) break;
                return -16380;
            }
            case 2: {
                if (this.getClient().t0SndData(data, offset, length, ~this.command[1]) == 0) break;
                return -16380;
            }
            default: {
                return -16380;
            }
        }
        return 0;
    }

    public short t0SndGetResponse(byte channelId) {
        if (this.getClient().t0SndStatusRcvCommand(this.command, this.apduStatus) != 0) {
            return -16381;
        }
        boolean extChannel = (this.command[0] & 0x40) != 0;
        byte cla = 0;
        byte receivedChannelID = 0;
        if (extChannel) {
            cla = (byte)(this.command[0] & 0xFFFFFFB0);
            receivedChannelID = (byte)((this.command[0] & 0xF) + 4);
        } else {
            cla = (byte)(this.command[0] & 0xFFFFFFFC);
            receivedChannelID = (byte)(this.command[0] & 3);
        }
        if (cla != 0 || this.command[1] != -64 || this.command[2] != 0 || this.command[3] != 0) {
            this.invalidGetResponse = true;
            return -16378;
        }
        if (receivedChannelID != channelId) {
            this.invalidGetResponse = true;
            return -16378;
        }
        return (short)(this.command[4] & 0xFF);
    }

    public short t0Wait() {
        if (this.getClient().t0SndData(this.t0ScratchAPDUBuffer, (short)0, (short)0, (byte)96) != 0) {
            return -16380;
        }
        return 0;
    }

    public byte[] t0InitScratchAPDUBuffer() {
        return this.t0ScratchAPDUBuffer;
    }

    public void t0CopyToAPDUBuffer(short offset, short length) {
        System.arraycopy(this.t0ScratchAPDUBuffer, offset, this.t0APDUBuffer, offset, length);
    }

    public short t0SetStatus(short sw1Sw2) {
        this.apduStatus = sw1Sw2;
        return 0;
    }
}

