/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cm.impl;

import com.sun.javacard.cm.impl.applethandler.AppletApplicationDescriptor;
import com.sun.javacard.cm.impl.applethandler.AppletElementNotSupportedException;
import com.sun.javacard.cm.impl.jcad.JCPlatformAppDesc;
import com.sun.javacard.cm.impl.jcrd.ClientRole;
import com.sun.javacard.cm.impl.jcrd.FormatErrorException;
import com.sun.javacard.cm.impl.jcrd.ModuleInfo;
import com.sun.javacard.cm.impl.jcrd.UserRole;
import com.sun.javacard.cm.impl.wad.LoginConfig;
import com.sun.javacard.cm.impl.wad.WebAppDesc;
import com.sun.javacard.cm.impl.wad.WebElementNotSupportException;
import com.sun.javacard.file.FileConnection;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.jaxp.org.xml.sax.SAXException;
import com.sun.midp.io.Base64;
import com.sun.midp.pki.X509Certificate;
import com.sun.spot.security.implementation.RSAPrivateKey;
import com.sun.spot.security.implementation.Util;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.microedition.pki.Certificate;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class ApplicationModule {
    private String moduleName;
    private JCPlatformAppDesc moduleJcad = null;
    private WebAppDesc moduleWad = null;
    private AppletApplicationDescriptor moduleAad = null;
    private String appClassPath = null;
    private String webRootURI;
    private int webSecurePort;
    private boolean isWebSecureAccessOnly;
    private ModuleInfo moduleInfo;
    private Vector<String> exposedSIList;
    private static String APP_MODULE_MANIFEST = "META-INF/MANIFEST.MF";
    private static String APP_MODULE_JCAD = "META-INF/javacard.xml";
    private static String APP_CLASSES = "WEB-INF/classes";
    private static String APP_MODULE_WAD = "WEB-INF/web.xml";
    private static String CLASS_PATH_ATTR_NAME = "Class-Path";
    private static String APP_APPLET_CLASSES = "APPLET-INF/classes";
    private static String APP_MODULE_AAD = "APPLET-INF/applet.xml";
    private static String APPLET_CLASS_PATH_ATTR_NAME = "Class-Path";
    private static final String CREDENTIAL_DIR = "WEB-INF/credentials";
    private static final String WEB_SERVER_CERTS_ATTR = "com.sun.javacard.credentials.webServerCerts";
    private static final String WEB_SERVER_PRIV_KEY_ATTR = "com.sun.javacard.credentials.webServerPrivKey";
    private static final String WEB_CLIENT_TRUSTED_CERTS_ATTR = "com.sun.javacard.credentials.webClientTrustedCerts";
    private static final String WEB_SERVER_PRIV_KEY_FILE = "server.key";
    private static final String WEB_SERVER_CERTS_FILE = "server.crt";
    private static final String WEB_CLIENT_TRUSTED_CERTS_FILE_SUFFIX = ".crt";

    public ApplicationModule(FileConnection mdir, ModuleInfo mi, byte type) throws IOException, SAXException, FormatErrorException, WebElementNotSupportException {
        this.moduleInfo = mi;
        this.moduleName = this.moduleInfo.getModuleName();
        this.exposedSIList = new Vector();
        InputStream is = null;
        if (!mdir.exists()) {
            throw new IOException("4094");
        }
        FileConnection jcad = new FileConnection(mdir, APP_MODULE_JCAD);
        if (jcad.exists()) {
            is = jcad.openInputStream();
            this.moduleJcad = new JCPlatformAppDesc(is);
        }
        if (type == 10) {
            FileConnection appClassDir;
            FileConnection wadFile = new FileConnection(mdir, APP_MODULE_WAD);
            if (!wadFile.exists()) {
                throw new IOException("4097");
            }
            is = wadFile.openInputStream();
            this.moduleWad = new WebAppDesc(is);
            if (is != null) {
                is.close();
            }
            this.appClassPath = (appClassDir = new FileConnection(mdir, APP_CLASSES)).exists() ? appClassDir.getAbsolutePath().intern() : appClassDir.getAbsolutePath().intern();
            this.webRootURI = this.moduleInfo.getWebContextPath();
            this.webSecurePort = this.moduleInfo.getWebSecurePort();
            this.isWebSecureAccessOnly = this.moduleInfo.isWebSecureAccessOnly();
            ApplicationModule.validateSecurRoleAuthUriPathPrefix(this.moduleWad, this.moduleInfo);
            ApplicationModule.validateCardHolderMissingItsAuthUri(this.moduleJcad, this.moduleInfo);
            ApplicationModule.validateCardHolderAuthUriNameSpace(this.moduleJcad, this.moduleInfo);
            ApplicationModule.validateUserRequiringCardHolderAuthorizButMappedToHolderAuthUri(this.moduleJcad, this.moduleWad, this.moduleInfo);
            ApplicationModule.validateRemoteAccessAppHavingCardHolderRoleDefinedInSecurityConstraint(this.moduleJcad, this.moduleWad, this.moduleInfo);
            ApplicationModule.validateAuthMethodMatchesWithAuthScheme(this.moduleWad, this.moduleInfo);
            ApplicationModule.validateJcrdRolesInOtherDescriptors(this.moduleJcad, this.moduleWad, this.moduleInfo);
            ApplicationModule.validateWadRolesVersusJcrdRoles(this.moduleWad, this.moduleInfo);
            ApplicationModule.validateJcadRolesVersusJcrdRoles(this.moduleJcad, this.moduleInfo);
            this.createExposedSIList(this.moduleJcad, this.moduleInfo);
        } else {
            FileConnection appClassDir;
            FileConnection aadFile = new FileConnection(mdir, APP_MODULE_AAD);
            if (!aadFile.exists()) {
                throw new IOException("4304");
            }
            is = aadFile.openInputStream();
            try {
                this.moduleAad = new AppletApplicationDescriptor(is);
            }
            catch (AppletElementNotSupportedException e) {
                throw new FormatErrorException("4305", e.getMessage());
            }
            if (is != null) {
                is.close();
            }
            this.appClassPath = (appClassDir = new FileConnection(mdir, APP_APPLET_CLASSES)).exists() ? appClassDir.getAbsolutePath().intern() : appClassDir.getAbsolutePath();
            if (type == 11) {
                ApplicationModule.validateCardHolderMissingItsAuthUri(this.moduleJcad, this.moduleInfo);
                ApplicationModule.validateCardHolderAuthUriNameSpace(this.moduleJcad, this.moduleInfo);
            }
            this.createExposedSIList(this.moduleJcad, this.moduleInfo);
        }
    }

    static void validateSecurRoleAuthUriPathPrefix(WebAppDesc wad, ModuleInfo mi) throws FormatErrorException {
        Vector<String> securityRoles = wad.getSecurityRoleNames();
        Vector<UserRole> userRoles = mi.getUserRoleList();
        if (securityRoles == null) {
            return;
        }
        if (userRoles == null) {
            return;
        }
        for (String role : securityRoles) {
            for (UserRole ur : userRoles) {
                Vector<String> uris;
                if (!ur.getUserRoleName().equals(role) || (uris = ur.getAuthURIs()) == null) continue;
                for (String uri : uris) {
                    if (!uri.endsWith("/*")) continue;
                    throw new FormatErrorException("4110", uri + "\n" + ur.getUserRoleName());
                }
            }
        }
    }

    static void validateCardHolderMissingItsAuthUri(JCPlatformAppDesc jcad, ModuleInfo mi) throws FormatErrorException {
        if (jcad == null) {
            return;
        }
        Vector<String> cardHolderRoles = jcad.getCardHolderAuthorization();
        Vector<UserRole> userRoles = mi.getUserRoleList();
        Vector<String> userlist = null;
        if (cardHolderRoles == null) {
            return;
        }
        if (userRoles == null) {
            throw new FormatErrorException("4115", cardHolderRoles.elementAt(0));
        }
        for (UserRole ur : userRoles) {
            if (userlist == null) {
                userlist = new Vector<String>();
            }
            userlist.addElement(ur.getUserRoleName());
        }
        for (String cardHolder : cardHolderRoles) {
            if (userlist.size() == 0) {
                throw new FormatErrorException("4115", cardHolder);
            }
            if (userlist.contains(cardHolder)) continue;
            throw new FormatErrorException("4115", cardHolder);
        }
    }

    static void validateCardHolderAuthUriNameSpace(JCPlatformAppDesc jcad, ModuleInfo mi) throws FormatErrorException {
        if (jcad == null) {
            return;
        }
        Vector<String> cardHolderRoles = jcad.getCardHolderAuthorization();
        Vector<UserRole> userRoles = mi.getUserRoleList();
        if (cardHolderRoles == null) {
            return;
        }
        if (userRoles == null) {
            return;
        }
        for (String role : cardHolderRoles) {
            for (UserRole ur : userRoles) {
                Vector<String> uris;
                if (!ur.getUserRoleName().equals(role) || (uris = ur.getAuthURIs()) == null) continue;
                for (String uri : uris) {
                    if (uri.startsWith("sio:///standard/auth/holder")) continue;
                    throw new FormatErrorException("4113", uri + "\n" + ur.getUserRoleName());
                }
            }
        }
    }

    static void validateUserRequiringCardHolderAuthorizButMappedToHolderAuthUri(JCPlatformAppDesc jcad, WebAppDesc wad, ModuleInfo mi) throws FormatErrorException {
        if (jcad == null) {
            return;
        }
        Vector<String> cardHolderRoles = jcad.getCardHolderAuthorization();
        Vector<UserRole> userRoles = mi.getUserRoleList();
        Vector<String> rolesInAuthConstraints = wad.getAuthConstraintsRoles();
        if (rolesInAuthConstraints == null || cardHolderRoles == null) {
            return;
        }
        if (userRoles == null) {
            return;
        }
        for (UserRole ur : userRoles) {
            Vector<String> uris;
            String rName = ur.getUserRoleName();
            if (cardHolderRoles.contains(rName) || !rolesInAuthConstraints.contains(rName) || (uris = ur.getAuthURIs()) == null) continue;
            for (String uri : uris) {
                if (!uri.startsWith("sio:///standard/auth/holder")) continue;
                throw new FormatErrorException("4114", rName);
            }
        }
    }

    static void validateRemoteAccessAppHavingCardHolderRoleDefinedInSecurityConstraint(JCPlatformAppDesc jcad, WebAppDesc wad, ModuleInfo mi) throws FormatErrorException {
        if (jcad == null) {
            return;
        }
        Vector<String> cardHolderRoles = jcad.getCardHolderAuthorization();
        Vector<UserRole> userRoles = mi.getUserRoleList();
        Vector<String> rolesInAuthConstraints = wad.getAuthConstraintsRoles();
        if (rolesInAuthConstraints == null || cardHolderRoles == null) {
            return;
        }
        if (userRoles == null) {
            return;
        }
        for (UserRole ur : userRoles) {
            Vector<String> uris;
            String rName = ur.getUserRoleName();
            if (!cardHolderRoles.contains(rName) || (uris = ur.getAuthURIs()) == null) continue;
            for (String uri : uris) {
                if (!uri.startsWith("sio:///standard/auth/holder") || !rolesInAuthConstraints.contains(rName)) continue;
                throw new FormatErrorException("4125", rName);
            }
        }
    }

    static void validateAuthURIScheme(String role, Vector<String> uris, Vector<LoginConfig> loginConfigs) throws FormatErrorException {
        Iterator<LoginConfig> i$;
        if (loginConfigs != null && (i$ = loginConfigs.iterator()).hasNext()) {
            LoginConfig login = i$.next();
            String authMethod = login.getAuthMethod();
            if (authMethod.startsWith("JC-")) {
                String scheme = authMethod.substring(3);
                for (String uri : uris) {
                    if (uri.endsWith("/" + scheme)) continue;
                    throw new FormatErrorException("4123", authMethod + "\n" + role);
                }
                return;
            }
            if (authMethod.equals("BASIC") || authMethod.equals("FORM") || authMethod.equals("DIGEST")) {
                for (String uri : uris) {
                    if (uri.endsWith("/pin") || uri.endsWith("/password")) continue;
                    throw new FormatErrorException("4123", authMethod + "\n" + role);
                }
                return;
            }
            throw new FormatErrorException("4123", authMethod + "\n" + role);
        }
    }

    static void validateAuthMethodMatchesWithAuthScheme(WebAppDesc wad, ModuleInfo mi) throws FormatErrorException {
        Vector<String> rolesInAuthConstraints = wad.getAuthConstraintsRoles();
        Vector<UserRole> userRoles = mi.getUserRoleList();
        Vector<LoginConfig> loginConfigs = wad.getLoginConfigs();
        if (rolesInAuthConstraints == null) {
            return;
        }
        if (userRoles == null) {
            return;
        }
        for (String role : rolesInAuthConstraints) {
            for (UserRole ur : userRoles) {
                Vector<String> uris;
                if (!ur.getUserRoleName().equals(role) || (uris = ur.getAuthURIs()) == null) continue;
                ApplicationModule.validateAuthURIScheme(role, uris, loginConfigs);
            }
        }
    }

    static void validateJcrdRolesInOtherDescriptors(JCPlatformAppDesc jcad, WebAppDesc wad, ModuleInfo mi) throws FormatErrorException {
        String category;
        Vector<String> sRoles;
        Vector<UserRole> userRoles = mi.getUserRoleList();
        Vector<ClientRole> clientRoles = mi.getClientRoleList();
        Vector<String> jcadRoles = new Vector<String>();
        Vector<String> wadRoles = new Vector<String>();
        if (userRoles == null && clientRoles == null) {
            return;
        }
        if (jcad != null && (sRoles = jcad.getSecurityRoleNames()) != null) {
            for (String rn : sRoles) {
                jcadRoles.addElement(rn);
            }
        }
        if (wad != null && (sRoles = wad.getSecurityRoleNames()) != null) {
            for (String rn : sRoles) {
                wadRoles.addElement(rn);
            }
        }
        if (userRoles != null) {
            Vector<String> userRoleList = new Vector<String>();
            for (UserRole ur : userRoles) {
                userRoleList.addElement(ur.getUserRoleName());
            }
            if (jcadRoles.isEmpty() && wadRoles.isEmpty() && !userRoleList.isEmpty()) {
                String uRole = (String)userRoleList.elementAt(0);
                throw new FormatErrorException("4129", uRole);
            }
            for (String uRole : userRoleList) {
                if (!wadRoles.contains(uRole) && !jcadRoles.contains(uRole)) {
                    throw new FormatErrorException("4129", uRole);
                }
                if (!jcadRoles.contains(uRole) || (category = jcad.getSecurityRoleCategory(uRole)) == null || category.equals("USER")) continue;
                throw new FormatErrorException("4130", uRole);
            }
        }
        if (clientRoles != null) {
            Vector<String> clientRoleList = new Vector<String>();
            for (ClientRole cr : clientRoles) {
                clientRoleList.addElement(cr.getClientRoleName());
            }
            if (jcad == null && !clientRoleList.isEmpty()) {
                throw new FormatErrorException("4131", (String)clientRoleList.elementAt(0));
            }
            if (jcadRoles.isEmpty() && !clientRoleList.isEmpty()) {
                throw new FormatErrorException("4131", (String)clientRoleList.elementAt(0));
            }
            for (String cRole : clientRoleList) {
                if (!jcadRoles.contains(cRole)) {
                    throw new FormatErrorException("4131", cRole);
                }
                if (!jcadRoles.contains(cRole) || (category = jcad.getSecurityRoleCategory(cRole)) == null || category.equals("ON-CARD-CLIENT")) continue;
                throw new FormatErrorException("4132", cRole);
            }
        }
    }

    static void validateWadRolesVersusJcrdRoles(WebAppDesc wad, ModuleInfo mi) throws FormatErrorException {
        Vector<UserRole> userRoles;
        if (wad == null) {
            return;
        }
        Vector<String> sRoles = wad.getSecurityRoleNames();
        if (sRoles == null) {
            return;
        }
        Vector<String> wadRoles = new Vector<String>();
        if (sRoles != null) {
            for (String rn : sRoles) {
                wadRoles.addElement(rn);
            }
        }
        if ((userRoles = mi.getUserRoleList()) == null) {
            String role = (String)wadRoles.elementAt(0);
            throw new FormatErrorException("4127", role);
        }
        Vector<String> userRoleList = new Vector<String>();
        for (UserRole ur : userRoles) {
            userRoleList.addElement(ur.getUserRoleName());
        }
        for (String roleName : wadRoles) {
            if (userRoleList.contains(roleName)) continue;
            throw new FormatErrorException("4127", roleName);
        }
    }

    static void validateJcadRolesVersusJcrdRoles(JCPlatformAppDesc jcad, ModuleInfo mi) throws FormatErrorException {
        String category;
        if (jcad == null) {
            return;
        }
        Vector<String> sRoles = jcad.getSecurityRoleNames();
        if (sRoles == null) {
            return;
        }
        Vector<String> jcadRoles = new Vector<String>();
        if (sRoles != null) {
            for (String rn : sRoles) {
                jcadRoles.addElement(rn);
            }
        }
        Vector<UserRole> userRoles = mi.getUserRoleList();
        Vector<ClientRole> clientRoles = mi.getClientRoleList();
        if (userRoles == null && clientRoles == null) {
            String role = (String)jcadRoles.elementAt(0);
            String category2 = jcad.getSecurityRoleCategory(role);
            throw new FormatErrorException("4128", role + "\n" + category2);
        }
        if (userRoles != null) {
            Vector<String> userRoleList = new Vector<String>();
            for (UserRole ur : userRoles) {
                userRoleList.addElement(ur.getUserRoleName());
            }
            for (String roleName : jcadRoles) {
                category = jcad.getSecurityRoleCategory(roleName);
                if (category == null || !category.equals("USER") || userRoleList.contains(roleName)) continue;
                throw new FormatErrorException("4128", roleName + "\n" + "USER");
            }
        }
        if (clientRoles != null) {
            Vector<String> clientRoleList = new Vector<String>();
            for (ClientRole cr : clientRoles) {
                clientRoleList.addElement(cr.getClientRoleName());
            }
            for (String roleName : jcadRoles) {
                category = jcad.getSecurityRoleCategory(roleName);
                if (category == null || !category.equals("ON-CARD-CLIENT") || clientRoleList.contains(roleName)) continue;
                throw new FormatErrorException("4128", roleName + "\n" + "ON-CARD-CLIENT");
            }
        }
    }

    static void validateSIOLists(Vector<String> completeSIList, Vector<String> unexposedSIs) throws FormatErrorException {
        if (unexposedSIs == null) {
            return;
        }
        for (String uSI : unexposedSIs) {
            if (completeSIList == null) {
                throw new FormatErrorException("4111", uSI);
            }
            if (completeSIList.contains(uSI)) continue;
            throw new FormatErrorException("4111", uSI);
        }
    }

    private void createExposedSIList(JCPlatformAppDesc jcad, ModuleInfo mi) throws FormatErrorException {
        Vector<String> completeSIList = null;
        if (jcad != null) {
            completeSIList = jcad.getShareableInterfaceClasses();
        }
        Vector<String> unexposedSIs = mi.getUnexposedSIOsList();
        ApplicationModule.validateSIOLists(completeSIList, unexposedSIs);
        if (completeSIList != null) {
            for (String SI : completeSIList) {
                if (unexposedSIs == null || unexposedSIs.contains(SI)) continue;
                this.exposedSIList.addElement(SI);
            }
        }
    }

    public String getName() {
        return this.moduleName;
    }

    public JCPlatformAppDesc getJCAppDesc() {
        return this.moduleJcad;
    }

    public WebAppDesc getWebAppDesc() {
        return this.moduleWad;
    }

    public AppletApplicationDescriptor getAppletAppDesc() {
        return this.moduleAad;
    }

    public String getAppClassPath() {
        return this.appClassPath;
    }

    public String getWebRootURI() {
        return this.webRootURI;
    }

    int getWebSecurePort() {
        return this.webSecurePort;
    }

    boolean getWebSecureAccessOnly() {
        return this.isWebSecureAccessOnly;
    }

    Vector<String> getExposedSIList() {
        return this.exposedSIList;
    }

    private String formatClassPath(FileConnection mdir, String str) {
        FileConnection bdir = mdir.getParentFile();
        StringBuffer newStr = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(str, " ");
        String token = null;
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (token.endsWith(".jar")) {
                token = token.substring(0, token.length() - 4);
            }
            newStr.append(bdir.getAbsolutePath());
            newStr.append("/lib");
            if (!token.startsWith("/")) {
                newStr.append("/");
            }
            newStr.append(token);
            if (!token.endsWith("/")) {
                newStr.append("/");
            }
            if (!tokenizer.hasMoreTokens()) continue;
            newStr.append(":");
        }
        return newStr.toString();
    }

    private static Hashtable<String, Object> loadWebCredentials(FileConnection[] credentialFiles) throws IOException {
        Hashtable<String, Object> webCredentials = null;
        Certificate[] serverCerts = null;
        RSAPrivateKey serverKey = null;
        Vector<X509Certificate> trustedCerts = null;
        for (FileConnection credentialFile : credentialFiles) {
            StringTokenizer tokenizer;
            String content;
            DataInputStream is;
            if (credentialFile.getName().equals(WEB_SERVER_CERTS_FILE)) {
                is = credentialFile.openDataInputStream();
                content = ApplicationModule.readContent(is);
                tokenizer = new StringTokenizer(content);
                serverCerts = new Certificate[tokenizer.countTokens()];
                for (int i = 0; i < serverCerts.length; ++i) {
                    byte[] certificateDer = Base64.decode(tokenizer.nextToken());
                    serverCerts[i] = X509Certificate.generateCertificate(certificateDer, 0, certificateDer.length);
                }
                continue;
            }
            if (credentialFile.getName().equals(WEB_SERVER_PRIV_KEY_FILE)) {
                is = credentialFile.openDataInputStream();
                content = ApplicationModule.readContent(is);
                tokenizer = new StringTokenizer(content);
                if (tokenizer.countTokens() != 2) continue;
                byte[] keyMod = ApplicationModule.hexDecode(tokenizer.nextToken());
                byte[] keyExp = ApplicationModule.hexDecode(tokenizer.nextToken());
                serverKey = new RSAPrivateKey(keyMod, keyExp);
                continue;
            }
            if (!credentialFile.getName().endsWith(WEB_CLIENT_TRUSTED_CERTS_FILE_SUFFIX)) continue;
            is = credentialFile.openDataInputStream();
            content = ApplicationModule.readContent(is);
            byte[] certificateDer = Base64.decode(content);
            X509Certificate trustedCert = X509Certificate.generateCertificate(certificateDer, 0, certificateDer.length);
            if (trustedCerts == null) {
                trustedCerts = new Vector<X509Certificate>(credentialFiles.length - 2);
            }
            trustedCerts.addElement(trustedCert);
        }
        if (serverCerts != null || serverKey != null || trustedCerts != null) {
            webCredentials = new Hashtable<String, Object>();
            NativeMethods.setJCREentry(webCredentials, false);
            if (serverCerts != null) {
                webCredentials.put(WEB_SERVER_CERTS_ATTR, serverCerts);
            }
            if (serverKey != null) {
                webCredentials.put(WEB_SERVER_PRIV_KEY_ATTR, serverKey);
            }
            if (trustedCerts != null) {
                Object[] trustedCertArray = new Certificate[trustedCerts.size()];
                trustedCerts.copyInto(trustedCertArray);
                webCredentials.put(WEB_CLIENT_TRUSTED_CERTS_ATTR, trustedCertArray);
            }
        }
        return webCredentials;
    }

    private static String readContent(InputStream is) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuffer content = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            content.append((line = line.trim()).length() == 0 ? "\n" : line);
        }
        return content.toString().trim();
    }

    private static byte[] hexDecode(String s) {
        while (s.startsWith("00:")) {
            s = s.substring(3);
        }
        return Util.hexDecode((String)s, (char)':');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable<String, Object> getWebCredentials(String moduleDir, int fwId, int appId) throws IOException {
        try {
            NativeMethods.switchContext(fwId, appId);
            FileConnection credentialDir = new FileConnection(moduleDir, CREDENTIAL_DIR);
            if (credentialDir.exists()) {
                Hashtable<String, Object> hashtable = ApplicationModule.loadWebCredentials(credentialDir.listFiles());
                return hashtable;
            }
            Hashtable<String, Object> hashtable = null;
            return hashtable;
        }
        finally {
            NativeMethods.switchContext(0, 0);
        }
    }
}

