/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cm.impl.wad;

import com.sun.javacard.cm.impl.jcrd.FormatErrorException;
import com.sun.javacard.cm.impl.wad.AuthConstraint;
import com.sun.javacard.cm.impl.wad.ErrorPage;
import com.sun.javacard.cm.impl.wad.Filter;
import com.sun.javacard.cm.impl.wad.FilterMapping;
import com.sun.javacard.cm.impl.wad.FormLoginConfig;
import com.sun.javacard.cm.impl.wad.Icon;
import com.sun.javacard.cm.impl.wad.Listener;
import com.sun.javacard.cm.impl.wad.LocaleEncodingMapping;
import com.sun.javacard.cm.impl.wad.LoginConfig;
import com.sun.javacard.cm.impl.wad.Param;
import com.sun.javacard.cm.impl.wad.SecurityConstraint;
import com.sun.javacard.cm.impl.wad.SecurityRole;
import com.sun.javacard.cm.impl.wad.SecurityRoleRef;
import com.sun.javacard.cm.impl.wad.Servlet;
import com.sun.javacard.cm.impl.wad.ServletMapping;
import com.sun.javacard.cm.impl.wad.UserDataConstraint;
import com.sun.javacard.cm.impl.wad.WebElementNotSupportException;
import com.sun.javacard.cm.impl.wad.WebResourceCollection;
import com.sun.javacard.jaxp.org.xml.sax.SAXException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import org.mortbay.xml.XmlParser;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class WebAppDesc {
    Vector<String> descriptions;
    Vector<String> displayNames;
    Vector<Icon> icons;
    Vector<Filter> filters;
    Vector<FilterMapping> filterMappings;
    Vector<Listener> listeners;
    Vector<Servlet> servlets;
    Vector<ServletMapping> servletMappings;
    Vector<Param> contextParams;
    int sessionTimeout = 0;
    Hashtable<String, String> mimeMappings;
    Vector<String> welcomeFileList;
    Vector<ErrorPage> errorPages;
    Vector<SecurityRole> securityRoles;
    Vector<SecurityConstraint> securityConstraints = new Vector();
    Vector<LoginConfig> loginConfigs;
    Vector<LocaleEncodingMapping> localeEncodingMappingList;
    boolean isIntegrityRequired = false;
    boolean isConfidentialityRequired = false;

    public WebAppDesc(InputStream is) throws IOException, SAXException, WebElementNotSupportException, FormatErrorException {
        XmlParser xp = new XmlParser();
        XmlParser.Node node = xp.parse(is);
        this.verifyJawVersion(node);
        Iterator<Object> iter = node.iterator();
        XmlParser.Node node1 = null;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof XmlParser.Node)) continue;
            node1 = (XmlParser.Node)o;
            String element = node1.getTag();
            if ("description".equals(element)) {
                if (this.descriptions == null) {
                    this.descriptions = new Vector();
                }
                this.populateStrings(node1, this.descriptions);
                continue;
            }
            if ("display-name".equals(element)) {
                if (this.displayNames == null) {
                    this.displayNames = new Vector();
                }
                this.populateStrings(node1, this.displayNames);
                continue;
            }
            if ("icon".equals(element)) {
                if (this.icons == null) {
                    this.icons = new Vector();
                }
                this.populateIcons(node1);
                continue;
            }
            if ("context-param".equals(element)) {
                if (this.contextParams == null) {
                    this.contextParams = new Vector();
                }
                this.populateContextParams(node1);
                continue;
            }
            if ("filter".equals(element)) {
                if (this.filters == null) {
                    this.filters = new Vector();
                }
                this.populateFilters(node1);
                continue;
            }
            if ("filter-mapping".equals(element)) {
                if (this.filterMappings == null) {
                    this.filterMappings = new Vector();
                }
                this.populateFilterMappings(node1);
                continue;
            }
            if ("listener".equals(element)) {
                if (this.listeners == null) {
                    this.listeners = new Vector();
                }
                this.populateListeners(node1);
                continue;
            }
            if ("servlet".equals(element)) {
                if (this.servlets == null) {
                    this.servlets = new Vector();
                }
                this.populateServlets(node1);
                continue;
            }
            if ("servlet-mapping".equals(element)) {
                if (this.servletMappings == null) {
                    this.servletMappings = new Vector();
                }
                this.populateServletMappings(node1);
                continue;
            }
            if ("session-config".equals(element)) {
                this.populateSessionConfig(node1);
                continue;
            }
            if ("mime-mapping".equals(element)) {
                if (this.mimeMappings == null) {
                    this.mimeMappings = new Hashtable();
                }
                this.populateMimeMappings(node1);
                continue;
            }
            if ("welcome-file-list".equals(element)) {
                if (this.welcomeFileList == null) {
                    this.welcomeFileList = new Vector();
                }
                this.populateWelcomeFileList(node1);
                continue;
            }
            if ("error-page".equals(element)) {
                if (this.errorPages == null) {
                    this.errorPages = new Vector();
                }
                this.populateErrorPages(node1);
                continue;
            }
            if ("security-constraint".equals(element)) {
                if (this.securityConstraints == null) {
                    this.securityConstraints = new Vector();
                }
                this.populateSecurityConstraints(node1);
                continue;
            }
            if ("login-config".equals(element)) {
                if (this.loginConfigs == null) {
                    this.loginConfigs = new Vector();
                }
                this.populateLoginConfig(node1);
                continue;
            }
            if ("security-role".equals(element)) {
                if (this.securityRoles == null) {
                    this.securityRoles = new Vector();
                }
                this.populateSecurityRoles(node1);
                continue;
            }
            if ("locale-encoding-mapping-list".equals(element)) {
                if (this.localeEncodingMappingList == null) {
                    this.localeEncodingMappingList = new Vector();
                }
                this.populateLocaleEncodingMappingList(node1);
                continue;
            }
            throw new WebElementNotSupportException("web.xml: element <" + element + ">");
        }
        this.verifyIfAuthConstraintRolesListedInSecurityRoles();
        this.verifyIfFilterNameInFilterMappingIsInFilters();
        this.verifyIfServletNameInServletMappingIsInServlets();
    }

    private void verifyJawVersion(XmlParser.Node node) throws WebElementNotSupportException, FormatErrorException {
        String element = node.getTag();
        String version = node.getAttribute("version");
        if (!element.equalsIgnoreCase("web-app")) {
            throw new WebElementNotSupportException("web.xml: element <" + element + ">");
        }
        if (version == null || !version.equals("2.4")) {
            throw new FormatErrorException("4104", version);
        }
    }

    private void verifyIfAuthConstraintRolesListedInSecurityRoles() throws FormatErrorException {
        Vector<String> rolesInSecRoles = this.getSecurityRoleNames();
        Vector<String> rolesInAuthConstraints = this.getAuthConstraintsRoles();
        if (rolesInAuthConstraints == null && rolesInSecRoles == null) {
            return;
        }
        if (rolesInAuthConstraints != null && rolesInSecRoles == null) {
            String aRole = rolesInAuthConstraints.elementAt(0);
            throw new FormatErrorException("4109", aRole);
        }
        if (rolesInAuthConstraints != null && rolesInSecRoles != null) {
            for (String rName : rolesInAuthConstraints) {
                if (rolesInSecRoles == null || rName.equals("*") || rolesInSecRoles.contains(rName)) continue;
                throw new FormatErrorException("4109", rName);
            }
        }
    }

    private void verifyIfFilterNameInFilterMappingIsInFilters() throws FormatErrorException {
        if (this.filterMappings == null) {
            return;
        }
        Vector<String> fNamesInFilterMapppings = new Vector<String>();
        for (FilterMapping fm : this.filterMappings) {
            fNamesInFilterMapppings.addElement(fm.getFilterName());
        }
        if (this.filters == null) {
            throw new FormatErrorException("4121", (String)fNamesInFilterMapppings.elementAt(0));
        }
        Vector<String> fNamesInFilters = new Vector<String>();
        for (Filter f : this.filters) {
            fNamesInFilters.addElement(f.getFilterName());
        }
        for (String fn : fNamesInFilterMapppings) {
            if (fNamesInFilters.contains(fn)) continue;
            throw new FormatErrorException("4121", fn);
        }
    }

    private void verifyIfServletNameInServletMappingIsInServlets() throws FormatErrorException {
        if (this.servletMappings == null) {
            return;
        }
        Vector<String> sNamesInServletMapppings = new Vector<String>();
        for (ServletMapping sm : this.servletMappings) {
            sNamesInServletMapppings.addElement(sm.getServletName());
        }
        if (this.servlets == null) {
            throw new FormatErrorException("4124", (String)sNamesInServletMapppings.elementAt(0));
        }
        Vector<String> sNamesInServlets = new Vector<String>();
        for (Servlet s : this.servlets) {
            sNamesInServlets.addElement(s.getServletName());
        }
        for (String sn : sNamesInServletMapppings) {
            if (sNamesInServlets.contains(sn)) continue;
            throw new FormatErrorException("4124", sn);
        }
    }

    private void populateStrings(XmlParser.Node node, Vector<String> list) {
        String desc = node.toString(false, true);
        list.addElement(desc);
    }

    private void populateIcons(XmlParser.Node node) {
        Icon icon = null;
        String small_icon = node.getString("small-icon", false, true);
        String large_icon = node.getString("large-icon", false, true);
        if (small_icon != null || large_icon != null) {
            icon = new Icon(small_icon, large_icon);
        }
        if (icon != null) {
            this.icons.addElement(icon);
        }
    }

    private void populateContextParams(XmlParser.Node node) {
        Vector<String> descs = null;
        Iterator<XmlParser.Node> itr = node.iterator("description");
        while (itr.hasNext()) {
            if (descs == null) {
                descs = new Vector<String>();
            }
            XmlParser.Node subNode = itr.next();
            String desc = subNode.toString(false, true);
            descs.addElement(desc);
        }
        String param_name = node.getString("param-name", false, true);
        String param_value = node.getString("param-value", false, true);
        Param cparam = new Param(descs, param_name, param_value);
        this.contextParams.addElement(cparam);
    }

    private void populateFilters(XmlParser.Node node) throws FormatErrorException {
        XmlParser.Node subNode;
        Vector<String> fDescs = null;
        Vector<String> fDispNms = null;
        Vector<Param> fIParams = null;
        Vector<Icon> fIcons = null;
        Iterator<XmlParser.Node> itr = node.iterator("description");
        while (itr.hasNext()) {
            if (fDescs == null) {
                fDescs = new Vector<String>();
            }
            subNode = itr.next();
            String desc = subNode.toString(false, true);
            fDescs.addElement(desc);
        }
        itr = node.iterator("display-name");
        while (itr.hasNext()) {
            if (fDispNms == null) {
                fDispNms = new Vector<String>();
            }
            subNode = itr.next();
            String dn = subNode.toString(false, true);
            fDispNms.addElement(dn);
        }
        itr = node.iterator("icon");
        while (itr.hasNext()) {
            if (fIcons == null) {
                fIcons = new Vector<Icon>();
            }
            subNode = itr.next();
            Icon icon = null;
            String small_icon = subNode.getString("small-icon", false, true);
            String large_icon = subNode.getString("large-icon", false, true);
            if (small_icon != null || large_icon != null) {
                icon = new Icon(small_icon, large_icon);
            }
            if (icon == null) continue;
            fIcons.addElement(icon);
        }
        itr = node.iterator("init-param");
        while (itr.hasNext()) {
            Vector<String> descs = null;
            if (fIParams == null) {
                fIParams = new Vector<Param>();
            }
            XmlParser.Node subNode2 = itr.next();
            Iterator<XmlParser.Node> subItr = subNode2.iterator("description");
            while (subItr.hasNext()) {
                if (descs == null) {
                    descs = new Vector<String>();
                }
                XmlParser.Node subNode1 = subItr.next();
                String desc = subNode1.toString(false, true);
                descs.addElement(desc);
            }
            String param_name = subNode2.getString("param-name", false, true);
            if (param_name == null) {
                throw new FormatErrorException("4108", "<param-name>\n<init-param>");
            }
            if (param_name.equals("")) {
                throw new FormatErrorException("4119", "<param-name>\n<init-param>");
            }
            String param_value = subNode2.getString("param-value", false, true);
            if (param_value == null) {
                throw new FormatErrorException("4108", "<param-value>\n<init-param>");
            }
            if (param_value.equals("")) {
                throw new FormatErrorException("4119", "<param-value>\n<init-param>");
            }
            Param iparam = new Param(descs, param_name, param_value);
            fIParams.addElement(iparam);
        }
        String filter_name = node.getString("filter-name", false, true);
        if (filter_name == null) {
            throw new FormatErrorException("4108", "<filter-name>\n<filter>");
        }
        if (filter_name.equals("")) {
            throw new FormatErrorException("4119", "<filter-name>\n<filter>");
        }
        for (Filter f : this.filters) {
            if (!f.getFilterName().equals(filter_name)) continue;
            throw new FormatErrorException("4120", filter_name + "\n" + "<filter-name>");
        }
        String filter_class = node.getString("filter-class", false, true);
        if (filter_class == null) {
            throw new FormatErrorException("4108", "<filter-class>\n<filter>");
        }
        if (filter_class.equals("")) {
            throw new FormatErrorException("4119", "<filter-class>\n<filter>");
        }
        Filter filter = new Filter(fDescs, fDispNms, fIcons, filter_name, filter_class, fIParams);
        this.filters.addElement(filter);
    }

    private void populateFilterMappings(XmlParser.Node node) throws FormatErrorException {
        String filter_name = node.getString("filter-name", false, true);
        if (filter_name == null) {
            throw new FormatErrorException("4108", "<filter-name>\n<filter-mapping>");
        }
        if (filter_name.equals("")) {
            throw new FormatErrorException("4119", "<filter-name>\n<filter-mapping>");
        }
        String url_pattern = node.getString("url-pattern", false, true);
        String servlet_name = node.getString("servlet-name", false, true);
        if (url_pattern == null && servlet_name == null) {
            throw new FormatErrorException("4108", "<url-pattern> or <servlet-name>\n<filter-mapping>");
        }
        if (url_pattern != null && url_pattern.equals("")) {
            throw new FormatErrorException("4119", "<url-pattern>\n<filter-mapping>");
        }
        if (servlet_name != null && servlet_name.equals("")) {
            throw new FormatErrorException("4119", "<servlet-name>\n<filter-mapping>");
        }
        FilterMapping mapping = new FilterMapping(filter_name, url_pattern, servlet_name);
        this.filterMappings.addElement(mapping);
    }

    private void populateListeners(XmlParser.Node node) throws FormatErrorException {
        XmlParser.Node subNode;
        Vector<String> lDescs = null;
        Vector<String> lDispNms = null;
        Vector<Icon> lIcons = null;
        Iterator<XmlParser.Node> itr = node.iterator("description");
        while (itr.hasNext()) {
            if (lDescs == null) {
                lDescs = new Vector<String>();
            }
            subNode = itr.next();
            String desc = subNode.toString(false, true);
            lDescs.addElement(desc);
        }
        itr = node.iterator("display-name");
        while (itr.hasNext()) {
            if (lDispNms == null) {
                lDispNms = new Vector<String>();
            }
            subNode = itr.next();
            String dn = subNode.toString(false, true);
            lDispNms.addElement(dn);
        }
        itr = node.iterator("icon");
        while (itr.hasNext()) {
            if (lIcons == null) {
                lIcons = new Vector<Icon>();
            }
            subNode = itr.next();
            Icon icon = null;
            String small_icon = subNode.getString("small-icon", false, true);
            String large_icon = subNode.getString("large-icon", false, true);
            if (small_icon != null || large_icon != null) {
                icon = new Icon(small_icon, large_icon);
            }
            if (icon == null) continue;
            lIcons.addElement(icon);
        }
        String lClass = node.getString("listener-class", false, true);
        if (lClass == null) {
            throw new FormatErrorException("4108", "<listener-class>\n<listener>");
        }
        if (lClass.equals("")) {
            throw new FormatErrorException("4119", "<listener-class>\n<listener>");
        }
        Listener listener = new Listener(lDescs, lDispNms, lIcons, lClass);
        this.listeners.addElement(listener);
    }

    private void populateServlets(XmlParser.Node node) throws FormatErrorException {
        String desc;
        XmlParser.Node subNode1;
        Iterator<XmlParser.Node> subItr;
        XmlParser.Node subNode;
        Vector<String> descs;
        XmlParser.Node subNode2;
        Vector<String> sDescs = null;
        Vector<String> sDispNms = null;
        Vector<Icon> sIcons = null;
        Vector<Param> sIParams = null;
        Vector<SecurityRoleRef> sSecRoleRefs = null;
        Iterator<XmlParser.Node> itr = node.iterator("description");
        while (itr.hasNext()) {
            if (sDescs == null) {
                sDescs = new Vector<String>();
            }
            subNode2 = itr.next();
            String desc2 = subNode2.toString(false, true);
            sDescs.addElement(desc2);
        }
        itr = node.iterator("display-name");
        while (itr.hasNext()) {
            if (sDispNms == null) {
                sDispNms = new Vector<String>();
            }
            subNode2 = itr.next();
            String dn = subNode2.toString(false, true);
            sDispNms.addElement(dn);
        }
        itr = node.iterator("icon");
        while (itr.hasNext()) {
            if (sIcons == null) {
                sIcons = new Vector<Icon>();
            }
            subNode2 = itr.next();
            Icon icon = null;
            String small_icon = subNode2.getString("small-icon", false, true);
            String large_icon = subNode2.getString("large-icon", false, true);
            if (small_icon != null || large_icon != null) {
                icon = new Icon(small_icon, large_icon);
            }
            if (icon == null) continue;
            sIcons.addElement(icon);
        }
        itr = node.iterator("init-param");
        while (itr.hasNext()) {
            descs = null;
            if (sIParams == null) {
                sIParams = new Vector<Param>();
            }
            subNode = itr.next();
            subItr = subNode.iterator("description");
            while (subItr.hasNext()) {
                if (descs == null) {
                    descs = new Vector<String>();
                }
                subNode1 = subItr.next();
                desc = subNode1.toString(false, true);
                descs.addElement(desc);
            }
            String param_name = subNode.getString("param-name", false, true);
            if (param_name == null) {
                throw new FormatErrorException("4108", "<param-name>\n<init-param>");
            }
            if (param_name.equals("")) {
                throw new FormatErrorException("4119", "<param-name>\n<init-param>");
            }
            String param_value = subNode.getString("param-value", false, true);
            if (param_value == null) {
                throw new FormatErrorException("4108", "<param-value>\n<init-param>");
            }
            if (param_value.equals("")) {
                throw new FormatErrorException("4119", "<param-value>\n<init-param>");
            }
            Param iparam = new Param(descs, param_name, param_value);
            sIParams.addElement(iparam);
        }
        itr = node.iterator("security-role-ref");
        while (itr.hasNext()) {
            descs = null;
            if (sSecRoleRefs == null) {
                sSecRoleRefs = new Vector<SecurityRoleRef>();
            }
            subNode = itr.next();
            subItr = subNode.iterator("description");
            while (subItr.hasNext()) {
                if (descs == null) {
                    descs = new Vector();
                }
                subNode1 = subItr.next();
                desc = subNode1.toString(false, true);
                descs.addElement(desc);
            }
            String role_name = subNode.getString("role-name", false, true);
            if (role_name == null) {
                throw new FormatErrorException("4108", "<role-name>\n<security-role-ref>");
            }
            if (role_name.equals("")) {
                throw new FormatErrorException("4119", "<role-name>\n<security-role-ref>");
            }
            String role_link = subNode.getString("role-link", false, true);
            if (role_link != null && role_link.equals("")) {
                throw new FormatErrorException("4119", "<role-link>\n<security-role-ref>");
            }
            SecurityRoleRef srole = new SecurityRoleRef(descs, role_name, role_link);
            sSecRoleRefs.addElement(srole);
        }
        String sName = node.getString("servlet-name", false, true);
        if (sName == null) {
            throw new FormatErrorException("4108", "<servlet-name>\n<servlet>");
        }
        if (sName.equals("")) {
            throw new FormatErrorException("4119", "<servlet-name>\n<servlet>");
        }
        for (Servlet s : this.servlets) {
            if (!s.getServletName().equals(sName)) continue;
            throw new FormatErrorException("4120", sName + "\n" + "<servlet-name>");
        }
        String sClass = node.getString("servlet-class", false, true);
        if (sClass == null) {
            throw new FormatErrorException("4108", "<servlet-class>\n<servlet>");
        }
        if (sClass.equals("")) {
            throw new FormatErrorException("4119", "<servlet-class>\n<servlet>");
        }
        String startup = node.getString("load-on-startup", false, true);
        int sOrder = 0;
        if (startup == null) {
            sOrder = Integer.MIN_VALUE;
        } else {
            try {
                sOrder = Integer.parseInt(startup);
            }
            catch (Exception e) {
                throw new FormatErrorException("4119", "<load-on-startup>\n<servlet>");
            }
        }
        Servlet servlet = new Servlet(sName, sClass, sOrder, sDispNms, sDescs, sIcons, sIParams, sSecRoleRefs);
        this.servlets.addElement(servlet);
    }

    private void populateServletMappings(XmlParser.Node node) throws FormatErrorException {
        String servlet_name = node.getString("servlet-name", false, true);
        if (servlet_name == null) {
            throw new FormatErrorException("4108", "<servlet-name>\n<servlet-mapping>");
        }
        if (servlet_name.equals("")) {
            throw new FormatErrorException("4119", "<servlet-name>\n<servlet-mapping>");
        }
        String url_pattern = node.getString("url-pattern", false, true);
        if (url_pattern == null) {
            throw new FormatErrorException("4108", "<url-pattern>\n<servlet-mapping>");
        }
        if (url_pattern.equals("")) {
            throw new FormatErrorException("4119", "<url-pattern>\n<servlet-mapping>");
        }
        ServletMapping mapping = new ServletMapping(servlet_name, url_pattern);
        this.servletMappings.addElement(mapping);
    }

    private void populateSessionConfig(XmlParser.Node node) throws FormatErrorException {
        XmlParser.Node tNode = node.get("session-timeout");
        if (tNode != null) {
            try {
                this.sessionTimeout = Integer.parseInt(tNode.toString(false, true));
            }
            catch (Exception e) {
                throw new FormatErrorException("4119", "<session-timeout>\n<session-config>");
            }
        }
    }

    private void populateMimeMappings(XmlParser.Node node) throws FormatErrorException {
        String extension = node.getString("extension", false, true);
        if (extension == null) {
            throw new FormatErrorException("4108", "<extension>\n<mime-mapping>");
        }
        if (extension.equals("")) {
            throw new FormatErrorException("4119", "<extension>\n<mime-mapping>");
        }
        String mime_type = node.getString("mime-type", false, true);
        if (mime_type == null) {
            throw new FormatErrorException("4108", "<mime-type>\n<mime-mapping>");
        }
        if (mime_type.equals("")) {
            throw new FormatErrorException("4119", "<mime-type>\n<mime-mapping>");
        }
        this.mimeMappings.put(extension, mime_type);
    }

    private void populateWelcomeFileList(XmlParser.Node node) throws FormatErrorException {
        Iterator<XmlParser.Node> itr = node.iterator("welcome-file");
        while (itr.hasNext()) {
            String wfile = itr.next().toString(false, true);
            if (wfile == null) {
                throw new FormatErrorException("4108", "<welcome-file>\n<welcome-file-list>");
            }
            if (wfile.equals("")) {
                throw new FormatErrorException("4119", "<welcome-file>\n<welcome-file-list>");
            }
            this.welcomeFileList.addElement(wfile);
        }
    }

    private void populateErrorPages(XmlParser.Node node) throws FormatErrorException {
        String location;
        String error_code = node.getString("error-code", false, true);
        String exception_type = node.getString("exception-type", false, true);
        int code = 0;
        if (error_code == null && exception_type == null) {
            throw new FormatErrorException("4108", "<error-code> or <exception-type>\n<error-page>");
        }
        if (error_code == null && exception_type != null && exception_type.equals("")) {
            throw new FormatErrorException("4119", "<exception-type>\n<error-page>");
        }
        if (error_code != null && exception_type == null) {
            try {
                code = Integer.parseInt(error_code);
            }
            catch (Exception e) {
                throw new FormatErrorException("4119", "<error-code>\n<error-page>");
            }
            if (code < 100 || code > 999) {
                throw new FormatErrorException("4119", "<error-code>\n<error-page>");
            }
        }
        if ((location = node.getString("location", false, true)) == null) {
            throw new FormatErrorException("4108", "<location>\n<error-page>");
        }
        if (location.equals("") || !location.startsWith("/")) {
            throw new FormatErrorException("4119", "<location>\n<error-page>");
        }
        ErrorPage errPage = new ErrorPage(code, exception_type, location);
        this.errorPages.addElement(errPage);
    }

    private void populateSecurityConstraints(XmlParser.Node node) throws FormatErrorException {
        Vector<String> scDisplNames = null;
        Vector<WebResourceCollection> wrColls = null;
        Vector<AuthConstraint> aConstraints = null;
        Vector<UserDataConstraint> udConstraints = new Vector<UserDataConstraint>();
        Iterator<XmlParser.Node> itr = node.iterator("display-name");
        while (itr.hasNext()) {
            if (scDisplNames == null) {
                scDisplNames = new Vector<String>();
            }
            XmlParser.Node subNode = itr.next();
            String displName = subNode.toString(false, true);
            scDisplNames.addElement(displName);
        }
        itr = node.iterator("web-resource-collection");
        if (!itr.hasNext()) {
            throw new FormatErrorException("4108", "<web-resource-collection>\n<" + node.getTag() + ">");
        }
        while (itr.hasNext()) {
            XmlParser.Node subNode1;
            if (wrColls == null) {
                wrColls = new Vector<WebResourceCollection>();
            }
            Vector<String> wrDescs = null;
            Vector<String> urlPatterns = null;
            Vector<String> httpMethods = null;
            XmlParser.Node subNode = itr.next();
            String rscName = subNode.getString("web-resource-name", false, true);
            if (rscName == null) {
                throw new FormatErrorException("4108", "<web-resource-name>\n<web-resource-collection>");
            }
            if (rscName.equals("")) {
                throw new FormatErrorException("4119", "<web-resource-name>\n<web-resource-collection>");
            }
            Iterator<XmlParser.Node> subItr = subNode.iterator("description");
            while (subItr.hasNext()) {
                if (wrDescs == null) {
                    wrDescs = new Vector<String>();
                }
                subNode1 = subItr.next();
                String desc = subNode1.toString(false, true);
                wrDescs.addElement(desc);
            }
            subItr = subNode.iterator("url-pattern");
            if (!subItr.hasNext()) {
                throw new FormatErrorException("4108", "<url-pattern>\n<web-resource-collection>");
            }
            while (subItr.hasNext()) {
                String url;
                if (urlPatterns == null) {
                    urlPatterns = new Vector<String>();
                }
                if ((url = (subNode1 = subItr.next()).toString(false, true)).equals("")) {
                    throw new FormatErrorException("4119", "<url-pattern>\n<web-resource-collection>");
                }
                urlPatterns.addElement(url);
            }
            subItr = subNode.iterator("http-method");
            while (subItr.hasNext()) {
                String method;
                if (httpMethods == null) {
                    httpMethods = new Vector<String>();
                }
                if ((method = (subNode1 = subItr.next()).toString(false, true)).equals("")) {
                    throw new FormatErrorException("4119", "<http-method>\n<web-resource-collection>");
                }
                httpMethods.addElement(method);
            }
            WebResourceCollection wec = new WebResourceCollection(rscName, wrDescs, urlPatterns, httpMethods);
            wrColls.addElement(wec);
        }
        itr = node.iterator("auth-constraint");
        while (itr.hasNext()) {
            XmlParser.Node subNode1;
            if (aConstraints == null) {
                aConstraints = new Vector<AuthConstraint>();
            }
            Vector<String> authConstrDescs = null;
            Vector<String> roleNames = null;
            XmlParser.Node subNode = itr.next();
            Iterator<XmlParser.Node> subItr = subNode.iterator("description");
            while (subItr.hasNext()) {
                if (authConstrDescs == null) {
                    authConstrDescs = new Vector<String>();
                }
                subNode1 = subItr.next();
                String desc = subNode1.toString(false, true);
                authConstrDescs.addElement(desc);
            }
            subItr = subNode.iterator("role-name");
            while (subItr.hasNext()) {
                String rName;
                if (roleNames == null) {
                    roleNames = new Vector<String>();
                }
                if ((rName = (subNode1 = subItr.next()).toString(false, true)).equals("")) {
                    throw new FormatErrorException("4119", "<role-name>\n<auth-constraint>");
                }
                roleNames.addElement(rName);
            }
            AuthConstraint authConstr = new AuthConstraint(authConstrDescs, roleNames);
            aConstraints.addElement(authConstr);
        }
        itr = node.iterator("user-data-constraint");
        while (itr.hasNext()) {
            if (udConstraints == null) {
                udConstraints = new Vector();
            }
            Vector<String> uDataDescs = null;
            XmlParser.Node subNode = itr.next();
            Iterator<XmlParser.Node> subItr = subNode.iterator("description");
            while (subItr.hasNext()) {
                if (uDataDescs == null) {
                    uDataDescs = new Vector<String>();
                }
                XmlParser.Node subNode1 = subItr.next();
                String desc = subNode1.toString(false, true);
                uDataDescs.addElement(desc);
            }
            String transport = subNode.getString("transport-guarantee", false, true);
            if (transport == null) {
                throw new FormatErrorException("4108", "<transport-guarantee>\n<user-data-constraint>");
            }
            if (!(transport.equalsIgnoreCase("NONE") || transport.equalsIgnoreCase("INTEGRAL") || transport.equalsIgnoreCase("CONFIDENTIAL"))) {
                throw new FormatErrorException("4119", "<transport-guarantee>\n<user-data-constraint>");
            }
            if (transport.equalsIgnoreCase("INTEGRAL")) {
                this.isIntegrityRequired = true;
            }
            if (transport.equalsIgnoreCase("CONFIDENTIAL")) {
                this.isConfidentialityRequired = true;
            }
            UserDataConstraint usrdataConstr = new UserDataConstraint(uDataDescs, transport);
            udConstraints.addElement(usrdataConstr);
        }
        SecurityConstraint secConstraint = new SecurityConstraint(scDisplNames, wrColls, aConstraints, udConstraints);
        this.securityConstraints.addElement(secConstraint);
    }

    private void populateLoginConfig(XmlParser.Node node) throws FormatErrorException {
        String realm_name;
        FormLoginConfig form = null;
        String auth_method = node.getString("auth-method", false, true);
        if (auth_method != null) {
            if (auth_method.equals("")) {
                throw new FormatErrorException("4119", "<auth-method>\n<login-config>");
            }
            if (!(auth_method.equals("BASIC") || auth_method.equals("FORM") || auth_method.equals("DIGEST") || auth_method.startsWith("JC-"))) {
                throw new FormatErrorException("4119", "<auth-method>\n<login-config>");
            }
        }
        if ((realm_name = node.getString("realm-name", false, true)) != null && realm_name.equals("")) {
            throw new FormatErrorException("4119", "<realm-name>\n<login-config>");
        }
        Iterator<XmlParser.Node> itr = node.iterator("form-login-config");
        while (itr.hasNext()) {
            XmlParser.Node subNode = itr.next();
            String login_page = subNode.getString("form-login-page", false, true);
            if (login_page == null) {
                throw new FormatErrorException("4108", "<form-login-page>\n<form-login-config>");
            }
            if (login_page.equals("")) {
                throw new FormatErrorException("4119", "<form-login-page>\n<form-login-config>");
            }
            String error_page = subNode.getString("form-error-page", false, true);
            if (error_page == null) {
                throw new FormatErrorException("4108", "<form-error-page>\n<form-login-config>");
            }
            if (error_page.equals("")) {
                throw new FormatErrorException("4119", "<form-error-page>\n<form-login-config>");
            }
            form = new FormLoginConfig(login_page, error_page);
        }
        LoginConfig loginConf = new LoginConfig(auth_method, realm_name, form);
        this.loginConfigs.addElement(loginConf);
    }

    private void populateSecurityRoles(XmlParser.Node node) throws FormatErrorException {
        Vector<String> descs = null;
        Iterator<XmlParser.Node> itr = node.iterator("description");
        while (itr.hasNext()) {
            if (descs == null) {
                descs = new Vector<String>();
            }
            XmlParser.Node subNode = itr.next();
            String desc = subNode.toString(false, true);
            descs.addElement(desc);
        }
        String role_name = node.getString("role-name", false, true);
        if (role_name == null) {
            throw new FormatErrorException("4108", "<role-name>\n<security-role>");
        }
        if (role_name.equals("")) {
            throw new FormatErrorException("4119", "<role-name>\n<security-role>");
        }
        SecurityRole sr = new SecurityRole(descs, role_name);
        this.securityRoles.addElement(sr);
    }

    private void populateLocaleEncodingMappingList(XmlParser.Node node) throws FormatErrorException {
        Iterator<XmlParser.Node> itr = node.iterator("locale-encoding-mapping");
        while (itr.hasNext()) {
            XmlParser.Node subNode = itr.next();
            String locale = subNode.getString("locale", false, true);
            if (locale == null) {
                throw new FormatErrorException("4108", "<locale>\n<locale-encoding-mapping>");
            }
            if (locale.equals("")) {
                throw new FormatErrorException("4119", "<locale>\n<locale-encoding-mapping>");
            }
            String encoding = subNode.getString("encoding", false, true);
            if (encoding == null) {
                throw new FormatErrorException("4108", "<encoding>\n<locale-encoding-mapping>");
            }
            if (encoding.equals("")) {
                throw new FormatErrorException("4119", "<encoding>\n<locale-encoding-mapping>");
            }
            LocaleEncodingMapping locEncMapping = new LocaleEncodingMapping(locale, encoding);
            this.localeEncodingMappingList.addElement(locEncMapping);
        }
    }

    public Vector<String> getDisplayNames() {
        return this.displayNames;
    }

    public Vector<String> getDescriptions() {
        return this.descriptions;
    }

    public Vector<Icon> getIcons() {
        return this.icons;
    }

    public Vector<Servlet> getServlets() {
        return this.servlets;
    }

    public Vector<String> getServletClasses() {
        Vector<String> servletClasses = null;
        if (this.servlets != null) {
            servletClasses = new Vector<String>();
            for (Servlet s : this.servlets) {
                servletClasses.addElement(s.getServletClass());
            }
        }
        return servletClasses;
    }

    public Vector<Filter> getFilters() {
        return this.filters;
    }

    public Vector<String> getFilterClasses() {
        Vector<String> filterClasses = null;
        if (this.filters != null) {
            filterClasses = new Vector<String>();
            for (Filter f : this.filters) {
                filterClasses.addElement(f.getFilterClass());
            }
        }
        return filterClasses;
    }

    public Vector<FilterMapping> getFilterMappings() {
        return this.filterMappings;
    }

    public Vector<Listener> getListeners() {
        return this.listeners;
    }

    public Vector<String> getListenerClasses() {
        if (this.listeners == null) {
            return null;
        }
        Vector<String> classes = new Vector<String>();
        for (Listener listnr : this.listeners) {
            classes.addElement(listnr.getListenerClass());
        }
        return classes;
    }

    public Vector<ServletMapping> getServletMappings() {
        return this.servletMappings;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public Hashtable<String, String> getMimeMappings() {
        return this.mimeMappings;
    }

    public Vector<Param> getContextParams() {
        return this.contextParams;
    }

    public Vector<String> getWelcomeFileList() {
        return this.welcomeFileList;
    }

    public Vector<ErrorPage> getErrorPages() {
        return this.errorPages;
    }

    public boolean isIntegrityRequired() {
        return this.isIntegrityRequired;
    }

    public boolean isConfidentialityRequired() {
        return this.isConfidentialityRequired;
    }

    public Vector<SecurityConstraint> getSecurityConstraints() {
        return this.securityConstraints;
    }

    public Vector<LoginConfig> getLoginConfigs() {
        return this.loginConfigs;
    }

    public Vector<SecurityRole> getSecurityRoles() {
        return this.securityRoles;
    }

    public Vector<String> getSecurityRoleNames() {
        Vector<String> all = null;
        if (this.securityRoles != null) {
            for (SecurityRole sr : this.securityRoles) {
                if (all == null) {
                    all = new Vector<String>();
                }
                String rName = sr.getRoleName();
                all.addElement(rName);
            }
        }
        return all;
    }

    public Vector<String> getAuthConstraintsRoles() {
        Vector<String> all = null;
        if (this.securityConstraints != null) {
            for (SecurityConstraint sc : this.securityConstraints) {
                Vector<String> acRoles = sc.getAuthConstraintRoles();
                if (acRoles == null) continue;
                if (all == null) {
                    all = new Vector<String>();
                }
                for (String rName : acRoles) {
                    all.addElement(rName);
                }
            }
        }
        return all;
    }

    public Vector<LocaleEncodingMapping> getLocaleEncodingMappingList() {
        return this.localeEncodingMappingList;
    }

    public Vector<String> getClassesToLoad() {
        Vector<String> classesToLoad = new Vector<String>();
        if (this.servlets != null) {
            for (Servlet aServlet : this.servlets) {
                classesToLoad.addElement(aServlet.getServletClass());
            }
        }
        if (this.filters != null) {
            for (Filter aFilter : this.filters) {
                classesToLoad.addElement(aFilter.getFilterClass());
            }
        }
        if (this.listeners != null) {
            for (Listener aListener : this.listeners) {
                classesToLoad.addElement(aListener.getListenerClass());
            }
        }
        return classesToLoad;
    }
}

