/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.implBiometry;

import com.sun.javacard.Logger;
import com.sun.javacard.impl.NativeMethods;
import java.io.UnsupportedEncodingException;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacardx.biometry.BioException;
import javacardx.biometry.OwnerBioTemplate;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.servlet.http.HttpDigestAuthentication;
import org.mortbay.jetty.security.DigestAuthenticator;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class PasswordBioImpl
implements OwnerBioTemplate,
HttpDigestAuthentication {
    private byte[] passwd;
    private byte[] tryLimit = new byte[1];
    private byte origTryLimit;
    public static final byte MIN_PASSWD_LEN = 1;
    public static final byte MAX_PASSWD_LEN = 50;
    private boolean[] validatedAndInitCalled;
    private byte dataLenEnrolled;
    private byte[] matchDataLen;
    private boolean initialized;

    public PasswordBioImpl(byte tryL) {
        this.tryLimit[0] = tryL;
        this.origTryLimit = tryL;
        this.initialized = false;
        this.validatedAndInitCalled = JCSystem.makeTransientBooleanArray((short)3, (byte)1);
        this.validatedAndInitCalled[0] = false;
        this.validatedAndInitCalled[1] = false;
        this.validatedAndInitCalled[2] = false;
        this.matchDataLen = JCSystem.makeTransientByteArray((short)1, (byte)1);
        this.passwd = new byte[50];
    }

    @Override
    public void init(byte[] bArray, short offset, short length) throws BioException {
        if (length < 0 || length > 50) {
            BioException.throwIt((short)2);
        }
        Logger.debug("PWD IMPL ----1");
        NativeMethods.checkArrayArgs(bArray, offset, length);
        Logger.debug("PWD IMPL ----2");
        this.initialized = false;
        this.validatedAndInitCalled[0] = false;
        this.validatedAndInitCalled[1] = true;
        this.validatedAndInitCalled[2] = false;
        Logger.debug("PWD IMPL ----3");
        Util.arrayCopy(bArray, offset, this.passwd, (short)0, length);
        Logger.debug("PWD IMPL ----4");
        this.dataLenEnrolled = (byte)length;
    }

    @Override
    public void update(byte[] bArray, short offset, short length) throws BioException {
        if (!this.validatedAndInitCalled[1]) {
            BioException.throwIt((short)5);
        }
        if (this.dataLenEnrolled + (byte)length > 50) {
            BioException.throwIt((short)2);
        }
        Util.arrayCopy(bArray, offset, this.passwd, this.dataLenEnrolled, length);
        this.dataLenEnrolled = (byte)(this.dataLenEnrolled + length);
    }

    @Override
    public void doFinal() throws BioException {
        if (!this.validatedAndInitCalled[1]) {
            BioException.throwIt((short)5);
        }
        if (this.dataLenEnrolled < 1) {
            BioException.throwIt((short)2);
        }
        this.validatedAndInitCalled[1] = false;
        this.initialized = true;
    }

    @Override
    public byte getBioType() {
        return 31;
    }

    @Override
    public short getVersion(byte[] dest, short offset) {
        NativeMethods.checkArrayArgs(dest, offset, (short)3);
        short s = offset;
        offset = (short)(offset + 1);
        dest[s] = 1;
        short s2 = offset;
        offset = (short)(offset + 1);
        dest[s2] = 0;
        dest[offset] = 0;
        return 3;
    }

    @Override
    public short getPublicTemplateData(short publicOffset, byte[] dest, short destOffset, short length) throws BioException {
        if (!this.initialized) {
            BioException.throwIt((short)4);
        }
        if (length < 4) {
            BioException.throwIt((short)1);
        }
        NativeMethods.checkArrayArgs(dest, destOffset, (short)4);
        this.getVersion(dest, destOffset);
        dest[(short)(destOffset + 3)] = (byte)this.passwd.length;
        return 4;
    }

    @Override
    public byte getTriesRemaining() {
        return this.tryLimit[0];
    }

    @Override
    public short initMatch(byte[] candidate, short offset, short length) throws BioException {
        if (!this.initialized) {
            BioException.throwIt((short)4);
        }
        if (this.tryLimit[0] == 0) {
            return 0;
        }
        Util.arrayFillNonAtomic(this.tryLimit, (short)0, (short)1, (byte)(this.tryLimit[0] - 1));
        NativeMethods.checkArrayArgs(candidate, offset, length);
        this.validatedAndInitCalled[0] = false;
        if (length > this.dataLenEnrolled) {
            return 0;
        }
        this.matchDataLen[0] = (byte)length;
        if (Util.arrayCompare(this.passwd, (short)0, candidate, offset, length) != 0) {
            return 0;
        }
        if (length < this.dataLenEnrolled) {
            this.validatedAndInitCalled[2] = true;
            return -1;
        }
        this.validatedAndInitCalled[0] = true;
        Util.arrayFillNonAtomic(this.tryLimit, (short)0, (short)1, this.origTryLimit);
        return 16384;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isValidated() {
        return this.validatedAndInitCalled[0];
    }

    @Override
    public short match(byte[] candidate, short offset, short length) throws BioException {
        if (!this.validatedAndInitCalled[2]) {
            BioException.throwIt((short)5);
        }
        if (this.matchDataLen[0] + length > this.dataLenEnrolled) {
            this.validatedAndInitCalled[2] = false;
            return 0;
        }
        if (Util.arrayCompare(this.passwd, this.matchDataLen[0], candidate, offset, length) != 0) {
            this.validatedAndInitCalled[2] = false;
            return 0;
        }
        if (this.matchDataLen[0] + length == this.dataLenEnrolled) {
            this.validatedAndInitCalled[0] = true;
            this.validatedAndInitCalled[2] = false;
            Util.arrayFillNonAtomic(this.tryLimit, (short)0, (short)1, this.origTryLimit);
            return 16384;
        }
        this.matchDataLen[0] = (byte)(this.matchDataLen[0] + length);
        return -1;
    }

    @Override
    public void reset() {
        this.validatedAndInitCalled[0] = false;
    }

    @Override
    public void resetUnblockAndSetTryLimit(byte newTryLimit) throws BioException {
        if (newTryLimit < 1) {
            BioException.throwIt((short)1);
        }
        this.validatedAndInitCalled[0] = false;
        this.tryLimit[0] = newTryLimit;
        this.origTryLimit = newTryLimit;
    }

    @Override
    public boolean check(String username, String realm, String method, String uri, String nonce, String nc, String cnonce, String qop, String response) {
        String str;
        if (!this.initialized) {
            return false;
        }
        if (this.tryLimit[0] == 0) {
            return false;
        }
        Util.arrayFillNonAtomic(this.tryLimit, (short)0, (short)1, (byte)(this.tryLimit[0] - 1));
        this.validatedAndInitCalled[0] = false;
        DigestAuthenticator.Digest digest = new DigestAuthenticator.Digest(username, realm, method, uri, nonce, nc, cnonce, qop, response);
        try {
            str = new String(this.passwd, 0, this.dataLenEnrolled, "ISO8859_1");
        }
        catch (UnsupportedEncodingException uee) {
            throw new Error("Default ISO-8859-1 encoding not supported.");
        }
        if (!digest.check(str)) {
            return false;
        }
        this.validatedAndInitCalled[0] = true;
        Util.arrayFillNonAtomic(this.tryLimit, (short)0, (short)1, this.origTryLimit);
        return true;
    }
}

