/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.security;

import javacard.framework.Shareable;
import javacardx.biometry.BioBuilder;
import javacardx.biometry.BioException;
import javacardx.biometry.OwnerBioTemplate;
import javacardx.facilities.ServiceFactory;
import javacardx.framework.SharedPINAuth;
import javacardx.framework.SharedPasswordAuth;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.servlet.http.HttpDigestAuthentication;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public class PasswordGlobalAuthenticatorFactory
implements ServiceFactory {
    private final OwnerBioTemplate ownerPassword;
    private final GlobalPasswordAuth auth;

    public PasswordGlobalAuthenticatorFactory(String password, int tryLimit) {
        this.ownerPassword = BioBuilder.buildBioTemplate((byte)31, (byte)tryLimit);
        byte[] pwdBytes = password.getBytes();
        this.ownerPassword.init(pwdBytes, (short)0, (byte)pwdBytes.length);
        this.ownerPassword.doFinal();
        this.auth = new GlobalPasswordAuth();
    }

    @Override
    public Shareable create(String serviceURI, Object parameter) throws SecurityException {
        if (serviceURI.startsWith("sio:///standard/auth/holder/global/") && (serviceURI.endsWith("/password") || serviceURI.endsWith("/pin"))) {
            return this.auth;
        }
        return null;
    }

    public OwnerBioTemplate getOwnerPassword() {
        return this.ownerPassword;
    }

    @TransactionType(value=TransactionTypeValue.SUPPORTS)
    private class GlobalPasswordAuth
    implements SharedPasswordAuth,
    SharedPINAuth,
    HttpDigestAuthentication {
        private GlobalPasswordAuth() {
        }

        @Override
        @TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
        public synchronized boolean check(String password) {
            byte[] pwdBytes = password.getBytes();
            return this.check(pwdBytes, (short)0, (byte)pwdBytes.length);
        }

        @Override
        @TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
        public boolean check(String username, String realm, String method, String uri, String nonce, String nc, String cnonce, String qop, String response) {
            if (PasswordGlobalAuthenticatorFactory.this.ownerPassword instanceof HttpDigestAuthentication) {
                return ((HttpDigestAuthentication)((Object)PasswordGlobalAuthenticatorFactory.this.ownerPassword)).check(username, realm, method, uri, nonce, nc, cnonce, qop, response);
            }
            return false;
        }

        @Override
        @TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
        public boolean check(byte[] pin, short offset, byte length) throws ArrayIndexOutOfBoundsException, NullPointerException {
            try {
                PasswordGlobalAuthenticatorFactory.this.ownerPassword.initMatch(pin, offset, length);
            }
            catch (BioException be) {
                // empty catch block
            }
            return PasswordGlobalAuthenticatorFactory.this.ownerPassword.isValidated();
        }

        @Override
        public synchronized byte getTriesRemaining() {
            return PasswordGlobalAuthenticatorFactory.this.ownerPassword.getTriesRemaining();
        }

        @Override
        public synchronized boolean isValidated() {
            return PasswordGlobalAuthenticatorFactory.this.ownerPassword.isValidated();
        }

        @Override
        @TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
        public synchronized void reset() {
            PasswordGlobalAuthenticatorFactory.this.ownerPassword.reset();
        }
    }
}

