/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.spi.security;

import com.sun.javacard.PermissionsParser;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.jcre.JCRuntime;
import com.sun.javacard.security.PermissionSet;
import com.sun.javacard.spi.cardmgmt.ApplicationGroup;
import java.security.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import javacardx.facilities.EventRegistryPermission;
import javacardx.facilities.ServiceRegistryPermission;
import javacardx.facilities.TaskRegistryPermission;
import javacardx.framework.ContextPermission;
import javacardx.framework.JCRuntimePermission;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.io.ConnectorPermission;
import javacardx.security.CryptoServicePermission;
import javacardx.security.NamedPermission;
import javacardx.security.URIPermission;
import javacardx.spi.cardmgmt.CardManagementPermission;
import javacardx.spi.framework.JCREPermission;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public final class ProtectionDomain {
    PermissionSet excludedPermissions;
    PermissionSet permissions;
    private PermissionSet effectivePermissionSet = null;
    public static final String DEFAULT_CARD_MANAGEMENT_DOMAIN_ALIAS = "CardManagement";
    public static final String DEFAULT_CLASSIC_DOMAIN_ALIAS = "Classic";
    public static final String DEFAULT_EXTENDED_DOMAIN_ALIAS = "Extended";
    public static final String DEFAULT_WEB_DOMAIN_ALIAS = "Web";
    static final Hashtable<String, ProtectionDomain> PLATFORM_POLICY_DOMAINS = new Hashtable(4);
    private static final Permission[] EXCLUDED_WEB_PERMISSIONS = new Permission[]{new JCREPermission("callTempJCREEPO.*")};
    private static Permission[] EXCLUDED_EXTENDED_PERMISSIONS = new Permission[0];
    private static Permission[] EXCLUDED_CLASSIC_PERMISSIONS = new Permission[]{new JCREPermission("callPermJCREEPO.EXTENDED"), new ContextPermission("//*/*", "transfer"), new JCRuntimePermission("credentialManager.*"), new JCRuntimePermission("thread.*")};
    private static final Permission[] EXCLUDED_CARDMANAGEMENT_PERMISSIONS = new Permission[0];
    private String name;
    private ProtectionDomain platformDomain;
    private boolean readOnly = false;
    private ApplicationGroup applicationGroup = null;

    public static void initializePlatformPolicy() {
        if (PLATFORM_POLICY_DOMAINS.size() > 0) {
            throw new IllegalStateException("Platform Policy already initialized.");
        }
        Permission includedPermission = null;
        ProtectionDomain webDomain = new ProtectionDomain(DEFAULT_WEB_DOMAIN_ALIAS);
        for (int i = 0; i < Integer.MAX_VALUE && (includedPermission = PermissionsParser.parsePermissionString(JCRuntime.getConfigProperty("webDomain.include." + i, null))) != null; ++i) {
            webDomain.addToIncludedSet(includedPermission);
        }
        for (Permission excludedPermission : EXCLUDED_WEB_PERMISSIONS) {
            webDomain.addToExcludedSet(excludedPermission);
        }
        webDomain.setReadOnly();
        ProtectionDomain extendedDomain = new ProtectionDomain(DEFAULT_EXTENDED_DOMAIN_ALIAS);
        for (int i = 0; i < Integer.MAX_VALUE && (includedPermission = PermissionsParser.parsePermissionString(JCRuntime.getConfigProperty("extendedDomain.include." + i, null))) != null; ++i) {
            extendedDomain.addToIncludedSet(includedPermission);
        }
        for (Permission excludedPermission : EXCLUDED_EXTENDED_PERMISSIONS) {
            extendedDomain.addToExcludedSet(excludedPermission);
        }
        extendedDomain.setReadOnly();
        ProtectionDomain classicDomain = new ProtectionDomain(DEFAULT_CLASSIC_DOMAIN_ALIAS);
        for (int i = 0; i < Integer.MAX_VALUE && (includedPermission = PermissionsParser.parsePermissionString(JCRuntime.getConfigProperty("classicDomain.include." + i, null))) != null; ++i) {
            classicDomain.addToIncludedSet(includedPermission);
        }
        for (Permission excludedPermission : EXCLUDED_CLASSIC_PERMISSIONS) {
            classicDomain.addToExcludedSet(excludedPermission);
        }
        classicDomain.setReadOnly();
        ProtectionDomain cardManagementDomain = new ProtectionDomain(DEFAULT_CARD_MANAGEMENT_DOMAIN_ALIAS);
        for (int i = 0; i < Integer.MAX_VALUE && (includedPermission = PermissionsParser.parsePermissionString(JCRuntime.getConfigProperty("cmDomain.include." + i, null))) != null; ++i) {
            cardManagementDomain.addToIncludedSet(includedPermission);
        }
        for (Permission excludedPermission : EXCLUDED_CARDMANAGEMENT_PERMISSIONS) {
            cardManagementDomain.addToExcludedSet(excludedPermission);
        }
        cardManagementDomain.setReadOnly();
    }

    public static final ProtectionDomain createProtectionDomain(String name, String platformDomainAlias) {
        short currentContext = NativeMethods.getCurrentContext();
        byte currentAppId = NativeMethods.getCurrentAppId();
        NativeMethods.switchContext(0, 0);
        ProtectionDomain domain = new ProtectionDomain(name, platformDomainAlias);
        NativeMethods.setJCREentry(domain, false);
        NativeMethods.switchContext(currentContext, currentAppId);
        return domain;
    }

    private ProtectionDomain(String name) {
        if (name.equals("")) {
            throw new IllegalArgumentException("Illegal protection domain name.");
        }
        this.name = name;
        this.excludedPermissions = new PermissionSet();
        this.permissions = new PermissionSet();
        PLATFORM_POLICY_DOMAINS.put(name, this);
    }

    private ProtectionDomain(String name, String platformDomainAlias) {
        if (name == null || platformDomainAlias == null) {
            throw new NullPointerException();
        }
        if ((name = new String(name)).equals("")) {
            throw new IllegalArgumentException("Illegal protection domain name.");
        }
        this.platformDomain = PLATFORM_POLICY_DOMAINS.get(platformDomainAlias);
        if (this.platformDomain == null) {
            throw new IllegalArgumentException();
        }
        if (PLATFORM_POLICY_DOMAINS.containsKey(name)) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.excludedPermissions = new PermissionSet();
        this.permissions = new PermissionSet();
    }

    public void add(Permission permission) {
        if (permission != null) {
            NativeMethods.checkPreviousContextAccess(permission);
        }
        Permission permissionToAdd = null;
        if (this.readOnly) {
            throw new SecurityException();
        }
        if (!this.checkValidPermission(permission, false)) {
            throw new IllegalArgumentException();
        }
        if (this.platformDomain != null && !this.platformDomain.excludedPermissions.isEmpty() && this.platformDomain.excludedPermissions.implies(permission)) {
            throw new SecurityException();
        }
        if (permission instanceof JCREPermission) {
            permissionToAdd = new JCREPermission(new String(permission.getName()));
        } else if (permission instanceof CryptoServicePermission) {
            permissionToAdd = new CryptoServicePermission(new String(permission.getName()));
        } else if (permission instanceof CardManagementPermission) {
            permissionToAdd = new CardManagementPermission(new String(permission.getName()));
        } else if (permission instanceof NamedPermission) {
            permissionToAdd = new NamedPermission(new String(permission.getName()));
        } else if (permission instanceof JCRuntimePermission) {
            permissionToAdd = new JCRuntimePermission(new String(permission.getName()));
        } else if (permission instanceof TaskRegistryPermission) {
            permissionToAdd = new TaskRegistryPermission(new String(permission.getName()));
        } else if (permission instanceof ServiceRegistryPermission) {
            permissionToAdd = new ServiceRegistryPermission(new String(permission.getName()), new String(permission.getActions()));
        } else if (permission instanceof ContextPermission) {
            permissionToAdd = new ContextPermission(new String(permission.getName()), new String(permission.getActions()));
        } else if (permission instanceof EventRegistryPermission) {
            permissionToAdd = new EventRegistryPermission(new String(permission.getName()), new String(permission.getActions()));
        } else if (permission instanceof ConnectorPermission) {
            permissionToAdd = new ConnectorPermission(new String(permission.getName()), new String(permission.getActions()));
        }
        this.effectivePermissionSet = null;
        this.permissions.add(permissionToAdd);
    }

    private void addToIncludedSet(Permission permission) {
        if (this.readOnly) {
            throw new SecurityException();
        }
        if (this.platformDomain == null) {
            if (!this.checkValidPermission(permission, true)) {
                throw new IllegalArgumentException();
            }
            this.effectivePermissionSet = null;
            this.permissions.add(permission);
        }
    }

    private void addToExcludedSet(Permission permission) {
        if (this.readOnly) {
            throw new SecurityException();
        }
        if (this.platformDomain == null) {
            if (!this.checkValidPermission(permission, true)) {
                throw new IllegalArgumentException();
            }
            this.excludedPermissions.add(permission);
        }
    }

    public Enumeration<Permission> elements() {
        return this.permissions.elements();
    }

    public String getName() {
        String s = new String(this.name);
        NativeMethods.transferOwnershipToPreviousContext(s);
        return s;
    }

    public boolean implies(Permission permission) {
        if (permission != null) {
            NativeMethods.checkPreviousContextAccess(permission);
        }
        if (!this.checkValidPermission(permission, true)) {
            return false;
        }
        if (this.platformDomain != null) {
            if (this.effectivePermissionSet == null) {
                this.effectivePermissionSet = new PermissionSet(this.platformDomain.permissions);
                this.effectivePermissionSet.add(this.permissions);
            }
            if (!this.effectivePermissionSet.implies(permission)) {
                return false;
            }
            if (this.platformDomain.excludedPermissions.implies(permission)) {
                return false;
            }
        } else {
            if (!this.permissions.implies(permission)) {
                return false;
            }
            if (this.excludedPermissions.implies(permission)) {
                return false;
            }
        }
        return true;
    }

    public boolean isBoundToDomain(String name) {
        if (name != null) {
            NativeMethods.checkPreviousContextAccess(name);
        }
        return this.name != null && this.name.equals(name) || this.platformDomain != null && this.platformDomain.name.equals(name);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean remove(Permission permission) {
        if (permission != null) {
            NativeMethods.checkPreviousContextAccess(permission);
        }
        if (this.readOnly) {
            throw new SecurityException();
        }
        this.effectivePermissionSet = null;
        return this.permissions.remove(permission);
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public ApplicationGroup getApplicationGroup() {
        return this.applicationGroup;
    }

    public void setApplicationGroup(ApplicationGroup applicationGroup) {
        if (this.applicationGroup != null) {
            throw new IllegalStateException();
        }
        this.applicationGroup = applicationGroup;
    }

    private boolean checkValidPermission(Permission permission, boolean completeSet) {
        Class<?> pClass = permission.getClass();
        if (completeSet && pClass == JCREPermission.class) {
            return true;
        }
        return pClass == URIPermission.class || pClass == ContextPermission.class || pClass == ConnectorPermission.class || pClass == ServiceRegistryPermission.class || pClass == EventRegistryPermission.class || pClass == NamedPermission.class || pClass == CardManagementPermission.class || pClass == TaskRegistryPermission.class || pClass == CryptoServicePermission.class || pClass == JCRuntimePermission.class;
    }
}

