/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.ssl;

import com.sun.cldc.io.ConnectionBaseInterface;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.util.JCSystemAccessor;
import com.sun.midp.io.HttpUrl;
import com.sun.midp.io.j2me.serversocket.SSLSocket;
import com.sun.midp.ssl.SSLStreamConnection;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javacardx.framework.JCSystem;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javax.microedition.io.Connection;
import javax.microedition.io.SecureConnection;
import javax.microedition.io.SecurityInfo;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class Protocol
implements SecureConnection,
ConnectionBaseInterface {
    private com.sun.midp.io.j2me.socket.Protocol tcpConnection;
    private SSLStreamConnection sslConnection;

    public Protocol() {
    }

    public Protocol(com.sun.midp.io.j2me.socket.Protocol con, String appURI) throws IOException {
        try {
            String endpointURI;
            byte mode;
            this.tcpConnection = con;
            int socketport = this.getLocalPort();
            JCSystemAccessor accessor = JCSystemAccessor.getJCSystemAccessor();
            if (socketport == accessor.getPortFromContext(appURI)) {
                mode = 1;
                HttpUrl url = appURI.startsWith("///") ? new HttpUrl("https", "//:" + socketport + appURI.substring(2)) : new HttpUrl("https", "//:" + socketport + appURI);
                endpointURI = url.normalize(443, true);
            } else {
                mode = 3;
                HttpUrl url = new HttpUrl("ssl", "//:" + socketport);
                endpointURI = url.normalize(-1, false);
            }
            this.sslConnection = new SSLStreamConnection(endpointURI, this.getAddress(), this.getPort(), this.tcpConnection.openInputStream(), this.tcpConnection.openOutputStream(), mode, appURI);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("unexpected exception - com.sun.midp.io.j2me.ssl.Protocol");
        }
    }

    @Override
    public Connection openPrim(String name, int mode, boolean timeouts) throws IOException {
        if (name.charAt(0) != '/' || name.charAt(1) != '/') {
            throw new IllegalArgumentException("Protocol must start with \"//\"");
        }
        HttpUrl url = new HttpUrl("ssl", name);
        if (url.path != null || url.query != null || url.fragment != null) {
            throw new IllegalArgumentException("Malformed address");
        }
        if (url.host != null) {
            this.tcpConnection = new com.sun.midp.io.j2me.socket.Protocol("ssl", -1, false);
            this.tcpConnection.openPrim("//" + url.authority);
            try {
                OutputStream tcpOutputStream = this.tcpConnection.openOutputStream();
                try {
                    InputStream tcpInputStream = this.tcpConnection.openInputStream();
                    String endpointURI = url.normalize(-1, false);
                    try {
                        this.sslConnection = new SSLStreamConnection(endpointURI, url.host, url.port, tcpInputStream, tcpOutputStream, 2, JCSystem.getURI());
                    }
                    catch (IOException e) {
                        tcpInputStream.close();
                        throw e;
                    }
                }
                catch (IOException e) {
                    tcpOutputStream.close();
                    throw e;
                }
            }
            catch (IOException e) {
                this.tcpConnection.close();
                throw e;
            }
            return this;
        }
        SSLSocket con = new SSLSocket();
        con.open(url.port);
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.sslConnection != null) {
                this.sslConnection.close();
            }
        }
        finally {
            if (this.tcpConnection != null) {
                this.tcpConnection.close();
            }
        }
        NativeMethods.removeConnection(this);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.sslConnection.openInputStream();
    }

    @Override
    public DataInputStream openDataInputStream() throws IOException {
        return this.sslConnection.openDataInputStream();
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return this.sslConnection.openOutputStream();
    }

    @Override
    public DataOutputStream openDataOutputStream() throws IOException {
        return this.sslConnection.openDataOutputStream();
    }

    @Override
    public void setSocketOption(byte option, int value) throws IllegalArgumentException, IOException {
        this.tcpConnection.setSocketOption(option, value);
    }

    @Override
    public int getSocketOption(byte option) throws IllegalArgumentException, IOException {
        return this.tcpConnection.getSocketOption(option);
    }

    @Override
    public String getLocalAddress() throws IOException {
        return this.tcpConnection.getLocalAddress();
    }

    @Override
    public int getLocalPort() throws IOException {
        return this.tcpConnection.getLocalPort();
    }

    @Override
    public String getAddress() throws IOException {
        return this.tcpConnection.getAddress();
    }

    @Override
    public int getPort() throws IOException {
        return this.tcpConnection.getPort();
    }

    @Override
    public SecurityInfo getSecurityInfo() throws IOException {
        return this.sslConnection.getSecurityInfo();
    }
}

